/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;

public class PngChunkPLTE
extends PngChunk {
    public int nentries = 0;
    public int[] entries;

    public PngChunkPLTE(ImageInfo info) {
        super("PLTE", info);
    }

    public ChunkRaw createChunk() {
        int len = 3 * this.nentries;
        int[] rgb = new int[3];
        ChunkRaw c = this.createEmptyChunk(len, true);
        int n = 0;
        int i = 0;
        while (n < this.nentries) {
            this.getEntryRgb(n, rgb);
            c.data[i++] = (byte)rgb[0];
            c.data[i++] = (byte)rgb[1];
            c.data[i++] = (byte)rgb[2];
            ++n;
        }
        return c;
    }

    public void parseFromChunk(ChunkRaw chunk) {
        this.setNentries(chunk.len / 3);
        int n = 0;
        int i = 0;
        while (n < this.nentries) {
            this.setEntry(n, chunk.data[i++] & 0xFF, chunk.data[i++] & 0xFF, chunk.data[i++] & 0xFF);
            ++n;
        }
    }

    public void setNentries(int n) {
        this.nentries = n;
        if (this.nentries < 1 || this.nentries > 256) {
            throw new PngjException("invalid pallette - nentries=" + this.nentries);
        }
        if (this.entries == null || this.entries.length != this.nentries) {
            this.entries = new int[this.nentries];
        }
    }

    public int getNentries() {
        return this.nentries;
    }

    public void setEntry(int n, int r, int g, int b) {
        this.entries[n] = r << 16 | g << 8 | b;
    }

    public int getEntry(int n) {
        return this.entries[n];
    }

    public void getEntryRgb(int n, int[] rgb) {
        this.getEntryRgb(n, rgb, 0);
    }

    public void getEntryRgb(int n, int[] rgb, int offset) {
        int v = this.entries[n];
        rgb[offset + 0] = (v & 0xFF0000) >> 16;
        rgb[offset + 1] = (v & 0xFF00) >> 8;
        rgb[offset + 2] = v & 0xFF;
    }

    public int minBitDepth() {
        if (this.nentries <= 2) {
            return 1;
        }
        if (this.nentries <= 4) {
            return 2;
        }
        if (this.nentries <= 16) {
            return 4;
        }
        return 8;
    }

    public void cloneDataFromRead(PngChunk other) {
        PngChunkPLTE otherx = (PngChunkPLTE)other;
        this.setNentries(otherx.getNentries());
        System.arraycopy(otherx.entries, 0, this.entries, 0, this.nentries);
    }
}

