/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;

public class PngChunkSRGB
extends PngChunk {
    public static final int RENDER_INTENT_Perceptual = 0;
    public static final int RENDER_INTENT_Relative_colorimetric = 1;
    public static final int RENDER_INTENT_Saturation = 2;
    public static final int RENDER_INTENT_Absolute_colorimetric = 3;
    private int intent;

    public PngChunkSRGB(ImageInfo info) {
        super("sRGB", info);
    }

    public void parseFromChunk(ChunkRaw c) {
        if (c.len != 1) {
            throw new PngjException("bad chunk length " + c);
        }
        this.intent = PngHelper.readInt1fromByte(c.data, 0);
    }

    public ChunkRaw createChunk() {
        ChunkRaw c = null;
        c = this.createEmptyChunk(1, true);
        c.data[0] = (byte)this.intent;
        return c;
    }

    public void cloneDataFromRead(PngChunk other) {
        PngChunkSRGB otherx = (PngChunkSRGB)other;
        this.intent = otherx.intent;
    }
}

