/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import java.util.Calendar;

public class PngChunkTIME
extends PngChunk {
    public int year;
    public int mon;
    public int day;
    public int h;
    public int m;
    public int s;

    public PngChunkTIME(ImageInfo info) {
        super("tIME", info);
    }

    public ChunkRaw createChunk() {
        ChunkRaw c = this.createEmptyChunk(7, true);
        PngHelper.writeInt2tobytes(this.year, c.data, 0);
        c.data[2] = (byte)this.mon;
        c.data[3] = (byte)this.day;
        c.data[4] = (byte)this.h;
        c.data[5] = (byte)this.m;
        c.data[6] = (byte)this.s;
        return c;
    }

    public void parseFromChunk(ChunkRaw chunk) {
        if (chunk.len != 7) {
            throw new PngjException("bad chunk " + chunk);
        }
        this.year = PngHelper.readInt2fromBytes(chunk.data, 0);
        this.mon = PngHelper.readInt1fromByte(chunk.data, 2);
        this.day = PngHelper.readInt1fromByte(chunk.data, 3);
        this.h = PngHelper.readInt1fromByte(chunk.data, 4);
        this.m = PngHelper.readInt1fromByte(chunk.data, 5);
        this.s = PngHelper.readInt1fromByte(chunk.data, 6);
    }

    public void cloneDataFromRead(PngChunk other) {
        PngChunkTIME x = (PngChunkTIME)other;
        this.year = x.year;
        this.mon = x.mon;
        this.day = x.day;
        this.h = x.h;
        this.m = x.m;
        this.s = x.s;
    }

    public void setNow(int secsAgo) {
        Calendar d = Calendar.getInstance();
        d.setTimeInMillis(System.currentTimeMillis() - 1000L * (long)secsAgo);
        this.year = d.get(1);
        this.mon = d.get(2) + 1;
        this.day = d.get(5);
        this.h = d.get(11);
        this.m = d.get(12);
        this.s = d.get(13);
    }
}

