/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;

public class PngChunkTRNS
extends PngChunk {
    private int gray;
    private int red;
    private int green;
    private int blue;
    private int[] paletteAlpha;

    public PngChunkTRNS(ImageInfo info) {
        super("tRNS", info);
    }

    public ChunkRaw createChunk() {
        ChunkRaw c = null;
        if (this.imgInfo.greyscale) {
            c = this.createEmptyChunk(2, true);
            PngHelper.writeInt2tobytes(this.gray, c.data, 0);
        } else if (this.imgInfo.indexed) {
            c = this.createEmptyChunk(this.paletteAlpha.length, true);
            int n = 0;
            while (n < c.len) {
                c.data[n] = (byte)this.paletteAlpha[n];
                ++n;
            }
        } else {
            c = this.createEmptyChunk(6, true);
            PngHelper.writeInt2tobytes(this.red, c.data, 0);
            PngHelper.writeInt2tobytes(this.green, c.data, 0);
            PngHelper.writeInt2tobytes(this.blue, c.data, 0);
        }
        return c;
    }

    public void parseFromChunk(ChunkRaw c) {
        if (this.imgInfo.greyscale) {
            this.gray = PngHelper.readInt2fromBytes(c.data, 0);
        } else if (this.imgInfo.indexed) {
            int nentries = c.data.length;
            this.paletteAlpha = new int[nentries];
            int n = 0;
            while (n < nentries) {
                this.paletteAlpha[n] = c.data[n] & 0xFF;
                ++n;
            }
        } else {
            this.red = PngHelper.readInt2fromBytes(c.data, 0);
            this.green = PngHelper.readInt2fromBytes(c.data, 2);
            this.blue = PngHelper.readInt2fromBytes(c.data, 4);
        }
    }

    public void cloneDataFromRead(PngChunk other) {
        PngChunkTRNS otherx = (PngChunkTRNS)other;
        this.gray = otherx.gray;
        this.red = otherx.red;
        this.green = otherx.red;
        this.blue = otherx.red;
        this.paletteAlpha = otherx.paletteAlpha;
    }
}

