/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.hdf5.HDF5AbstractStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5CompoundType;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueMDArray;
import ch.systemsx.cisd.hdf5.HDF5Reader;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.HDF5Writer;
import ch.systemsx.cisd.hdf5.IHDF5CompoundInformationRetriever;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.StringUtils;
import ch.systemsx.cisd.hdf5.cleanup.CleanUpRegistry;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import ncsa.hdf.hdf5lib.exceptions.HDF5DatasetInterfaceException;
import ncsa.hdf.hdf5lib.exceptions.HDF5FileNotFoundException;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

final class HDF5BaseWriter
extends HDF5BaseReader {
    private static final int SHUTDOWN_TIMEOUT_SECONDS = 60;
    private static final int MAX_TYPE_VARIANT_TYPES = 1024;
    private static final EnumSet<IHDF5WriterConfigurator.SyncMode> BLOCKING_SYNC_MODES = EnumSet.of(IHDF5WriterConfigurator.SyncMode.SYNC_BLOCK, IHDF5WriterConfigurator.SyncMode.SYNC_ON_FLUSH_BLOCK);
    private static final EnumSet<IHDF5WriterConfigurator.SyncMode> NON_BLOCKING_SYNC_MODES = EnumSet.of(IHDF5WriterConfigurator.SyncMode.SYNC, IHDF5WriterConfigurator.SyncMode.SYNC_ON_FLUSH);
    private static final EnumSet<IHDF5WriterConfigurator.SyncMode> SYNC_ON_CLOSE_MODES = EnumSet.of(IHDF5WriterConfigurator.SyncMode.SYNC_BLOCK, IHDF5WriterConfigurator.SyncMode.SYNC);
    static final int COMPACT_LAYOUT_THRESHOLD = 256;
    private static final ExecutorService syncExecutor = new NamingThreadPoolExecutor("HDF5 Sync").corePoolSize(3).daemonize();
    private final RandomAccessFile fileForSyncing;
    private final BlockingQueue<Command> commandQueue;
    private final Set<Flushable> flushables = new LinkedHashSet<Flushable>();
    final boolean useExtentableDataTypes;
    final boolean overwriteFile;
    final boolean keepDataSetIfExists;
    final IHDF5WriterConfigurator.SyncMode syncMode;
    final IHDF5WriterConfigurator.FileFormat fileFormat;
    final int variableLengthStringDataTypeId;

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                syncExecutor.shutdownNow();
                try {
                    syncExecutor.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    HDF5BaseWriter(File hdf5File, boolean performNumericConversions, boolean useUTF8CharEncoding, boolean autoDereference, IHDF5WriterConfigurator.FileFormat fileFormat, boolean useExtentableDataTypes, boolean overwriteFile, boolean keepDataSetIfExists, String preferredHouseKeepingNameSuffix, IHDF5WriterConfigurator.SyncMode syncMode) {
        super(hdf5File, performNumericConversions, useUTF8CharEncoding, autoDereference, fileFormat, overwriteFile, preferredHouseKeepingNameSuffix);
        try {
            this.fileForSyncing = new RandomAccessFile(hdf5File, "rw");
        }
        catch (FileNotFoundException ex) {
            throw new HDF5JavaException("Cannot open RandomAccessFile: " + ex.getMessage());
        }
        this.fileFormat = fileFormat;
        this.useExtentableDataTypes = useExtentableDataTypes;
        this.overwriteFile = overwriteFile;
        this.keepDataSetIfExists = keepDataSetIfExists;
        this.syncMode = syncMode;
        this.readNamedDataTypes();
        this.variableLengthStringDataTypeId = this.openOrCreateVLStringType();
        this.saveNonDefaultHouseKeepingNameSuffix();
        this.commandQueue = new LinkedBlockingQueue<Command>();
        this.setupSyncThread();
    }

    private void setupSyncThread() {
        syncExecutor.execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        block9: while (true) {
                            switch ((Command)((Object)HDF5BaseWriter.this.commandQueue.take())) {
                                case SYNC: {
                                    HDF5BaseWriter.this.syncNow();
                                    continue block9;
                                }
                                case CLOSE_ON_EXIT: {
                                    HDF5BaseWriter.this.closeNow();
                                    return;
                                }
                                case CLOSE_SYNC: {
                                    HDF5BaseWriter.this.closeSync();
                                    return;
                                }
                                case EXIT: {
                                    return;
                                }
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        HDF5BaseWriter.this.commandQueue.add(Command.CLOSE_ON_EXIT);
                        continue;
                    }
                    break;
                }
            }
        });
    }

    @Override
    int openFile(IHDF5WriterConfigurator.FileFormat fileFormatInit, boolean overwriteInit) {
        boolean enforce_1_8;
        boolean bl = enforce_1_8 = fileFormatInit == IHDF5WriterConfigurator.FileFormat.STRICTLY_1_8;
        if (this.hdf5File.exists() && !overwriteInit) {
            if (!this.hdf5File.canWrite()) {
                throw new HDF5FileNotFoundException(this.hdf5File, "File is not writable.");
            }
            return this.h5.openFileReadWrite(this.hdf5File.getPath(), enforce_1_8, this.fileRegistry);
        }
        File directory = this.hdf5File.getParentFile();
        if (!directory.exists()) {
            throw new HDF5FileNotFoundException(directory, "Directory does not exist.");
        }
        if (!directory.canWrite()) {
            throw new HDF5FileNotFoundException(directory, "Directory is not writable.");
        }
        return this.h5.createFile(this.hdf5File.getPath(), enforce_1_8, this.fileRegistry);
    }

    private void syncNow() {
        try {
            this.fileForSyncing.getFD().sync();
        }
        catch (IOException ex) {
            String msg = ex.getMessage() == null ? ex.getClass().getSimpleName() : ex.getMessage();
            throw new HDF5JavaException("Error syncing file: " + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeNow() {
        CleanUpRegistry cleanUpRegistry = this.fileRegistry;
        synchronized (cleanUpRegistry) {
            if (this.state == HDF5BaseReader.State.OPEN) {
                this.flushExternals();
                this.flushables.clear();
                super.close();
                if (SYNC_ON_CLOSE_MODES.contains((Object)this.syncMode)) {
                    this.syncNow();
                }
                this.closeSync();
            }
        }
    }

    private void closeSync() {
        try {
            this.fileForSyncing.close();
        }
        catch (IOException ex) {
            throw new HDF5JavaException("Error closing file: " + ex.getMessage());
        }
    }

    boolean addFlushable(Flushable flushable) {
        return this.flushables.add(flushable);
    }

    boolean removeFlushable(Flushable flushable) {
        return this.flushables.remove(flushable);
    }

    void flushExternals() {
        for (Flushable f : this.flushables) {
            try {
                f.flush();
            }
            catch (Throwable ex) {
                if (f instanceof IErrorStrategy) {
                    ((IErrorStrategy)f).dealWithError(ex);
                    continue;
                }
                throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        CleanUpRegistry cleanUpRegistry = this.fileRegistry;
        synchronized (cleanUpRegistry) {
            this.flushExternals();
            this.h5.flushFile(this.fileId);
            if (NON_BLOCKING_SYNC_MODES.contains((Object)this.syncMode)) {
                this.commandQueue.add(Command.SYNC);
            } else if (BLOCKING_SYNC_MODES.contains((Object)this.syncMode)) {
                this.syncNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushSyncBlocking() {
        CleanUpRegistry cleanUpRegistry = this.fileRegistry;
        synchronized (cleanUpRegistry) {
            this.flushExternals();
            this.h5.flushFile(this.fileId);
            this.syncNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        CleanUpRegistry cleanUpRegistry = this.fileRegistry;
        synchronized (cleanUpRegistry) {
            if (this.state == HDF5BaseReader.State.OPEN) {
                this.flushExternals();
                this.flushables.clear();
                super.close();
                if (IHDF5WriterConfigurator.SyncMode.SYNC == this.syncMode) {
                    this.commandQueue.add(Command.SYNC);
                } else if (IHDF5WriterConfigurator.SyncMode.SYNC_BLOCK == this.syncMode) {
                    this.syncNow();
                }
                if (EnumSet.complementOf(NON_BLOCKING_SYNC_MODES).contains((Object)this.syncMode)) {
                    this.closeSync();
                    this.commandQueue.add(Command.EXIT);
                } else {
                    this.commandQueue.add(Command.CLOSE_SYNC);
                }
            }
        }
    }

    void saveNonDefaultHouseKeepingNameSuffix() {
        if ("".equals(this.houseKeepingNameSuffix)) {
            return;
        }
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int objectId = HDF5BaseWriter.this.h5.openObject(HDF5BaseWriter.this.fileId, "/", registry);
                HDF5BaseWriter.this.setStringAttribute(objectId, "__HOUSEKEEPING_SUFFIX__", HDF5BaseWriter.this.houseKeepingNameSuffix, HDF5BaseWriter.this.houseKeepingNameSuffix.length(), false, registry);
                HDF5BaseWriter.this.setIntAttributeAutoSize(objectId, "__STRING_LENGTH____HOUSEKEEPING_SUFFIX____", HDF5BaseWriter.this.houseKeepingNameSuffix.length(), registry);
                return null;
            }
        };
        this.runner.call(addAttributeRunnable);
    }

    private void setIntAttributeAutoSize(int objectId, String attributeName, int value, ICleanUpRegistry registry) {
        if (value > Short.MAX_VALUE) {
            this.setAttribute(objectId, attributeName, HDF5Constants.H5T_STD_I32LE, HDF5Constants.H5T_NATIVE_INT32, new int[]{value}, registry);
        } else if (value > 127) {
            this.setAttribute(objectId, attributeName, HDF5Constants.H5T_STD_I16LE, HDF5Constants.H5T_NATIVE_INT16, new int[]{value}, registry);
        } else {
            this.setAttribute(objectId, attributeName, HDF5Constants.H5T_STD_I8LE, HDF5Constants.H5T_NATIVE_INT8, new byte[]{(byte)value}, registry);
        }
    }

    @Override
    void commitDataType(String dataTypePath, int dataTypeId) {
        this.h5.commitDataType(this.fileId, dataTypePath, dataTypeId);
    }

    HDF5EnumerationType openOrCreateTypeVariantDataType(HDF5Writer writer) {
        HDF5EnumerationType dataType;
        String typeVariantTypePath = HDF5Utils.getTypeVariantDataTypePath(this.houseKeepingNameSuffix);
        int dataTypeId = this.getDataTypeId(typeVariantTypePath);
        if (dataTypeId < 0 || this.h5.getNumberOfMembers(dataTypeId) < HDF5DataTypeVariant.values().length) {
            String typeVariantPath = this.findFirstUnusedTypeVariantPath(writer);
            dataType = this.createTypeVariantDataType();
            this.commitDataType(typeVariantPath, dataType.getStorageTypeId());
            writer.createOrUpdateSoftLink(typeVariantPath.substring(HDF5Utils.getDataTypeGroup(this.houseKeepingNameSuffix).length() + 1), typeVariantTypePath);
        } else {
            int nativeDataTypeId = this.h5.getNativeDataType(dataTypeId, this.fileRegistry);
            String[] typeVariantNames = this.h5.getNamesForEnumOrCompoundMembers(dataTypeId);
            dataType = new HDF5EnumerationType(this.fileId, dataTypeId, nativeDataTypeId, typeVariantTypePath, typeVariantNames, this);
        }
        return dataType;
    }

    void setEnumArrayAttribute(final String objectPath, final String name, final HDF5EnumerationValueArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int baseMemoryTypeId = value.getType().getNativeTypeId();
                int memoryTypeId = HDF5BaseWriter.this.h5.createArrayType(baseMemoryTypeId, value.getLength(), registry);
                int baseStorageTypeId = value.getType().getStorageTypeId();
                int storageTypeId = HDF5BaseWriter.this.h5.createArrayType(baseStorageTypeId, value.getLength(), registry);
                HDF5BaseWriter.this.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value.toStorageForm());
                return null;
            }
        };
        this.runner.call(setAttributeRunnable);
    }

    void setEnumMDArrayAttribute(final String objectPath, final String name, final HDF5EnumerationValueMDArray value) {
        assert (objectPath != null);
        assert (name != null);
        assert (value != null);
        this.checkOpen();
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int baseMemoryTypeId = value.getType().getNativeTypeId();
                int memoryTypeId = HDF5BaseWriter.this.h5.createArrayType(baseMemoryTypeId, value.dimensions(), registry);
                int baseStorageTypeId = value.getType().getStorageTypeId();
                int storageTypeId = HDF5BaseWriter.this.h5.createArrayType(baseStorageTypeId, value.dimensions(), registry);
                HDF5BaseWriter.this.setAttribute(objectPath, name, storageTypeId, memoryTypeId, value.toStorageForm());
                return null;
            }
        };
        this.runner.call(setAttributeRunnable);
    }

    <T> void setCompoundArrayAttribute(final String objectPath, final String attributeName, final HDF5CompoundType<T> type, final T[] data, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        assert (objectPath != null);
        assert (attributeName != null);
        assert (data != null);
        this.checkOpen();
        type.check(this.fileId);
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                byte[] byteArray = type.getObjectByteifyer().byteify(type.getStorageTypeId(), data);
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArray);
                }
                int baseMemoryTypeId = type.getNativeTypeId();
                int memoryTypeId = HDF5BaseWriter.this.h5.createArrayType(baseMemoryTypeId, data.length, registry);
                int baseStorageTypeId = type.getStorageTypeId();
                int storageTypeId = HDF5BaseWriter.this.h5.createArrayType(baseStorageTypeId, data.length, registry);
                HDF5BaseWriter.this.setAttribute(objectPath, attributeName, storageTypeId, memoryTypeId, byteArray);
                return null;
            }
        };
        this.runner.call(setAttributeRunnable);
    }

    <T> void setCompoundMDArrayAttribute(final String objectPath, final String attributeName, final HDF5CompoundType<T> type, final MDArray<T> data, final IHDF5CompoundInformationRetriever.IByteArrayInspector inspectorOrNull) {
        assert (objectPath != null);
        assert (attributeName != null);
        assert (data != null);
        this.checkOpen();
        type.check(this.fileId);
        ICallableWithCleanUp<Void> setAttributeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                byte[] byteArray = type.getObjectByteifyer().byteify(type.getStorageTypeId(), data.getAsFlatArray());
                if (inspectorOrNull != null) {
                    inspectorOrNull.inspect(byteArray);
                }
                int baseMemoryTypeId = type.getNativeTypeId();
                int memoryTypeId = HDF5BaseWriter.this.h5.createArrayType(baseMemoryTypeId, data.dimensions(), registry);
                int baseStorageTypeId = type.getStorageTypeId();
                int storageTypeId = HDF5BaseWriter.this.h5.createArrayType(baseStorageTypeId, data.dimensions(), registry);
                HDF5BaseWriter.this.setAttribute(objectPath, attributeName, storageTypeId, memoryTypeId, byteArray);
                return null;
            }
        };
        this.runner.call(setAttributeRunnable);
    }

    private String findFirstUnusedTypeVariantPath(HDF5Reader reader) {
        String path;
        int number = 0;
        while (reader.exists(path = String.valueOf(HDF5Utils.getTypeVariantDataTypePath(this.houseKeepingNameSuffix)) + "." + number++, false) && number < 1024) {
        }
        return path;
    }

    private int openOrCreateVLStringType() {
        String variableLengthStringTypePath = HDF5Utils.getVariableLengthStringDataTypePath(this.houseKeepingNameSuffix);
        int dataTypeId = this.getDataTypeId(variableLengthStringTypePath);
        if (dataTypeId < 0) {
            dataTypeId = this.h5.createDataTypeVariableString(this.fileRegistry);
            this.commitDataType(variableLengthStringTypePath, dataTypeId);
        }
        return dataTypeId;
    }

    void writeScalar(final String dataSetPath, final int storageDataTypeId, final int nativeDataTypeId, final byte[] value) {
        assert (dataSetPath != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        assert (value != null);
        ICallableWithCleanUp<Object> writeScalarRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                HDF5BaseWriter.this.writeScalar(dataSetPath, storageDataTypeId, nativeDataTypeId, value, true, HDF5BaseWriter.this.keepDataSetIfExists, registry);
                return null;
            }
        };
        this.runner.call(writeScalarRunnable);
    }

    int writeScalar(String dataSetPath, int storageDataTypeId, int nativeDataTypeId, byte[] value, boolean compactLayout, boolean keepDatasetIfExists, ICleanUpRegistry registry) {
        boolean exists = this.h5.exists(this.fileId, dataSetPath);
        if (exists && !keepDatasetIfExists) {
            this.h5.deleteObject(this.fileId, dataSetPath);
            exists = false;
        }
        int dataSetId = exists ? this.h5.openObject(this.fileId, dataSetPath, registry) : this.h5.createScalarDataSet(this.fileId, storageDataTypeId, dataSetPath, compactLayout, registry);
        H5D.H5Dwrite(dataSetId, nativeDataTypeId, HDF5Constants.H5S_SCALAR, HDF5Constants.H5S_SCALAR, HDF5Constants.H5P_DEFAULT, value);
        return dataSetId;
    }

    void writeScalar(final String dataSetPath, final int storageDataTypeId, final int nativeDataTypeId, final byte value) {
        assert (dataSetPath != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        ICallableWithCleanUp<Object> writeScalarRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                HDF5BaseWriter.this.writeScalar(dataSetPath, storageDataTypeId, nativeDataTypeId, value, true, true, registry);
                return null;
            }
        };
        this.runner.call(writeScalarRunnable);
    }

    int writeScalar(String dataSetPath, int storageDataTypeId, int nativeDataTypeId, byte value, boolean compactLayout, boolean keepDatasetIfExists, ICleanUpRegistry registry) {
        boolean exists = this.h5.exists(this.fileId, dataSetPath);
        if (exists && !keepDatasetIfExists) {
            this.h5.deleteObject(this.fileId, dataSetPath);
            exists = false;
        }
        int dataSetId = exists ? this.h5.openObject(this.fileId, dataSetPath, registry) : this.h5.createScalarDataSet(this.fileId, storageDataTypeId, dataSetPath, compactLayout, registry);
        H5D.H5Dwrite(dataSetId, nativeDataTypeId, HDF5Constants.H5S_SCALAR, HDF5Constants.H5S_SCALAR, HDF5Constants.H5P_DEFAULT, new byte[]{value});
        return dataSetId;
    }

    void writeScalar(final String dataSetPath, final int storageDataTypeId, final int nativeDataTypeId, final short value) {
        assert (dataSetPath != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        ICallableWithCleanUp<Object> writeScalarRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                HDF5BaseWriter.this.writeScalar(dataSetPath, storageDataTypeId, nativeDataTypeId, value, true, true, registry);
                return null;
            }
        };
        this.runner.call(writeScalarRunnable);
    }

    int writeScalar(String dataSetPath, int storageDataTypeId, int nativeDataTypeId, short value, boolean compactLayout, boolean keepDatasetIfExists, ICleanUpRegistry registry) {
        boolean exists = this.h5.exists(this.fileId, dataSetPath);
        if (exists && !keepDatasetIfExists) {
            this.h5.deleteObject(this.fileId, dataSetPath);
            exists = false;
        }
        int dataSetId = exists ? this.h5.openObject(this.fileId, dataSetPath, registry) : this.h5.createScalarDataSet(this.fileId, storageDataTypeId, dataSetPath, compactLayout, registry);
        H5D.H5Dwrite(dataSetId, nativeDataTypeId, HDF5Constants.H5S_SCALAR, HDF5Constants.H5S_SCALAR, HDF5Constants.H5P_DEFAULT, new short[]{value});
        return dataSetId;
    }

    void writeScalar(final String dataSetPath, final int storageDataTypeId, final int nativeDataTypeId, final int value) {
        assert (dataSetPath != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        ICallableWithCleanUp<Object> writeScalarRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                HDF5BaseWriter.this.writeScalar(dataSetPath, storageDataTypeId, nativeDataTypeId, value, true, true, registry);
                return null;
            }
        };
        this.runner.call(writeScalarRunnable);
    }

    int writeScalar(String dataSetPath, int storageDataTypeId, int nativeDataTypeId, int value, boolean compactLayout, boolean keepDatasetIfExists, ICleanUpRegistry registry) {
        boolean exists = this.h5.exists(this.fileId, dataSetPath);
        if (exists && !keepDatasetIfExists) {
            this.h5.deleteObject(this.fileId, dataSetPath);
            exists = false;
        }
        int dataSetId = exists ? this.h5.openObject(this.fileId, dataSetPath, registry) : this.h5.createScalarDataSet(this.fileId, storageDataTypeId, dataSetPath, compactLayout, registry);
        H5D.H5Dwrite(dataSetId, nativeDataTypeId, HDF5Constants.H5S_SCALAR, HDF5Constants.H5S_SCALAR, HDF5Constants.H5P_DEFAULT, new int[]{value});
        return dataSetId;
    }

    void writeScalar(final String dataSetPath, final int storageDataTypeId, final int nativeDataTypeId, final long value) {
        assert (dataSetPath != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        ICallableWithCleanUp<Object> writeScalarRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                HDF5BaseWriter.this.writeScalar(dataSetPath, storageDataTypeId, nativeDataTypeId, value, true, true, registry);
                return null;
            }
        };
        this.runner.call(writeScalarRunnable);
    }

    int writeScalar(String dataSetPath, int storageDataTypeId, int nativeDataTypeId, long value, boolean compactLayout, boolean keepDatasetIfExists, ICleanUpRegistry registry) {
        boolean exists = this.h5.exists(this.fileId, dataSetPath);
        if (exists && !keepDatasetIfExists) {
            this.h5.deleteObject(this.fileId, dataSetPath);
            exists = false;
        }
        int dataSetId = exists ? this.h5.openObject(this.fileId, dataSetPath, registry) : this.h5.createScalarDataSet(this.fileId, storageDataTypeId, dataSetPath, compactLayout, registry);
        H5D.H5Dwrite(dataSetId, nativeDataTypeId, HDF5Constants.H5S_SCALAR, HDF5Constants.H5S_SCALAR, HDF5Constants.H5P_DEFAULT, new long[]{value});
        return dataSetId;
    }

    void writeScalar(final String dataSetPath, final int storageDataTypeId, final int nativeDataTypeId, final float value) {
        assert (dataSetPath != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        ICallableWithCleanUp<Object> writeScalarRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                HDF5BaseWriter.this.writeScalar(dataSetPath, storageDataTypeId, nativeDataTypeId, value, true, HDF5BaseWriter.this.keepDataSetIfExists, registry);
                return null;
            }
        };
        this.runner.call(writeScalarRunnable);
    }

    int writeScalar(String dataSetPath, int storageDataTypeId, int nativeDataTypeId, float value, boolean compactLayout, boolean keepDatasetIfExists, ICleanUpRegistry registry) {
        boolean exists = this.h5.exists(this.fileId, dataSetPath);
        if (exists && !keepDatasetIfExists) {
            this.h5.deleteObject(this.fileId, dataSetPath);
            exists = false;
        }
        int dataSetId = exists ? this.h5.openObject(this.fileId, dataSetPath, registry) : this.h5.createScalarDataSet(this.fileId, storageDataTypeId, dataSetPath, compactLayout, registry);
        H5D.H5Dwrite(dataSetId, nativeDataTypeId, HDF5Constants.H5S_SCALAR, HDF5Constants.H5S_SCALAR, HDF5Constants.H5P_DEFAULT, new float[]{value});
        return dataSetId;
    }

    void writeScalar(final String dataSetPath, final int storageDataTypeId, final int nativeDataTypeId, final double value) {
        assert (dataSetPath != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        ICallableWithCleanUp<Object> writeScalarRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                HDF5BaseWriter.this.writeScalar(dataSetPath, storageDataTypeId, nativeDataTypeId, value, true, true, registry);
                return null;
            }
        };
        this.runner.call(writeScalarRunnable);
    }

    int writeScalar(String dataSetPath, int storageDataTypeId, int nativeDataTypeId, double value, boolean compactLayout, boolean keepDatasetIfExists, ICleanUpRegistry registry) {
        boolean exists = this.h5.exists(this.fileId, dataSetPath);
        if (exists && !keepDatasetIfExists) {
            this.h5.deleteObject(this.fileId, dataSetPath);
            exists = false;
        }
        int dataSetId = exists ? this.h5.openObject(this.fileId, dataSetPath, registry) : this.h5.createScalarDataSet(this.fileId, storageDataTypeId, dataSetPath, compactLayout, registry);
        H5D.H5Dwrite(dataSetId, nativeDataTypeId, HDF5Constants.H5S_SCALAR, HDF5Constants.H5S_SCALAR, HDF5Constants.H5P_DEFAULT, new double[]{value});
        return dataSetId;
    }

    void writeStringVL(int dataSetId, int memorySpaceId, int fileSpaceId, String[] value) {
        this.h5.writeStringVL(dataSetId, this.variableLengthStringDataTypeId, memorySpaceId, fileSpaceId, value);
    }

    void writeStringVL(int dataSetId, String[] value) {
        this.h5.writeStringVL(dataSetId, this.variableLengthStringDataTypeId, value);
    }

    void writeAttributeStringVL(int attributeId, String[] value) {
        this.h5.writeAttributeStringVL(attributeId, this.variableLengthStringDataTypeId, value);
    }

    int createDataSet(String objectPath, int storageDataTypeId, HDF5AbstractStorageFeatures features, long[] dimensions, long[] chunkSizeOrNull, int elementLength, ICleanUpRegistry registry) {
        boolean chunkSizeProvided;
        boolean empty = HDF5Utils.isEmpty(dimensions);
        boolean bl = chunkSizeProvided = chunkSizeOrNull != null && !HDF5Utils.isNonPositive(chunkSizeOrNull);
        if (this.h5.exists(this.fileId, objectPath)) {
            if (this.keepDataIfExists(features)) {
                return this.h5.openDataSet(this.fileId, objectPath, registry);
            }
            this.h5.deleteObject(this.fileId, objectPath);
        }
        Object definitiveChunkSizeOrNull = empty ? (chunkSizeProvided ? chunkSizeOrNull : HDF5Utils.tryGetChunkSize(dimensions, elementLength, features.requiresChunking(), true)) : (Object)(features.tryGetProposedLayout() == HDF5StorageLayout.COMPACT || features.tryGetProposedLayout() == HDF5StorageLayout.CONTIGUOUS || !this.useExtentableDataTypes && !features.requiresChunking() ? null : (chunkSizeProvided ? chunkSizeOrNull : HDF5Utils.tryGetChunkSize(dimensions, elementLength, features.requiresChunking(), this.useExtentableDataTypes || features.tryGetProposedLayout() == HDF5StorageLayout.CHUNKED)));
        HDF5StorageLayout layout = this.determineLayout(storageDataTypeId, dimensions, (long[])definitiveChunkSizeOrNull, features.tryGetProposedLayout());
        int dataSetId = this.h5.createDataSet(this.fileId, dimensions, (long[])definitiveChunkSizeOrNull, storageDataTypeId, features, objectPath, layout, this.fileFormat, registry);
        return dataSetId;
    }

    boolean keepDataIfExists(HDF5AbstractStorageFeatures features) {
        switch (features.getDatasetReplacementPolicy()) {
            case ENFORCE_KEEP_EXISTING: {
                return true;
            }
            case ENFORCE_REPLACE_WITH_NEW: {
                return false;
            }
        }
        return this.keepDataSetIfExists;
    }

    HDF5StorageLayout determineLayout(int storageDataTypeId, long[] dimensions, long[] chunkSizeOrNull, HDF5StorageLayout proposedLayoutOrNull) {
        if (chunkSizeOrNull != null) {
            return HDF5StorageLayout.CHUNKED;
        }
        if (proposedLayoutOrNull != null) {
            return proposedLayoutOrNull;
        }
        if (this.computeSizeForDimensions(storageDataTypeId, dimensions) < 256) {
            return HDF5StorageLayout.COMPACT;
        }
        return HDF5StorageLayout.CONTIGUOUS;
    }

    private int computeSizeForDimensions(int dataTypeId, long[] dimensions) {
        int size = this.h5.getDataTypeSize(dataTypeId);
        long[] lArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            long d = lArray[n2];
            size = (int)((long)size * d);
            ++n2;
        }
        return size;
    }

    boolean areDimensionsInBounds(int dataSetId, long[] dimensions) {
        long[] maxDimensions = this.h5.getDataMaxDimensions(dataSetId);
        if (dimensions.length != maxDimensions.length) {
            return false;
        }
        int i = 0;
        while (i < dimensions.length) {
            if (maxDimensions[i] != (long)HDF5Constants.H5S_UNLIMITED && dimensions[i] > maxDimensions[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    int getOrCreateDataSetId(String objectPath, int storageDataTypeId, long[] dimensions, int elementLength, HDF5AbstractStorageFeatures features, ICleanUpRegistry registry) {
        boolean exists = this.h5.exists(this.fileId, objectPath);
        if (exists && !this.keepDataIfExists(features)) {
            this.h5.deleteObject(this.fileId, objectPath);
            exists = false;
        }
        int dataSetId = exists ? this.h5.openAndExtendDataSet(this.fileId, objectPath, this.fileFormat, dimensions, storageDataTypeId, registry) : this.createDataSet(objectPath, storageDataTypeId, features, dimensions, null, elementLength, registry);
        return dataSetId;
    }

    void setDataSetDimensions(String objectPath, long[] newDimensions, ICleanUpRegistry registry) {
        assert (newDimensions != null);
        int dataSetId = this.h5.openDataSet(this.fileId, objectPath, registry);
        try {
            this.h5.setDataSetExtentChunked(dataSetId, newDimensions);
        }
        catch (HDF5DatasetInterfaceException ex) {
            if (HDF5StorageLayout.CHUNKED != this.h5.getLayout(dataSetId, registry)) {
                throw new HDF5JavaException("Cannot change dimensions of non-extendable data set.");
            }
            throw ex;
        }
    }

    void setAttribute(final String objectPath, final String name, final int storageDataTypeId, final int nativeDataTypeId, final byte[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        assert (value != null);
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int objectId = HDF5BaseWriter.this.h5.openObject(HDF5BaseWriter.this.fileId, objectPath, registry);
                HDF5BaseWriter.this.setAttribute(objectId, name, storageDataTypeId, nativeDataTypeId, value, registry);
                return null;
            }
        };
        this.runner.call(addAttributeRunnable);
    }

    void setAttribute(int objectId, String name, int storageDataTypeId, int nativeDataTypeId, byte[] value, ICleanUpRegistry registry) {
        int attributeId;
        if (this.h5.existsAttribute(objectId, name)) {
            attributeId = this.h5.openAttribute(objectId, name, registry);
            int oldStorageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
            if (!this.h5.dataTypesAreEqual(oldStorageDataTypeId, storageDataTypeId)) {
                this.h5.deleteAttribute(objectId, name);
                attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
            }
        } else {
            attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
        }
        this.h5.writeAttribute(attributeId, nativeDataTypeId, value);
    }

    void setAttribute(final String objectPath, final String name, final int storageDataTypeId, final int nativeDataTypeId, final short[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        assert (value != null);
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int objectId = HDF5BaseWriter.this.h5.openObject(HDF5BaseWriter.this.fileId, objectPath, registry);
                HDF5BaseWriter.this.setAttribute(objectId, name, storageDataTypeId, nativeDataTypeId, value, registry);
                return null;
            }
        };
        this.runner.call(addAttributeRunnable);
    }

    void setAttribute(int objectId, String name, int storageDataTypeId, int nativeDataTypeId, short[] value, ICleanUpRegistry registry) {
        int attributeId;
        if (this.h5.existsAttribute(objectId, name)) {
            attributeId = this.h5.openAttribute(objectId, name, registry);
            int oldStorageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
            if (!this.h5.dataTypesAreEqual(oldStorageDataTypeId, storageDataTypeId)) {
                this.h5.deleteAttribute(objectId, name);
                attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
            }
        } else {
            attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
        }
        this.h5.writeAttribute(attributeId, nativeDataTypeId, value);
    }

    void setAttribute(final String objectPath, final String name, final int storageDataTypeId, final int nativeDataTypeId, final int[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        assert (value != null);
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int objectId = HDF5BaseWriter.this.h5.openObject(HDF5BaseWriter.this.fileId, objectPath, registry);
                HDF5BaseWriter.this.setAttribute(objectId, name, storageDataTypeId, nativeDataTypeId, value, registry);
                return null;
            }
        };
        this.runner.call(addAttributeRunnable);
    }

    void setAttribute(int objectId, String name, int storageDataTypeId, int nativeDataTypeId, int[] value, ICleanUpRegistry registry) {
        int attributeId;
        if (this.h5.existsAttribute(objectId, name)) {
            attributeId = this.h5.openAttribute(objectId, name, registry);
            int oldStorageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
            if (!this.h5.dataTypesAreEqual(oldStorageDataTypeId, storageDataTypeId)) {
                this.h5.deleteAttribute(objectId, name);
                attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
            }
        } else {
            attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
        }
        this.h5.writeAttribute(attributeId, nativeDataTypeId, value);
    }

    void setAttribute(final String objectPath, final String name, final int storageDataTypeId, final int nativeDataTypeId, final long[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        assert (value != null);
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int objectId = HDF5BaseWriter.this.h5.openObject(HDF5BaseWriter.this.fileId, objectPath, registry);
                HDF5BaseWriter.this.setAttribute(objectId, name, storageDataTypeId, nativeDataTypeId, value, registry);
                return null;
            }
        };
        this.runner.call(addAttributeRunnable);
    }

    void setAttribute(final String objectPath, final String name, final HDF5DataTypeVariant typeVariant, final int storageDataTypeId, final int nativeDataTypeId, final long[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        assert (value != null);
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int objectId = HDF5BaseWriter.this.h5.openObject(HDF5BaseWriter.this.fileId, objectPath, registry);
                HDF5BaseWriter.this.setAttribute(objectId, name, storageDataTypeId, nativeDataTypeId, value, registry);
                HDF5BaseWriter.this.setTypeVariant(objectId, name, typeVariant, registry);
                return null;
            }
        };
        this.runner.call(addAttributeRunnable);
    }

    void setAttribute(int objectId, String name, int storageDataTypeId, int nativeDataTypeId, long[] value, ICleanUpRegistry registry) {
        int attributeId;
        if (this.h5.existsAttribute(objectId, name)) {
            attributeId = this.h5.openAttribute(objectId, name, registry);
            int oldStorageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
            if (!this.h5.dataTypesAreEqual(oldStorageDataTypeId, storageDataTypeId)) {
                this.h5.deleteAttribute(objectId, name);
                attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
            }
        } else {
            attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
        }
        this.h5.writeAttribute(attributeId, nativeDataTypeId, value);
    }

    void setAttribute(final String objectPath, final String name, final int storageDataTypeId, final int nativeDataTypeId, final float[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        assert (value != null);
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int objectId = HDF5BaseWriter.this.h5.openObject(HDF5BaseWriter.this.fileId, objectPath, registry);
                HDF5BaseWriter.this.setAttribute(objectId, name, storageDataTypeId, nativeDataTypeId, value, registry);
                return null;
            }
        };
        this.runner.call(addAttributeRunnable);
    }

    void setAttribute(int objectId, String name, int storageDataTypeId, int nativeDataTypeId, float[] value, ICleanUpRegistry registry) {
        int attributeId;
        if (this.h5.existsAttribute(objectId, name)) {
            attributeId = this.h5.openAttribute(objectId, name, registry);
            int oldStorageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
            if (!this.h5.dataTypesAreEqual(oldStorageDataTypeId, storageDataTypeId)) {
                this.h5.deleteAttribute(objectId, name);
                attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
            }
        } else {
            attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
        }
        this.h5.writeAttribute(attributeId, nativeDataTypeId, value);
    }

    void setAttribute(final String objectPath, final String name, final int storageDataTypeId, final int nativeDataTypeId, final double[] value) {
        assert (objectPath != null);
        assert (name != null);
        assert (storageDataTypeId >= 0);
        assert (nativeDataTypeId >= 0);
        assert (value != null);
        ICallableWithCleanUp<Object> addAttributeRunnable = new ICallableWithCleanUp<Object>(){

            @Override
            public Object call(ICleanUpRegistry registry) {
                int objectId = HDF5BaseWriter.this.h5.openObject(HDF5BaseWriter.this.fileId, objectPath, registry);
                HDF5BaseWriter.this.setAttribute(objectId, name, storageDataTypeId, nativeDataTypeId, value, registry);
                return null;
            }
        };
        this.runner.call(addAttributeRunnable);
    }

    void setAttribute(int objectId, String name, int storageDataTypeId, int nativeDataTypeId, double[] value, ICleanUpRegistry registry) {
        int attributeId;
        if (this.h5.existsAttribute(objectId, name)) {
            attributeId = this.h5.openAttribute(objectId, name, registry);
            int oldStorageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
            if (!this.h5.dataTypesAreEqual(oldStorageDataTypeId, storageDataTypeId)) {
                this.h5.deleteAttribute(objectId, name);
                attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
            }
        } else {
            attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
        }
        this.h5.writeAttribute(attributeId, nativeDataTypeId, value);
    }

    void setTypeVariant(int objectId, HDF5DataTypeVariant typeVariant, ICleanUpRegistry registry) {
        this.setAttribute(objectId, HDF5Utils.createObjectTypeVariantAttributeName(this.houseKeepingNameSuffix), this.typeVariantDataType.getStorageTypeId(), this.typeVariantDataType.getNativeTypeId(), this.typeVariantDataType.toStorageForm(typeVariant.ordinal()), registry);
    }

    void setTypeVariant(int objectId, String attributeName, HDF5DataTypeVariant typeVariant, ICleanUpRegistry registry) {
        this.setAttribute(objectId, HDF5Utils.createAttributeTypeVariantAttributeName(attributeName, this.houseKeepingNameSuffix), this.typeVariantDataType.getStorageTypeId(), this.typeVariantDataType.getNativeTypeId(), this.typeVariantDataType.toStorageForm(typeVariant.ordinal()), registry);
    }

    void setStringAttribute(int objectId, String name, String value, int maxLength, boolean lengthFitsValue, ICleanUpRegistry registry) {
        int attributeId;
        int realMaxLengthInBytes;
        byte[] bytes;
        if (lengthFitsValue) {
            bytes = StringUtils.toBytes(value, this.encodingForNewDataSets);
            realMaxLengthInBytes = bytes.length == 0 ? 1 : bytes.length;
        } else {
            bytes = StringUtils.toBytes(value, maxLength, this.encodingForNewDataSets);
            realMaxLengthInBytes = this.encodingForNewDataSets.getMaxBytesPerChar() * (maxLength == 0 ? 1 : maxLength);
        }
        int storageDataTypeId = this.h5.createDataTypeString(realMaxLengthInBytes, registry);
        if (this.h5.existsAttribute(objectId, name)) {
            attributeId = this.h5.openAttribute(objectId, name, registry);
            int oldStorageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
            if (!this.h5.dataTypesAreEqual(oldStorageDataTypeId, storageDataTypeId)) {
                this.h5.deleteAttribute(objectId, name);
                attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
            }
        } else {
            attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
        }
        this.h5.writeAttribute(attributeId, storageDataTypeId, StringUtils.cutOrPadBytes(bytes, realMaxLengthInBytes));
    }

    void setStringArrayAttribute(int objectId, String name, String[] value, int maxLength, boolean lengthFitsValue, ICleanUpRegistry registry) {
        int attributeId;
        StringArrayBuffer array = new StringArrayBuffer(maxLength, lengthFitsValue);
        array.addAll(value);
        byte[] arrData = array.toArray();
        int stringDataTypeId = this.h5.createDataTypeString(array.getMaxLengthInByte(), registry);
        int storageDataTypeId = this.h5.createArrayType(stringDataTypeId, value.length, registry);
        if (this.h5.existsAttribute(objectId, name)) {
            attributeId = this.h5.openAttribute(objectId, name, registry);
            int oldStorageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
            if (!this.h5.dataTypesAreEqual(oldStorageDataTypeId, storageDataTypeId)) {
                this.h5.deleteAttribute(objectId, name);
                attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
            }
        } else {
            attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
        }
        this.h5.writeAttribute(attributeId, storageDataTypeId, arrData);
    }

    void setStringArrayAttribute(int objectId, String name, MDArray<String> value, int maxLength, boolean lengthFitsValue, ICleanUpRegistry registry) {
        int attributeId;
        StringArrayBuffer array = new StringArrayBuffer(maxLength, lengthFitsValue);
        array.addAll((String[])value.getAsFlatArray());
        byte[] arrData = array.toArray();
        int stringDataTypeId = this.h5.createDataTypeString(array.getMaxLengthInByte(), registry);
        int storageDataTypeId = this.h5.createArrayType(stringDataTypeId, value.dimensions(), registry);
        if (this.h5.existsAttribute(objectId, name)) {
            attributeId = this.h5.openAttribute(objectId, name, registry);
            int oldStorageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
            if (!this.h5.dataTypesAreEqual(oldStorageDataTypeId, storageDataTypeId)) {
                this.h5.deleteAttribute(objectId, name);
                attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
            }
        } else {
            attributeId = this.h5.createAttribute(objectId, name, storageDataTypeId, registry);
        }
        this.h5.writeAttribute(attributeId, storageDataTypeId, arrData);
    }

    void setStringAttributeVariableLength(int objectId, String name, String value, ICleanUpRegistry registry) {
        int attributeId;
        if (this.h5.existsAttribute(objectId, name)) {
            attributeId = this.h5.openAttribute(objectId, name, registry);
            int oldStorageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
            if (!this.h5.dataTypesAreEqual(oldStorageDataTypeId, this.variableLengthStringDataTypeId)) {
                this.h5.deleteAttribute(objectId, name);
                attributeId = this.h5.createAttribute(objectId, name, this.variableLengthStringDataTypeId, registry);
            }
        } else {
            attributeId = this.h5.createAttribute(objectId, name, this.variableLengthStringDataTypeId, registry);
        }
        this.writeAttributeStringVL(attributeId, new String[]{value});
    }

    String moveLinkOutOfTheWay(String linkPath) {
        String newLinkPath = this.createNonExistentReplacementLinkPath(linkPath);
        this.h5.moveLink(this.fileId, linkPath, newLinkPath);
        return newLinkPath;
    }

    private String createNonExistentReplacementLinkPath(String dataTypePath) {
        String dstLinkPath = String.valueOf(dataTypePath) + "__REPLACED_";
        int idx = 1;
        while (this.h5.exists(this.fileId, String.valueOf(dstLinkPath) + idx)) {
            ++idx;
        }
        return String.valueOf(dstLinkPath) + idx;
    }

    private static enum Command {
        SYNC,
        CLOSE_ON_EXIT,
        CLOSE_SYNC,
        EXIT;

    }

    class StringArrayBuffer {
        private byte[] buf;
        private int len;
        private int realMaxLengthPerString;
        private boolean valueContainsChar0;
        private int[] lengths;
        private final int maxLengthPerString;
        private final boolean lengthFitsValue;

        StringArrayBuffer(int maxLengthPerString, boolean lengthFitsValue) {
            this.maxLengthPerString = maxLengthPerString;
            this.lengthFitsValue = lengthFitsValue;
        }

        void addAll(String[] array) {
            if (this.lengthFitsValue) {
                this.addAllLengthFitsValue(array);
            } else {
                this.addAllLengthFixedLength(array);
            }
        }

        private void addAllLengthFixedLength(String[] array) {
            this.realMaxLengthPerString = HDF5BaseWriter.this.encodingForNewDataSets.getMaxBytesPerChar() * this.maxLengthPerString;
            this.buf = new byte[this.realMaxLengthPerString * array.length];
            this.lengths = new int[array.length];
            int idx = 0;
            String[] stringArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                byte[] data = StringUtils.toBytes(s, this.maxLengthPerString, HDF5BaseWriter.this.encodingForNewDataSets);
                int dataLen = Math.min(data.length, this.realMaxLengthPerString);
                int newLen = this.len + this.realMaxLengthPerString;
                System.arraycopy(data, 0, this.buf, this.len, dataLen);
                this.len = newLen;
                if (!this.valueContainsChar0) {
                    this.valueContainsChar0 |= s.contains("\u0000");
                }
                this.lengths[idx++] = dataLen;
                ++n2;
            }
        }

        private void addAllLengthFitsValue(String[] array) {
            byte[][] data = new byte[array.length][];
            this.lengths = new int[array.length];
            int idx = 0;
            Object object = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String s = object[n2];
                byte[] bytes = StringUtils.toBytes(s, HDF5BaseWriter.this.encodingForNewDataSets);
                this.realMaxLengthPerString = Math.max(this.realMaxLengthPerString, bytes.length);
                data[idx] = bytes;
                this.lengths[idx] = bytes.length;
                if (!this.valueContainsChar0) {
                    this.valueContainsChar0 |= s.contains("\u0000");
                }
                ++idx;
                ++n2;
            }
            this.buf = new byte[this.realMaxLengthPerString * array.length];
            object = data;
            n = data.length;
            n2 = 0;
            while (n2 < n) {
                String bytes = object[n2];
                System.arraycopy(bytes, 0, this.buf, this.len, ((String)bytes).length);
                this.len += this.realMaxLengthPerString;
                ++n2;
            }
        }

        byte[] toArray() {
            return StringUtils.cutOrPadBytes(this.buf, this.len);
        }

        int getMaxLengthInByte() {
            return this.realMaxLengthPerString == 0 ? 1 : this.realMaxLengthPerString;
        }

        boolean shouldSaveExplicitLength() {
            return this.valueContainsChar0 || this.realMaxLengthPerString == 0;
        }

        int[] getLengths() {
            return this.lengths;
        }
    }
}

