/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.jai;

import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IImageReaderLibrary;
import ch.systemsx.cisd.imagereaders.jai.DefaultImageReader;
import ch.systemsx.cisd.imagereaders.jai.TiffImageReader;
import com.sun.media.jai.codec.ImageCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class JAIReaderLibrary
implements IImageReaderLibrary {
    private static final String TIFF_FORMAT = "TIFF";
    private static final String PNM_FORMAT = "PNM";
    private static final Map<String, String> fixExtensions = new HashMap<String, String>();

    static {
        fixExtensions.put("tif", TIFF_FORMAT);
        fixExtensions.put("jpg", "JPEG");
        fixExtensions.put("pbm", PNM_FORMAT);
        fixExtensions.put("pgm", PNM_FORMAT);
        fixExtensions.put("ppm", PNM_FORMAT);
    }

    public String getName() {
        return "JAI";
    }

    public List<String> getReaderNames() {
        List<ImageCodec> codecs = this.getCodecsList();
        ArrayList<String> result = new ArrayList<String>();
        for (ImageCodec codec : codecs) {
            result.add(codec.getFormatName());
        }
        return result;
    }

    public IImageReader tryGetReader(String readerName) {
        assert (readerName != null) : "fileName cannot be null";
        ImageCodec codec = this.tryFindCodecForFormat(readerName);
        if (codec == null) {
            return null;
        }
        if (this.isTiffReader(readerName)) {
            return new TiffImageReader(this.getName(), readerName);
        }
        return new DefaultImageReader(this.getName(), readerName);
    }

    public IImageReader tryGetReaderForFile(String fileName) {
        assert (fileName != null) : "fileName cannot be null";
        String fileExtension = FilenameUtils.getExtension((String)fileName);
        fileExtension = this.fixFileExtension(fileExtension);
        return this.tryGetReader(fileExtension);
    }

    private boolean isTiffReader(String readerName) {
        return TIFF_FORMAT.equalsIgnoreCase(readerName);
    }

    private List<ImageCodec> getCodecsList() {
        Enumeration en = ImageCodec.getCodecs();
        List<ImageCodec> codecs = en == null ? Collections.emptyList() : Collections.list(en);
        return codecs;
    }

    private ImageCodec tryFindCodecForFormat(String formatName) {
        for (ImageCodec codec : this.getCodecsList()) {
            if (!formatName.equalsIgnoreCase(codec.getFormatName())) continue;
            return codec;
        }
        return null;
    }

    private String fixFileExtension(String extension) {
        String fixedExtension;
        if (extension != null && (fixedExtension = fixExtensions.get(extension.toLowerCase())) != null) {
            return fixedExtension;
        }
        return extension;
    }
}

