/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.Opener;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.io.File;

public class VirtualStack
extends ImageStack {
    private static final int INITIAL_SIZE = 100;
    private String path;
    private int nSlices;
    private String[] names;
    private String[] labels;
    private int bitDepth;

    public VirtualStack() {
    }

    public VirtualStack(int width, int height, ColorModel cm, String path) {
        super(width, height, cm);
        this.path = path;
        this.names = new String[100];
        this.labels = new String[100];
    }

    public void addSlice(String name) {
        if (name == null) {
            throw new IllegalArgumentException("'name' is null!");
        }
        ++this.nSlices;
        if (this.nSlices == this.names.length) {
            String[] tmp = new String[this.nSlices * 2];
            System.arraycopy(this.names, 0, tmp, 0, this.nSlices);
            this.names = tmp;
            tmp = new String[this.nSlices * 2];
            System.arraycopy(this.labels, 0, tmp, 0, this.nSlices);
            this.labels = tmp;
        }
        this.names[this.nSlices - 1] = name;
    }

    public void addSlice(String sliceLabel, Object pixels) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.nSlices < 1) {
            return;
        }
        for (int i = n; i < this.nSlices; ++i) {
            this.names[i - 1] = this.names[i];
        }
        this.names[this.nSlices - 1] = null;
        --this.nSlices;
    }

    public void deleteLastSlice() {
        if (this.nSlices > 0) {
            this.deleteSlice(this.nSlices);
        }
    }

    public Object getPixels(int n) {
        ImageProcessor ip = this.getProcessor(n);
        if (ip != null) {
            return ip.getPixels();
        }
        return null;
    }

    public void setPixels(Object pixels, int n) {
    }

    public ImageProcessor getProcessor(int n) {
        ImagePlus imp = new Opener().openImage(this.path, this.names[n - 1]);
        if (imp == null) {
            File f = new File(this.path, this.names[n - 1]);
            String msg = f.exists() ? "error opening " : "file not found: ";
            throw new RuntimeException(msg + this.path + this.names[n - 1]);
        }
        int w = imp.getWidth();
        int h = imp.getHeight();
        int type = imp.getType();
        ColorModel cm = imp.getProcessor().getColorModel();
        this.labels[n - 1] = (String)imp.getProperty("Info");
        ImageProcessor ip = imp.getProcessor();
        if (imp.getBitDepth() != this.bitDepth) {
            switch (this.bitDepth) {
                case 8: {
                    ip = ip.convertToByte(true);
                    break;
                }
                case 16: {
                    ip = ip.convertToShort(true);
                    break;
                }
                case 24: {
                    ip = ip.convertToRGB();
                    break;
                }
                case 32: {
                    ip = ip.convertToFloat();
                }
            }
        }
        if (ip.getWidth() != this.getWidth() || ip.getHeight() != this.getHeight()) {
            ip = ip.resize(this.getWidth(), this.getHeight());
        }
        return ip;
    }

    public int saveChanges(int n) {
        return -1;
    }

    public int getSize() {
        return this.nSlices;
    }

    public String getSliceLabel(int n) {
        String label = this.labels[n - 1];
        if (label == null) {
            return this.names[n - 1];
        }
        if (label.length() <= 60) {
            return label;
        }
        return this.names[n - 1] + "\n" + label;
    }

    public Object[] getImageArray() {
        return null;
    }

    public void setSliceLabel(String label, int n) {
    }

    public boolean isVirtual() {
        return true;
    }

    public void trim() {
    }

    public String getDirectory() {
        return this.path;
    }

    public String getFileName(int n) {
        return this.names[n - 1];
    }

    public void setBitDepth(int bitDepth) {
        this.bitDepth = bitDepth;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }
}

