/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.macro.Interpreter;
import ij.process.ImageProcessor;
import ij.util.Java2;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class TextRoi
extends Roi {
    static final int MAX_LINES = 50;
    private String[] theText = new String[50];
    private static String name = "SansSerif";
    private static int style = 0;
    private static int size = 18;
    private Font instanceFont;
    private static boolean newFont = true;
    private static boolean antialiasedText = true;
    private static boolean recordSetFont = true;
    private double previousMag;
    private boolean firstChar = true;
    private boolean firstMouseUp = true;
    private int cline = 0;

    public TextRoi(int x, int y, String text) {
        this(x, y, text, null, null);
    }

    public TextRoi(int x, int y, String text, Font font) {
        super(x, y, 1, 1);
        String[] lines = Tools.split(text, "\n");
        int count = Math.min(lines.length, 50);
        for (int i = 0; i < count; ++i) {
            this.theText[i] = lines[i];
        }
        if (font == null) {
            font = new Font(name, style, size);
        }
        this.instanceFont = font;
        this.firstChar = false;
        if (IJ.debugMode) {
            IJ.log("TextRoi: " + this.theText[0] + "  " + this.width + "," + this.height);
        }
    }

    public TextRoi(int x, int y, String text, Font font, Color color) {
        super(x, y, 1, 1);
        if (font == null) {
            font = new Font(name, style, size);
        }
        this.instanceFont = font;
        IJ.error("TextRoi", "API has changed. See updated example at\nhttp://rsb.info.nih.gov/ij/macros/js/TextOverlay.js");
    }

    public TextRoi(int x, int y, ImagePlus imp) {
        super(x, y, imp);
        double mag;
        ImageCanvas ic = imp.getCanvas();
        double d = mag = ic != null ? ic.getMagnification() : 1.0;
        if (mag > 1.0) {
            mag = 1.0;
        }
        if ((double)size < 12.0 / mag) {
            size = (int)(12.0 / mag);
        }
        this.theText[0] = "Type, then";
        this.theText[1] = "Ctl+D";
        if (previousRoi != null && previousRoi instanceof TextRoi) {
            this.firstMouseUp = false;
            previousRoi = null;
        }
        this.instanceFont = new Font(name, style, size);
    }

    public void addChar(char c) {
        if (c < ' ' && c != '\b' && c != '\n') {
            return;
        }
        if (this.firstChar) {
            this.cline = 0;
            this.theText[this.cline] = new String("");
            for (int i = 1; i < 50; ++i) {
                this.theText[i] = null;
            }
        }
        if (c == '\b') {
            if (this.theText[this.cline].length() > 0) {
                this.theText[this.cline] = this.theText[this.cline].substring(0, this.theText[this.cline].length() - 1);
            } else if (this.cline > 0) {
                this.theText[this.cline] = null;
                --this.cline;
            }
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.firstChar = false;
            return;
        }
        if (c == '\n') {
            if (this.cline < 49) {
                ++this.cline;
            }
        } else {
            char[] chr = new char[]{c};
            int n = this.cline;
            this.theText[n] = this.theText[n] + new String(chr);
            this.updateBounds(null);
            this.updateText();
            this.firstChar = false;
            return;
        }
        this.theText[this.cline] = "";
        this.updateBounds(null);
        this.updateText();
    }

    Font getScaledFont() {
        if (this.nonScalable) {
            return this.instanceFont;
        }
        if (this.instanceFont == null) {
            this.instanceFont = new Font(name, style, size);
        }
        return this.instanceFont.deriveFont((float)((double)this.instanceFont.getSize() * this.mag));
    }

    public void drawPixels(ImageProcessor ip) {
        ip.setFont(this.instanceFont);
        ip.setAntialiasedText(antialiasedText);
        FontMetrics metrics = ip.getFontMetrics();
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        int i = 0;
        int yy = 0;
        while (i < 50 && this.theText[i] != null) {
            ip.drawString(this.theText[i], this.x, this.y + yy + fontHeight);
            ++i;
            yy += fontHeight;
        }
    }

    public void draw(Graphics g) {
        if (IJ.debugMode) {
            IJ.log("draw: " + this.theText[0] + "  " + this.width + "," + this.height);
        }
        if (this.ic == null) {
            return;
        }
        if (Interpreter.isBatchMode() && this.ic.getDisplayList() != null) {
            return;
        }
        if (newFont || this.width == 1) {
            this.updateBounds(g);
        }
        super.draw(g);
        double mag = this.ic.getMagnification();
        int sx = this.ic.screenX(this.x);
        int sy = this.ic.screenY(this.y);
        int swidth = (int)((double)this.width * mag);
        int sheight = (int)((double)this.height * mag);
        Rectangle r = null;
        r = g.getClipBounds();
        g.setClip(sx, sy, swidth, sheight);
        this.drawText(g);
        if (r != null) {
            g.setClip(r.x, r.y, r.width, r.height);
        }
    }

    void drawText(Graphics g) {
        g.setColor(this.strokeColor != null ? this.strokeColor : ROIColor);
        Java2.setAntialiasedText(g, antialiasedText);
        if (newFont || this.width == 1) {
            this.updateBounds(g);
        }
        double mag = this.ic.getMagnification();
        int sx = this.nonScalable ? this.x : this.ic.screenX(this.x);
        int sy = this.nonScalable ? this.y : this.ic.screenY(this.y);
        Font font = this.getScaledFont();
        FontMetrics metrics = g.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        g.setFont(font);
        int i = 0;
        if (this.fillColor != null) {
            if (this.getStrokeWidth() < 10.0f) {
                Color saveFillColor = this.fillColor;
                this.setStrokeWidth(10.0f);
                this.fillColor = saveFillColor;
            }
            this.updateBounds(g);
            Color c = g.getColor();
            int alpha = this.fillColor.getAlpha();
            g.setColor(this.fillColor);
            Graphics2D g2d = (Graphics2D)g;
            int sw = this.nonScalable ? this.width : (int)(this.ic.getMagnification() * (double)this.width);
            int sh = this.nonScalable ? this.height : (int)(this.ic.getMagnification() * (double)this.height);
            g.fillRect(sx - 5, sy - 5, sw + 10, sh + 10);
            g.setColor(c);
        }
        while (i < 50 && this.theText[i] != null) {
            g.drawString(this.theText[i], sx, sy + fontHeight - descent);
            ++i;
            sy += fontHeight;
        }
    }

    public static String getFont() {
        return name;
    }

    public static int getSize() {
        return size;
    }

    public static int getStyle() {
        return style;
    }

    public void setCurrentFont(Font font) {
        this.instanceFont = font;
        this.updateBounds(null);
    }

    public Font getCurrentFont() {
        return this.instanceFont;
    }

    public static boolean isAntialiased() {
        return antialiasedText;
    }

    public static void setFont(String fontName, int fontSize, int fontStyle) {
        recordSetFont = true;
        TextRoi.setFont(fontName, fontSize, fontStyle, true);
    }

    public static void setFont(String fontName, int fontSize, int fontStyle, boolean antialiased) {
        Roi roi;
        recordSetFont = true;
        name = fontName;
        size = fontSize;
        style = fontStyle;
        antialiasedText = antialiased;
        newFont = true;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (roi = imp.getRoi()) instanceof TextRoi) {
            ((TextRoi)roi).setCurrentFont(new Font(name, style, size));
            imp.draw();
        }
    }

    protected void handleMouseUp(int screenX, int screenY) {
        super.handleMouseUp(screenX, screenY);
        if (this.firstMouseUp) {
            this.updateBounds(null);
            this.updateText();
            this.firstMouseUp = false;
        } else if (this.width < 5 || this.height < 5) {
            this.imp.killRoi();
        }
    }

    void updateBounds(Graphics g) {
        boolean nullg;
        if (this.ic == null) {
            return;
        }
        double mag = this.ic.getMagnification();
        if (this.nonScalable) {
            mag = 1.0;
        }
        Font font = this.getScaledFont();
        newFont = false;
        boolean bl = nullg = g == null;
        if (nullg) {
            g = this.ic.getGraphics();
        }
        Java2.setAntialiasedText(g, true);
        FontMetrics metrics = g.getFontMetrics(font);
        int fontHeight = (int)((double)metrics.getHeight() / mag);
        int descent = metrics.getDescent();
        int nLines = 0;
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.width = 10;
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            ++nLines;
            int w = (int)((double)this.stringWidth(this.theText[i], metrics, g) / mag);
            if (w <= this.width) continue;
            this.width = w;
        }
        if (nullg) {
            g.dispose();
        }
        this.width += 2;
        if (this.xMax != 0 && this.x + this.width > this.xMax) {
            this.x = this.xMax - this.width;
        }
        this.height = nLines * fontHeight + 2;
        if (this.yMax != 0) {
            if (this.height > this.yMax) {
                this.height = this.yMax;
            }
            if (this.y + this.height > this.yMax) {
                this.y = this.yMax - this.height;
            }
        }
    }

    void updateText() {
        if (this.imp != null) {
            this.updateClipRect();
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
    }

    int stringWidth(String s, FontMetrics metrics, Graphics g) {
        return Java2.getStringWidth(s, metrics, g);
    }

    public String getMacroCode(ImageProcessor ip) {
        String code = "";
        if (recordSetFont) {
            String options = "";
            if (style == 1) {
                options = options + "bold";
            }
            if (style == 2) {
                options = options + " italic";
            }
            if (antialiasedText) {
                options = options + " antialiased";
            }
            if (options.equals("")) {
                options = "plain";
            }
            code = code + "setFont(\"" + name + "\", " + size + ", \"" + options + "\");\n";
            recordSetFont = false;
        }
        FontMetrics metrics = ip.getFontMetrics();
        int fontHeight = metrics.getHeight();
        String text = "";
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            text = text + this.theText[i];
            if (this.theText[i + 1] == null) continue;
            text = text + "\\n";
        }
        code = code + "makeText(\"" + text + "\", " + this.x + ", " + (this.y + fontHeight) + ");\n";
        code = code + "//drawString(\"" + text + "\", " + this.x + ", " + (this.y + fontHeight) + ");\n";
        return code;
    }

    public String getText() {
        String text = "";
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            text = text + this.theText[i] + "\n";
        }
        return text;
    }

    public static void recordSetFont() {
        recordSetFont = true;
    }

    public boolean isDrawingTool() {
        return true;
    }

    public synchronized Object clone() {
        TextRoi tr = (TextRoi)super.clone();
        tr.theText = new String[50];
        for (int i = 0; i < 50; ++i) {
            tr.theText[i] = this.theText[i];
        }
        return tr;
    }
}

