/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class Concatenator
implements PlugIn {
    ImagePlus imp1;
    ImagePlus imp2;
    static boolean keep;
    static String title;

    public void run(String arg) {
        ImagePlus imp3;
        if (this.showDialog() && (imp3 = this.concatenate(this.imp1, this.imp2, keep)) != null) {
            imp3.show();
        }
    }

    public ImagePlus concatenate(ImagePlus imp1, ImagePlus imp2, boolean keep) {
        String label;
        ImageProcessor ip;
        int i;
        if (imp1.getType() != imp2.getType() || imp1.isHyperStack() || imp2.isHyperStack()) {
            this.error();
            return null;
        }
        int width = imp1.getWidth();
        int height = imp1.getHeight();
        if (width != imp2.getWidth() || height != imp2.getHeight()) {
            this.error();
            return null;
        }
        ImageStack stack1 = imp1.getStack();
        ImageStack stack2 = imp2.getStack();
        int size1 = stack1.getSize();
        int size2 = stack2.getSize();
        ImageStack stack3 = imp1.createEmptyStack();
        int slice = 1;
        for (i = 1; i <= size1; ++i) {
            ip = stack1.getProcessor(slice);
            label = stack1.getSliceLabel(slice);
            if (keep || imp1 == imp2) {
                ip = ip.duplicate();
                ++slice;
            } else {
                stack1.deleteSlice(slice);
            }
            stack3.addSlice(label, ip);
        }
        slice = 1;
        for (i = 1; i <= size2; ++i) {
            ip = stack2.getProcessor(slice);
            label = stack2.getSliceLabel(slice);
            if (keep || imp1 == imp2) {
                ip = ip.duplicate();
                ++slice;
            } else {
                stack2.deleteSlice(slice);
            }
            stack3.addSlice(label, ip);
        }
        ImagePlus imp3 = new ImagePlus(title, stack3);
        imp3.setCalibration(imp1.getCalibration());
        if (!keep) {
            imp1.changes = false;
            if (imp1.getWindow() != null) {
                imp1.getWindow().close();
            }
            if (imp1 != imp2) {
                imp2.changes = false;
                if (imp2.getWindow() != null) {
                    imp2.getWindow().close();
                }
            }
        }
        return imp3;
    }

    boolean showDialog() {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.noImage();
            return false;
        }
        String[] titles = new String[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
        }
        GenericDialog gd = new GenericDialog("Concatenator");
        gd.addChoice("Stack1:", titles, titles[0]);
        gd.addChoice("Stack2:", titles, wList.length > 1 ? titles[1] : titles[0]);
        gd.addStringField("Title:", title, 16);
        gd.addCheckbox("Keep Source Stacks", keep);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int[] index = new int[3];
        int index1 = gd.getNextChoiceIndex();
        int index2 = gd.getNextChoiceIndex();
        title = gd.getNextString();
        keep = gd.getNextBoolean();
        this.imp1 = WindowManager.getImage(wList[index1]);
        this.imp2 = WindowManager.getImage(wList[index2]);
        return true;
    }

    void error() {
        IJ.showMessage("Concatenator", "This command requires two stacks that have\nthe same width, height and data type.");
    }

    static {
        title = "Concatenated Stacks";
    }
}

