/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class ColorThresholder
extends PlugInFrame
implements PlugIn,
Measurements,
ActionListener,
AdjustmentListener,
FocusListener,
ItemListener,
Runnable {
    private boolean flag = false;
    private int colmode = 0;
    private Thread thread;
    private static Frame instance;
    private BandPlot plot = new BandPlot();
    private BandPlot splot = new BandPlot();
    private BandPlot bplot = new BandPlot();
    private int sliderRange = 256;
    private Panel panelh;
    private Panel panels;
    private Panel panelb;
    private Panel panel;
    private Panel panelt;
    private Panel panelMode;
    private Button originalB;
    private Button filteredB;
    private Button stackB;
    private Button helpB;
    private Button sampleB;
    private Button resetallB;
    private Button newB;
    private Button macroB;
    private Checkbox bandPassH;
    private Checkbox bandStopH;
    private Checkbox bandPassS;
    private Checkbox bandStopS;
    private Checkbox bandPassB;
    private Checkbox bandStopB;
    private Checkbox threshold;
    private Checkbox blackBackground;
    private Checkbox hsb;
    private Checkbox rgb;
    private Checkbox lab;
    private Checkbox yuv;
    private CheckboxGroup filterTypeH;
    private CheckboxGroup filterTypeS;
    private CheckboxGroup filterTypeB;
    private CheckboxGroup colourMode;
    private int previousImageID = -1;
    private int previousSlice = -1;
    private ImageJ ij;
    private int minHue = 0;
    private int minSat = 0;
    private int minBri = 0;
    private int maxHue = 255;
    private int maxSat = 255;
    private int maxBri = 255;
    private Scrollbar minSlider;
    private Scrollbar maxSlider;
    private Scrollbar minSlider2;
    private Scrollbar maxSlider2;
    private Scrollbar minSlider3;
    private Scrollbar maxSlider3;
    private Label label1;
    private Label label2;
    private Label label3;
    private Label label4;
    private Label label5;
    private Label label6;
    private Label labelh;
    private Label labels;
    private Label labelb;
    private Label labelf;
    private boolean done;
    private byte[] hSource;
    private byte[] sSource;
    private byte[] bSource;
    private byte[] fillMask;
    private ImageProcessor fillMaskIP;
    private int[] restore;
    private ImagePlus imp;
    private ImageProcessor ip;
    private int numSlices;
    private ImageStack stack;
    private int width;
    private int height;
    private int numPixels;

    public ColorThresholder() {
        super("Threshold Color (experimental)");
        if (instance != null) {
            instance.toFront();
            return;
        }
        this.thread = new Thread((Runnable)this, "BandAdjuster");
        WindowManager.addWindow(this);
        instance = this;
        this.ij = IJ.getInstance();
        Font font = new Font("SansSerif", 0, 10);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        int y = 0;
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.labelh = new Label("Hue", 1);
        this.add((Component)this.labelh, c);
        c.gridx = 1;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(7, 0, 0, 0);
        this.labelf = new Label("Filter type", 2);
        this.add((Component)this.labelf, c);
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.plot, c);
        this.panelh = new Panel();
        this.filterTypeH = new CheckboxGroup();
        this.bandPassH = new Checkbox("Pass");
        this.bandPassH.setCheckboxGroup(this.filterTypeH);
        this.bandPassH.addItemListener(this);
        this.panelh.add(this.bandPassH);
        this.bandStopH = new Checkbox("Stop");
        this.bandStopH.setCheckboxGroup(this.filterTypeH);
        this.bandStopH.addItemListener(this);
        this.panelh.add(this.bandStopH);
        this.bandPassH.setState(true);
        c.gridx = 1;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelh, c);
        this.minSlider = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.minSlider, c);
        this.minSlider.addAdjustmentListener(this);
        this.minSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label1 = new Label("       ", 0);
        this.label1.setFont(font);
        this.add((Component)this.label1, c);
        this.maxSlider = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.maxSlider, c);
        this.maxSlider.addAdjustmentListener(this);
        this.maxSlider.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.gridy = y++;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label2 = new Label("       ", 0);
        this.label2.setFont(font);
        this.add((Component)this.label2, c);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.labels = new Label("Saturation", 1);
        this.add((Component)this.labels, c);
        c.gridx = 0;
        c.gridy = y;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.splot, c);
        this.panels = new Panel();
        this.filterTypeS = new CheckboxGroup();
        this.bandPassS = new Checkbox("Pass");
        this.bandPassS.setCheckboxGroup(this.filterTypeS);
        this.bandPassS.addItemListener(this);
        this.panels.add(this.bandPassS);
        this.bandStopS = new Checkbox("Stop");
        this.bandStopS.setCheckboxGroup(this.filterTypeS);
        this.bandStopS.addItemListener(this);
        this.panels.add(this.bandStopS);
        this.bandPassS.setState(true);
        c.gridx = 1;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panels, c);
        this.minSlider2 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.minSlider2, c);
        this.minSlider2.addAdjustmentListener(this);
        this.minSlider2.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label3 = new Label("       ", 0);
        this.label3.setFont(font);
        this.add((Component)this.label3, c);
        this.maxSlider2 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.maxSlider2, c);
        this.maxSlider2.addAdjustmentListener(this);
        this.maxSlider2.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label4 = new Label("       ", 0);
        this.label4.setFont(font);
        this.add((Component)this.label4, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = y++;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 0, 0);
        this.labelb = new Label("Brightness", 1);
        this.add((Component)this.labelb, c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = y;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.bplot, c);
        this.panelb = new Panel();
        this.filterTypeB = new CheckboxGroup();
        this.bandPassB = new Checkbox("Pass");
        this.bandPassB.setCheckboxGroup(this.filterTypeB);
        this.bandPassB.addItemListener(this);
        this.panelb.add(this.bandPassB);
        this.bandStopB = new Checkbox("Stop");
        this.bandStopB.setCheckboxGroup(this.filterTypeB);
        this.bandStopB.addItemListener(this);
        this.panelb.add(this.bandStopB);
        this.bandPassB.setState(true);
        c.gridx = 1;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelb, c);
        this.minSlider3 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.minSlider3, c);
        this.minSlider3.addAdjustmentListener(this);
        this.minSlider3.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label5 = new Label("       ", 0);
        this.label5.setFont(font);
        this.add((Component)this.label5, c);
        this.maxSlider3 = new Scrollbar(0, 0, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 100.0;
        c.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.maxSlider3, c);
        this.maxSlider3.addAdjustmentListener(this);
        this.maxSlider3.setUnitIncrement(1);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        this.label6 = new Label("       ", 0);
        this.label6.setFont(font);
        this.add((Component)this.label6, c);
        this.panelt = new Panel();
        this.threshold = new Checkbox("Threshold");
        this.threshold.addItemListener(this);
        this.panelt.add(this.threshold);
        this.blackBackground = new Checkbox("Black background", Prefs.blackBackground);
        this.blackBackground.addItemListener(this);
        this.panelt.add(this.blackBackground);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.panelt, c);
        this.panel = new Panel();
        this.originalB = new Button("Original");
        this.originalB.setEnabled(false);
        this.originalB.addActionListener(this);
        this.originalB.addKeyListener(this.ij);
        this.panel.add(this.originalB);
        this.filteredB = new Button("Filtered");
        this.filteredB.setEnabled(false);
        this.filteredB.addActionListener(this);
        this.filteredB.addKeyListener(this.ij);
        this.panel.add(this.filteredB);
        this.stackB = new Button("Stack");
        this.stackB.addActionListener(this);
        this.stackB.addKeyListener(this.ij);
        this.panel.add(this.stackB);
        this.macroB = new Button("Macro");
        this.macroB.addActionListener(this);
        this.macroB.addKeyListener(this.ij);
        this.panel.add(this.macroB);
        this.helpB = new Button("Help");
        this.helpB.addActionListener(this);
        this.helpB.addKeyListener(this.ij);
        this.panel.add(this.helpB);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.panel, c);
        this.panelMode = new Panel();
        this.sampleB = new Button("Sample");
        this.sampleB.addActionListener(this);
        this.sampleB.addKeyListener(this.ij);
        this.panelMode.add(this.sampleB);
        this.colourMode = new CheckboxGroup();
        this.hsb = new Checkbox("HSB");
        this.hsb.setCheckboxGroup(this.colourMode);
        this.hsb.addItemListener(this);
        this.panelMode.add(this.hsb);
        this.hsb.setState(true);
        this.rgb = new Checkbox("RGB");
        this.rgb.setCheckboxGroup(this.colourMode);
        this.rgb.addItemListener(this);
        this.panelMode.add(this.rgb);
        this.lab = new Checkbox("CIE Lab");
        this.lab.setCheckboxGroup(this.colourMode);
        this.lab.addItemListener(this);
        this.panelMode.add(this.lab);
        this.yuv = new Checkbox("YUV");
        this.yuv.setCheckboxGroup(this.colourMode);
        this.yuv.addItemListener(this);
        this.panelMode.add(this.yuv);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.panelMode, c);
        this.addKeyListener(this.ij);
        this.pack();
        GUI.center(this);
        this.setVisible(true);
        if (!this.checkImage()) {
            return;
        }
        this.imp.killRoi();
        this.ip = this.setup(this.imp);
        if (this.ip == null) {
            this.imp.unlock();
            IJ.beep();
            IJ.showStatus("RGB image cannot be thresholded");
            return;
        }
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            ColorThresholder colorThresholder = this;
            synchronized (colorThresholder) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.done) {
                    this.reset(this.imp, this.ip);
                    this.apply(this.imp, this.ip);
                    this.imp.updateAndDraw();
                }
            }
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.checkImage()) {
            return;
        }
        if (e.getSource() == this.minSlider) {
            this.adjustMinHue(this.minSlider.getValue());
        } else if (e.getSource() == this.maxSlider) {
            this.adjustMaxHue(this.maxSlider.getValue());
        } else if (e.getSource() == this.minSlider2) {
            this.adjustMinSat(this.minSlider2.getValue());
        } else if (e.getSource() == this.maxSlider2) {
            this.adjustMaxSat(this.maxSlider2.getValue());
        } else if (e.getSource() == this.minSlider3) {
            this.adjustMinBri(this.minSlider3.getValue());
        } else if (e.getSource() == this.maxSlider3) {
            this.adjustMaxBri(this.maxSlider3.getValue());
        }
        this.originalB.setEnabled(true);
        this.updateLabels();
        this.updatePlot();
        this.notify();
    }

    public synchronized void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.hsb || source == this.rgb || source == this.lab || source == this.yuv) {
            if (e.getSource() == this.hsb) {
                this.colmode = 0;
            }
            if (e.getSource() == this.rgb) {
                this.colmode = 1;
            }
            if (e.getSource() == this.lab) {
                this.colmode = 2;
            }
            if (e.getSource() == this.yuv) {
                this.colmode = 3;
            }
            this.flag = true;
            this.originalB.setEnabled(false);
            this.filteredB.setEnabled(false);
            this.minBri = 0;
            this.minSat = 0;
            this.minHue = 0;
            this.maxBri = 255;
            this.maxSat = 255;
            this.maxHue = 255;
            this.bandPassH.setState(true);
            this.bandPassS.setState(true);
            this.bandPassB.setState(true);
        } else if (source == this.blackBackground) {
            Prefs.blackBackground = this.blackBackground.getState();
        }
        this.reset(this.imp, this.ip);
        this.checkImage();
        this.updateNames();
        this.notify();
    }

    public void focusGained(FocusEvent e) {
        this.checkImage();
    }

    public void focusLost(FocusEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Button b = (Button)e.getSource();
        if (b == null) {
            return;
        }
        boolean imageThere = this.checkImage();
        if (imageThere) {
            if (b == this.originalB) {
                this.reset(this.imp, this.ip);
                this.filteredB.setEnabled(true);
            } else if (b == this.filteredB) {
                this.apply(this.imp, this.ip);
            } else if (b == this.sampleB) {
                this.reset(this.imp, this.ip);
                this.sample();
                this.apply(this.imp, this.ip);
            } else if (b == this.stackB) {
                this.applyStack();
            } else if (b == this.macroB) {
                if (Recorder.record) {
                    Recorder.recordString("// Color Thresholding (v1.43l)\n");
                    Recorder.recordString("// Autogenerated macro, single images only!\n");
                    Recorder.recordString("// <<This feature is not currently working.>>\n");
                    Recorder.recordString("\n");
                }
            } else if (b == this.helpB) {
                IJ.showMessage("Help", "Threshold Colour  v1.9\n \nModification of Bob Dougherty's BandPass2 plugin by G.Landini to\nthreshold 24 bit RGB images based on Hue Saturation and Brightness,\nRed Green and Blue, CIE Lab or YUV components.\n \n[Pass]: Band-pass filter (anything within range is displayed).\n \n[Stop]: Band-reject filter (anything within range is NOT displayed).\n \n[Original]: Shows the original image and updates the buffer when\nswitching to another image.\n \n[Filtered]: Shows the filtered image.\n \n[Stack]: Processes the rest of the slices in the stack (if any)\n  using the current settings.\n \n[Macro]: Creates a macro based on the current settings which is sent\nto the macro Recorder window, if open.\nThe macro works only with Black background and White foreground,\notherwise, you will have to uncomment first 2 two macro lines:\n    //run(\"Colors...\", \"foreground=white background=black selection=yellow\");\n    //run(\"Options...\", \"iterations=1 black count=1\");\n \n[Threshold]: Shows the object/background in the foreground and\nbackground colours selected in the ImageJ toolbar.\n \n[Invert]: Swaps the fore/background colours.\n \n[Sample]: (experimental) Sets the ranges of the filters based on the\npixel value components in a user-defined ROI.\n \n[HSB] [RGB] [CIE Lab] [YUV]: Selects HSB, RGB, CIE Lab or YUV space and\nresets all the filters.\n \nNote that the final 'thresholded' image type is RGB, not '8-bit' grey.");
            }
            this.updatePlot();
            this.updateLabels();
            this.imp.updateAndDraw();
        } else {
            IJ.beep();
            IJ.showStatus("No Image");
        }
    }

    void sample() {
        int i;
        int j;
        int[] bin = new int[256];
        int counter = 0;
        boolean pi = false;
        int rangePassH = 0;
        boolean rangeStopH = false;
        int rangePassL = 0;
        boolean rangeStopL = false;
        int snumPixels = 0;
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            IJ.error("Selection required");
            return;
        }
        ImageProcessor mask = roi.getMask();
        Rectangle r = roi.getBoundingRect();
        ImageProcessor ip = this.imp.getProcessor();
        if (mask == null) {
            snumPixels = r.width * r.height;
        } else {
            snumPixels = 0;
            for (j = 0; j < r.height; ++j) {
                for (i = 0; i < r.width; ++i) {
                    if (mask.getPixel(i, j) == 0) continue;
                    ++snumPixels;
                }
            }
        }
        byte[] hsSource = new byte[snumPixels];
        byte[] ssSource = new byte[snumPixels];
        byte[] bsSource = new byte[snumPixels];
        int[] pixs = new int[snumPixels];
        if (mask == null) {
            for (j = 0; j < r.height; ++j) {
                for (i = 0; i < r.width; ++i) {
                    pixs[counter++] = ip.getPixel(i + r.x, j + r.y);
                }
            }
        } else {
            for (j = 0; j < r.height; ++j) {
                for (i = 0; i < r.width; ++i) {
                    if (mask.getPixel(i, j) == 0) continue;
                    pixs[counter++] = ip.getPixel(i + r.x, j + r.y);
                }
            }
        }
        this.imp.killRoi();
        ColorProcessor cp2 = new ColorProcessor(1, snumPixels, pixs);
        int iminhue = 256;
        int imaxhue = -1;
        int iminsat = 256;
        int imaxsat = -1;
        int iminbri = 256;
        int imaxbri = -1;
        int iminred = 256;
        int imaxred = -1;
        int imingre = 256;
        int imaxgre = -1;
        int iminblu = 256;
        int imaxblu = -1;
        if (this.colmode == 1) {
            cp2.getRGB(hsSource, ssSource, bsSource);
        } else if (this.colmode == 0) {
            cp2.getHSB(hsSource, ssSource, bsSource);
        } else if (this.colmode == 2) {
            this.getLab(cp2, hsSource, ssSource, bsSource);
        } else if (this.colmode == 3) {
            this.getYUV(cp2, hsSource, ssSource, bsSource);
        }
        for (i = 0; i < snumPixels; ++i) {
            bin[hsSource[i] & 0xFF] = 1;
            if ((hsSource[i] & 0xFF) > imaxhue) {
                imaxhue = hsSource[i] & 0xFF;
            }
            if ((hsSource[i] & 0xFF) < iminhue) {
                iminhue = hsSource[i] & 0xFF;
            }
            if ((ssSource[i] & 0xFF) > imaxsat) {
                imaxsat = ssSource[i] & 0xFF;
            }
            if ((ssSource[i] & 0xFF) < iminsat) {
                iminsat = ssSource[i] & 0xFF;
            }
            if ((bsSource[i] & 0xFF) > imaxbri) {
                imaxbri = bsSource[i] & 0xFF;
            }
            if ((bsSource[i] & 0xFF) >= iminbri) continue;
            iminbri = bsSource[i] & 0xFF;
        }
        if (this.colmode == 0) {
            int gap = 0;
            int maxgap = 0;
            int maxgapst = -1;
            int maxgapen = -1;
            int gapst = 0;
            if (bin[0] == 0) {
                gapst = 0;
                gap = 1;
            }
            for (i = 1; i < 256; ++i) {
                if (bin[i] != 0) continue;
                if (bin[i - 1] > 0) {
                    gap = 1;
                    gapst = i;
                } else {
                    ++gap;
                }
                if (gap <= maxgap) continue;
                maxgap = gap;
                maxgapst = gapst;
                maxgapen = i;
            }
            for (i = 0; i < 256; ++i) {
                if (bin[i] <= 0) continue;
                rangePassL = i;
                break;
            }
            for (i = 255; i >= 0; --i) {
                if (bin[i] <= 0) continue;
                rangePassH = i;
                break;
            }
            if (rangePassH - rangePassL < maxgap) {
                this.bandPassH.setState(true);
                this.bandStopH.setState(false);
                iminhue = rangePassL;
                imaxhue = rangePassH;
            } else {
                this.bandPassH.setState(false);
                this.bandStopH.setState(true);
                iminhue = maxgapst;
                imaxhue = maxgapen;
            }
        } else {
            this.bandPassH.setState(true);
            this.bandStopH.setState(false);
        }
        this.adjustMinHue(iminhue);
        this.minSlider.setValue(iminhue);
        this.adjustMaxHue(imaxhue);
        this.maxSlider.setValue(imaxhue);
        this.adjustMinSat(iminsat);
        this.minSlider2.setValue(iminsat);
        this.adjustMaxSat(imaxsat);
        this.maxSlider2.setValue(imaxsat);
        this.adjustMinBri(iminbri);
        this.minSlider3.setValue(iminbri);
        this.adjustMaxBri(imaxbri);
        this.maxSlider3.setValue(imaxbri);
        this.originalB.setEnabled(true);
    }

    private boolean checkImage() {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null || this.imp.getBitDepth() != 24) {
            IJ.beep();
            IJ.showStatus("No RGB image");
            return false;
        }
        this.ip = this.setup(this.imp);
        return this.ip != null;
    }

    ImageProcessor setup(ImagePlus imp) {
        int slice;
        int type = imp.getType();
        if (type != 4) {
            return null;
        }
        ImageProcessor ip = imp.getProcessor();
        int id = imp.getID();
        if (id != this.previousImageID | (slice = imp.getCurrentSlice()) != this.previousSlice | this.flag) {
            ip.snapshot();
            this.flag = false;
            this.numSlices = imp.getStackSize();
            this.stack = imp.getStack();
            this.width = this.stack.getWidth();
            this.height = this.stack.getHeight();
            this.numPixels = this.width * this.height;
            this.hSource = new byte[this.numPixels];
            this.sSource = new byte[this.numPixels];
            this.bSource = new byte[this.numPixels];
            int[] temp = (int[])ip.getPixels();
            this.restore = new int[this.numPixels];
            for (int i = 0; i < this.numPixels; ++i) {
                this.restore[i] = temp[i];
            }
            this.fillMask = new byte[this.numPixels];
            this.fillMaskIP = new ByteProcessor(this.width, this.height, this.fillMask, null);
            ColorProcessor cp = (ColorProcessor)ip;
            IJ.showStatus("Converting colour space...");
            if (this.colmode == 1) {
                cp.getRGB(this.hSource, this.sSource, this.bSource);
            } else if (this.colmode == 0) {
                cp.getHSB(this.hSource, this.sSource, this.bSource);
            } else if (this.colmode == 2) {
                this.getLab(cp, this.hSource, this.sSource, this.bSource);
            } else if (this.colmode == 3) {
                this.getYUV(cp, this.hSource, this.sSource, this.bSource);
            }
            IJ.showStatus("");
            byte[] reds = new byte[256];
            byte[] greens = new byte[256];
            byte[] blues = new byte[256];
            for (int i = 0; i < 256; ++i) {
                Color c = Color.getHSBColor((float)i / 255.0f, 1.0f, 1.0f);
                reds[i] = (byte)c.getRed();
                greens[i] = (byte)c.getGreen();
                blues[i] = (byte)c.getBlue();
            }
            IndexColorModel cm = new IndexColorModel(8, 256, reds, greens, blues);
            ByteProcessor bpHue = new ByteProcessor(this.width, this.height, this.hSource, cm);
            ImagePlus impHue = new ImagePlus("Hue", bpHue);
            ByteProcessor bpSat = new ByteProcessor(this.width, this.height, this.sSource, cm);
            ImagePlus impSat = new ImagePlus("Sat", bpSat);
            ByteProcessor bpBri = new ByteProcessor(this.width, this.height, this.bSource, cm);
            ImagePlus impBri = new ImagePlus("Bri", bpBri);
            this.plot.setHistogram(impHue, 0);
            this.splot.setHistogram(impSat, 1);
            this.bplot.setHistogram(impBri, 2);
            this.updateLabels();
            this.updatePlot();
            this.updateScrollBars();
            imp.updateAndDraw();
        }
        this.previousImageID = id;
        this.previousSlice = slice;
        return ip;
    }

    void updatePlot() {
        this.plot.minHue = this.minHue;
        this.plot.maxHue = this.maxHue;
        this.plot.repaint();
        this.splot.minHue = this.minSat;
        this.splot.maxHue = this.maxSat;
        this.splot.repaint();
        this.bplot.minHue = this.minBri;
        this.bplot.maxHue = this.maxBri;
        this.bplot.repaint();
    }

    void updateLabels() {
        this.label1.setText("" + this.minHue);
        this.label2.setText("" + this.maxHue);
        this.label3.setText("" + this.minSat);
        this.label4.setText("" + this.maxSat);
        this.label5.setText("" + this.minBri);
        this.label6.setText("" + this.maxBri);
    }

    void updateNames() {
        if (this.colmode == 1) {
            this.labelh.setText("Red");
            this.labels.setText("Green");
            this.labelb.setText("Blue");
        } else if (this.colmode == 0) {
            this.labelh.setText("Hue");
            this.labels.setText("Saturation");
            this.labelb.setText("Brightness");
        } else if (this.colmode == 2) {
            this.labelh.setText("L*");
            this.labels.setText("a*");
            this.labelb.setText("b*");
        } else if (this.colmode == 3) {
            this.labelh.setText("Y");
            this.labels.setText("U");
            this.labelb.setText("V");
        }
    }

    void updateScrollBars() {
        this.minSlider.setValue(this.minHue);
        this.maxSlider.setValue(this.maxHue);
        this.minSlider2.setValue(this.minSat);
        this.maxSlider2.setValue(this.maxSat);
        this.minSlider3.setValue(this.minBri);
        this.maxSlider3.setValue(this.maxBri);
    }

    void adjustMinHue(int value) {
        this.minHue = value;
        if (this.maxHue < this.minHue) {
            this.maxHue = this.minHue;
            this.maxSlider.setValue(this.maxHue);
        }
    }

    void adjustMaxHue(int value) {
        this.maxHue = value;
        if (this.minHue > this.maxHue) {
            this.minHue = this.maxHue;
            this.minSlider.setValue(this.minHue);
        }
    }

    void adjustMinSat(int value) {
        this.minSat = value;
        if (this.maxSat < this.minSat) {
            this.maxSat = this.minSat;
            this.maxSlider2.setValue(this.maxSat);
        }
    }

    void adjustMaxSat(int value) {
        this.maxSat = value;
        if (this.minSat > this.maxSat) {
            this.minSat = this.maxSat;
            this.minSlider2.setValue(this.minSat);
        }
    }

    void adjustMinBri(int value) {
        this.minBri = value;
        if (this.maxBri < this.minBri) {
            this.maxBri = this.minBri;
            this.maxSlider3.setValue(this.maxBri);
        }
    }

    void adjustMaxBri(int value) {
        this.maxBri = value;
        if (this.minBri > this.maxBri) {
            this.minBri = this.maxBri;
            this.minSlider3.setValue(this.minBri);
        }
    }

    void apply(ImagePlus imp, ImageProcessor ip) {
        int bri;
        int sat;
        int hue;
        int j;
        Color col = Prefs.blackBackground ? Color.black : Color.white;
        ip.setColor(col);
        byte fill = -1;
        byte keep = 0;
        if (this.bandPassH.getState() && this.bandPassS.getState() && this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                this.fillMask[j] = hue < this.minHue || hue > this.maxHue || sat < this.minSat || sat > this.maxSat || bri < this.minBri || bri > this.maxBri ? fill : keep;
            }
        } else if (!(this.bandPassH.getState() || this.bandPassS.getState() || this.bandPassB.getState())) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                this.fillMask[j] = hue >= this.minHue && hue <= this.maxHue || sat >= this.minSat && sat <= this.maxSat || bri >= this.minBri && bri <= this.maxBri ? fill : keep;
            }
        } else if (this.bandPassH.getState() && this.bandPassS.getState() && !this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                this.fillMask[j] = hue < this.minHue || hue > this.maxHue || sat < this.minSat || sat > this.maxSat || bri >= this.minBri && bri <= this.maxBri ? fill : keep;
            }
        } else if (!this.bandPassH.getState() && !this.bandPassS.getState() && this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                this.fillMask[j] = hue >= this.minHue && hue <= this.maxHue || sat >= this.minSat && sat <= this.maxSat || bri < this.minBri || bri > this.maxBri ? fill : keep;
            }
        } else if (this.bandPassH.getState() && !this.bandPassS.getState() && !this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                this.fillMask[j] = hue < this.minHue || hue > this.maxHue || sat >= this.minSat && sat <= this.maxSat || bri >= this.minBri && bri <= this.maxBri ? fill : keep;
            }
        } else if (!this.bandPassH.getState() && this.bandPassS.getState() && this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                this.fillMask[j] = hue >= this.minHue && hue <= this.maxHue || sat < this.minSat || sat > this.maxSat || bri < this.minBri || bri > this.maxBri ? fill : keep;
            }
        } else if (!this.bandPassH.getState() && this.bandPassS.getState() && !this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                this.fillMask[j] = hue >= this.minHue && hue <= this.maxHue || sat < this.minSat || sat > this.maxSat || bri >= this.minBri && bri <= this.maxBri ? fill : keep;
            }
        } else if (this.bandPassH.getState() && !this.bandPassS.getState() && this.bandPassB.getState()) {
            for (j = 0; j < this.numPixels; ++j) {
                hue = this.hSource[j] & 0xFF;
                sat = this.sSource[j] & 0xFF;
                bri = this.bSource[j] & 0xFF;
                this.fillMask[j] = hue < this.minHue || hue > this.maxHue || sat >= this.minSat && sat <= this.maxSat || bri < this.minBri || bri > this.maxBri ? fill : keep;
            }
        }
        ip.fill(this.fillMaskIP);
        if (this.threshold.getState()) {
            ip.invert();
            for (j = 0; j < this.numPixels; ++j) {
                this.fillMask[j] = this.fillMask[j] == fill ? keep : fill;
            }
            ip.fill(this.fillMaskIP);
            ip.invert();
        }
    }

    void applyStack() {
        for (int i = 1; i <= this.numSlices; ++i) {
            this.imp.setSlice(i);
            if (!this.checkImage()) {
                return;
            }
            this.apply(this.imp, this.ip);
        }
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        int[] pixels = (int[])ip.getPixels();
        for (int i = 0; i < this.numPixels; ++i) {
            pixels[i] = this.restore[i];
        }
    }

    public void windowActivated(WindowEvent e) {
        if (this.checkImage()) {
            this.ip = this.setup(WindowManager.getCurrentImage());
            this.reset(this.imp, this.ip);
            this.filteredB.setEnabled(true);
        }
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        ColorThresholder colorThresholder = this;
        synchronized (colorThresholder) {
            this.notify();
        }
    }

    public void getLab(ImageProcessor ip, byte[] L, byte[] a, byte[] b) {
        int i = 0;
        double ot = 0.3333333333333333;
        double cont = 0.13793103448275862;
        int width = ip.getWidth();
        int height = ip.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int c = ip.getPixel(x, y);
                double rf = (double)((c & 0xFF0000) >> 16) / 255.0;
                double gf = (double)((c & 0xFF00) >> 8) / 255.0;
                double bf = (double)(c & 0xFF) / 255.0;
                double X = 0.430587 * rf + 0.341545 * gf + 0.178336 * bf;
                double Y = 0.222021 * rf + 0.706645 * gf + 0.0713342 * bf;
                double Z = 0.0201837 * rf + 0.129551 * gf + 0.939234 * bf;
                double fX = X > 0.008856 ? Math.pow(X, ot) : 7.78707 * X + cont;
                double fY = Y > 0.008856 ? Math.pow(Y, ot) : 7.78707 * Y + cont;
                double fZ = Z > 0.008856 ? Math.pow(Z, ot) : 7.78707 * Z + cont;
                double La = 116.0 * fY - 16.0;
                double aa = 500.0 * (fX - fY);
                double bb = 200.0 * (fY - fZ);
                La = (int)(La * 2.55);
                aa = (int)Math.floor(1.0625 * aa + 128.0 + 0.5);
                bb = (int)Math.floor(1.0625 * bb + 128.0 + 0.5);
                L[i] = (byte)((int)(La < 0.0 ? 0.0 : (La > 255.0 ? 255.0 : La)) & 0xFF);
                a[i] = (byte)((int)(aa < 0.0 ? 0.0 : (aa > 255.0 ? 255.0 : aa)) & 0xFF);
                b[i] = (byte)((int)(bb < 0.0 ? 0.0 : (bb > 255.0 ? 255.0 : bb)) & 0xFF);
                ++i;
            }
        }
    }

    public void getYUV(ImageProcessor ip, byte[] Y, byte[] U, byte[] V) {
        int i = 0;
        int width = ip.getWidth();
        int height = ip.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int c = ip.getPixel(x, y);
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                double yf = 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
                Y[i] = (byte)Math.floor(yf + 0.5);
                U[i] = (byte)(128 + (int)Math.floor(0.493 * ((double)b - yf) + 0.5));
                V[i] = (byte)(128 + (int)Math.floor(0.877 * ((double)r - yf) + 0.5));
                ++i;
            }
        }
    }

    class BandPlot
    extends Canvas
    implements Measurements,
    MouseListener {
        final int WIDTH = 256;
        final int HEIGHT = 86;
        double minHue = 0.0;
        double minSat = 0.0;
        double minBri = 0.0;
        double maxHue = 255.0;
        double maxSat = 255.0;
        double maxBri = 255.0;
        int[] histogram;
        Color[] hColors;
        int hmax;
        Image os;
        Graphics osg;

        public BandPlot() {
            this.addMouseListener(this);
            this.setSize(257, 87);
        }

        public Dimension getPreferredSize() {
            return new Dimension(257, 87);
        }

        void setHistogram(ImagePlus imp, int j) {
            block23: {
                block28: {
                    block30: {
                        block29: {
                            block25: {
                                block27: {
                                    block26: {
                                        byte[] b;
                                        byte[] g;
                                        byte[] r;
                                        block21: {
                                            block24: {
                                                block22: {
                                                    ImageProcessor ip = imp.getProcessor();
                                                    ImageStatistics stats = ImageStatistics.getStatistics(ip, 9, null);
                                                    int maxCount2 = 0;
                                                    this.histogram = stats.histogram;
                                                    for (int i = 0; i < stats.nBins; ++i) {
                                                        if (this.histogram[i] <= maxCount2) continue;
                                                        maxCount2 = this.histogram[i];
                                                    }
                                                    this.hmax = (int)((double)maxCount2 * 1.15);
                                                    this.os = null;
                                                    ColorModel cm = ip.getColorModel();
                                                    if (!(cm instanceof IndexColorModel)) {
                                                        return;
                                                    }
                                                    IndexColorModel icm = (IndexColorModel)cm;
                                                    int mapSize = icm.getMapSize();
                                                    if (mapSize != 256) {
                                                        return;
                                                    }
                                                    r = new byte[256];
                                                    g = new byte[256];
                                                    b = new byte[256];
                                                    icm.getReds(r);
                                                    icm.getGreens(g);
                                                    icm.getBlues(b);
                                                    this.hColors = new Color[256];
                                                    if (ColorThresholder.this.colmode != 1) break block21;
                                                    if (j != 0) break block22;
                                                    for (int i = 0; i < 256; ++i) {
                                                        this.hColors[i] = new Color(i & 0xFF, 0, 0);
                                                    }
                                                    break block23;
                                                }
                                                if (j != 1) break block24;
                                                for (int i = 0; i < 256; ++i) {
                                                    this.hColors[i] = new Color(0, i & 0xFF, 0);
                                                }
                                                break block23;
                                            }
                                            if (j != 2) break block23;
                                            for (int i = 0; i < 256; ++i) {
                                                this.hColors[i] = new Color(0, 0, i & 0xFF);
                                            }
                                            break block23;
                                        }
                                        if (ColorThresholder.this.colmode != 0) break block25;
                                        if (j != 0) break block26;
                                        for (int i = 0; i < 256; ++i) {
                                            this.hColors[i] = new Color(r[i] & 0xFF, g[i] & 0xFF, b[i] & 0xFF);
                                        }
                                        break block23;
                                    }
                                    if (j != 1) break block27;
                                    for (int i = 0; i < 256; ++i) {
                                        this.hColors[i] = new Color(255, 255 - i & 0xFF, 255 - i & 0xFF);
                                    }
                                    break block23;
                                }
                                if (j != 2) break block23;
                                for (int i = 0; i < 256; ++i) {
                                    this.hColors[i] = new Color(i & 0xFF, i & 0xFF, i & 0xFF);
                                }
                                break block23;
                            }
                            if (ColorThresholder.this.colmode != 2) break block28;
                            if (j != 0) break block29;
                            for (int i = 0; i < 256; ++i) {
                                this.hColors[i] = new Color(i & 0xFF, i & 0xFF, i & 0xFF);
                            }
                            break block23;
                        }
                        if (j != 1) break block30;
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color(i & 0xFF, 255 - i & 0xFF, 0);
                        }
                        break block23;
                    }
                    if (j != 2) break block23;
                    for (int i = 0; i < 256; ++i) {
                        this.hColors[i] = new Color(i & 0xFF, i & 0xFF, 255 - i & 0xFF);
                    }
                    break block23;
                }
                if (ColorThresholder.this.colmode == 3) {
                    if (j == 0) {
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color(i & 0xFF, i & 0xFF, i & 0xFF);
                        }
                    } else if (j == 1) {
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color((int)(36.0 + (double)(255 - i) / 1.4) & 0xFF, 255 - i & 0xFF, i & 0xFF);
                        }
                    } else if (j == 2) {
                        for (int i = 0; i < 256; ++i) {
                            this.hColors[i] = new Color(i & 0xFF, 255 - i & 0xFF, (int)(83.0 + (double)(255 - i) / 2.87) & 0xFF);
                        }
                    }
                }
            }
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            int hHist = 0;
            if (this.histogram != null) {
                if (this.os == null) {
                    this.os = this.createImage(256, 86);
                    this.osg = this.os.getGraphics();
                    this.osg.setColor(new Color(140, 152, 144));
                    this.osg.fillRect(0, 0, 256, 86);
                    for (int i = 0; i < 256; ++i) {
                        if (this.hColors != null) {
                            this.osg.setColor(this.hColors[i]);
                        }
                        hHist = 86 - 86 * this.histogram[i] / this.hmax - 6;
                        this.osg.drawLine(i, 86, i, hHist);
                        this.osg.setColor(Color.black);
                        this.osg.drawLine(i, hHist, i, hHist);
                    }
                    this.osg.dispose();
                }
                if (this.os != null) {
                    g.drawImage(this.os, 0, 0, this);
                }
            } else {
                g.setColor(Color.white);
                g.fillRect(0, 0, 256, 86);
            }
            g.setColor(Color.black);
            g.drawLine(0, 80, 256, 80);
            g.drawRect(0, 0, 256, 86);
            g.drawRect((int)this.minHue, 1, (int)(this.maxHue - this.minHue), 79);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }
    }
}

