/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

class ContrastBrightnessPlot
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int WIDTH = 256;
    private int HEIGHT = 128;
    private double defaultMin = 0.0;
    private double defaultMax = 255.0;
    private double min = 0.0;
    private double max = 255.0;
    private int[] histogram;
    private int hmax;
    private Image os;
    private Color color = Color.gray;

    public double getDefaultMin() {
        return this.defaultMin;
    }

    public void setDefaultMin(double defaultMin) {
        this.defaultMin = defaultMin;
    }

    public double getDefaultMax() {
        return this.defaultMax;
    }

    public void setDefaultMax(double defaultMax) {
        this.defaultMax = defaultMax;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public ContrastBrightnessPlot() {
        this.setSize(this.WIDTH + 1, this.HEIGHT + 1);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.WIDTH + 1, this.HEIGHT + 1);
    }

    public void setHistogram(ImageStatistics stats, Color color) {
        this.color = color;
        this.histogram = stats.histogram;
        if (this.histogram.length != 256) {
            this.histogram = null;
            return;
        }
        int maxCount = 0;
        int mode = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.histogram[i] <= maxCount) continue;
            maxCount = this.histogram[i];
            mode = i;
        }
        int maxCount2 = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.histogram[i] <= maxCount2 || i == mode) continue;
            maxCount2 = this.histogram[i];
        }
        this.hmax = stats.maxCount;
        if (this.hmax > maxCount2 * 2 && maxCount2 != 0) {
            this.histogram[mode] = this.hmax = (int)((double)maxCount2 * 1.5);
        }
        this.os = null;
    }

    public void paint(Graphics g) {
        int y2;
        int x2;
        int y1;
        int x1;
        double scale = (double)this.WIDTH / (this.defaultMax - this.defaultMin);
        double slope = 0.0;
        if (this.max != this.min) {
            slope = (double)this.HEIGHT / (this.max - this.min);
        }
        if (this.min >= this.defaultMin) {
            x1 = (int)(scale * (this.min - this.defaultMin));
            y1 = this.HEIGHT;
        } else {
            x1 = 0;
            y1 = this.max > this.min ? this.HEIGHT - (int)((this.defaultMin - this.min) * slope) : this.HEIGHT;
        }
        if (this.max <= this.defaultMax) {
            x2 = (int)(scale * (this.max - this.defaultMin));
            y2 = 0;
        } else {
            x2 = this.WIDTH;
            y2 = this.max > this.min ? this.HEIGHT - (int)((this.defaultMax - this.min) * slope) : 0;
        }
        if (this.histogram != null) {
            if (this.os == null && this.hmax != 0) {
                this.os = this.createImage(this.WIDTH, this.HEIGHT);
                Graphics osg = this.os.getGraphics();
                osg.setColor(Color.white);
                osg.fillRect(0, 0, this.WIDTH, this.HEIGHT);
                osg.setColor(this.color);
                for (int i = 0; i < this.WIDTH; ++i) {
                    osg.drawLine(i, this.HEIGHT, i, this.HEIGHT - this.HEIGHT * this.histogram[i] / this.hmax);
                }
                osg.dispose();
            }
            if (this.os != null) {
                g.drawImage(this.os, 0, 0, this);
            }
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
        }
        g.setColor(Color.black);
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x2, this.HEIGHT - 5, x2, this.HEIGHT);
        g.drawRect(0, 0, this.WIDTH, this.HEIGHT);
    }
}

