/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorStackDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;

    public ErrorStackDialog(List<Throwable> throwns) {
        super("Error stack");
        this.setDefaultCloseOperation(2);
        JTextArea messageArea = new JTextArea();
        messageArea.setWrapStyleWord(true);
        messageArea.setLineWrap(true);
        messageArea.setMaximumSize(new Dimension(400, 400));
        for (Throwable t : throwns) {
            StackTraceElement[] elements;
            if (t.getStackTrace() == null || t.getStackTrace().length <= 0) continue;
            for (StackTraceElement element : elements = t.getStackTrace()) {
                messageArea.append(element.toString() + "\n\n");
            }
        }
        JScrollPane messageScrollPane = new JScrollPane();
        messageScrollPane.setViewportView(messageArea);
        messageScrollPane.setHorizontalScrollBarPolicy(30);
        messageScrollPane.setVerticalScrollBarPolicy(20);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(messageScrollPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setAlignmentX(0.5f);
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(this);
        buttonPanel.add(closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(500, 500);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null && e.getActionCommand().equals("close")) {
            this.dispose();
        }
    }
}

