/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ImageViewer imageViewer;
    public int width;
    public int height;
    private int mode;
    private BufferedImage loadingImage;

    public ImagePanel(ImageViewer imageViewer) {
        this.imageViewer = imageViewer;
        if (imageViewer.getImages() != null && imageViewer.getImages().size() > 0) {
            this.setPreferredSize(new Dimension(imageViewer.getImageHandler().getImage().getWidth() + 10, imageViewer.getImageHandler().getImage().getHeight() + 10));
            this.updateImage();
        } else {
            this.setPreferredSize(new Dimension(imageViewer.getMaxImageWidth() + 100, imageViewer.getMaxImageHeight() + 100));
        }
    }

    public void updateImage() {
        this.width = this.imageViewer.getImageHandler().getImage().getWidth();
        this.height = this.imageViewer.getImageHandler().getImage().getHeight();
        if (!this.imageViewer.getImageScale().equals("thumbnail")) {
            double scale = Double.parseDouble(this.imageViewer.getImageScale()) / 100.0;
            this.width = (int)((double)this.width * scale);
            this.height = (int)((double)this.height * scale);
        }
        this.setPreferredSize(new Dimension(this.width + 10, this.height + 10));
        this.revalidate();
        this.mode = 0;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int x = (this.getWidth() - this.width) / 2;
        int y = (this.getHeight() - this.height) / 2;
        if (this.mode == 0) {
            if (this.imageViewer.getImageHandler() != null && this.imageViewer.getImageHandler().getImage() != null && this.imageViewer.getImageHandler().getImage().getBufferedImage() != null) {
                g.drawImage(this.imageViewer.getImageHandler().getImage().getBufferedImage(), x, y, this.width, this.height, this);
            }
        } else if (this.mode == 2) {
            g.drawImage(this.loadingImage, x, y, this);
        }
    }

    public void cleanImagePanel() {
        this.mode = 1;
        this.repaint();
    }

    public void showLoadingImage() {
        this.mode = 1;
        this.update(this.getGraphics());
        if (this.loadingImage != null) {
            this.width = this.loadingImage.getWidth();
            this.height = this.loadingImage.getHeight();
            this.setPreferredSize(new Dimension(this.imageViewer.getImagePanelScrollWraper().getWidth(), this.imageViewer.getImagePanelScrollWraper().getHeight()));
            this.setSize(new Dimension(this.imageViewer.getImagePanelScrollWraper().getWidth(), this.imageViewer.getImagePanelScrollWraper().getHeight()));
            this.mode = 2;
            this.update(this.getGraphics());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadingImage() throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream("/ch/systemsx/sybit/imageviewer/test/loading.gif");
        try {
            this.loadingImage = ImageIO.read(inputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

