/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import ch.systemsx.sybit.imageviewer.processors.ImageUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private ImageIcon thumbnail = null;
    private File file = null;

    public ImagePreview(JFileChooser fileChooser) {
        this.setPreferredSize(new Dimension(100, 50));
        fileChooser.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String property = e.getPropertyName();
        if ("directoryChanged".equals(property)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(property)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    public void loadImage() {
        if (this.file == null || this.file.isDirectory()) {
            this.thumbnail = null;
            return;
        }
        String extension = null;
        String fileName = this.file.getName();
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            extension = fileName.substring(i + 1).toLowerCase();
        }
        if (extension != null && (extension.equals("tiff") || extension.equals("tif"))) {
            return;
        }
        try {
            this.thumbnail = ImageUtil.getScaledImageIcon(ImageIO.read(this.file), 40, 40, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, graphics, x, y);
        }
    }
}

