/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class ImagesList
extends JList {
    private static final long serialVersionUID = 1L;
    private ImageViewer imageViewer;

    public ImagesList(ImageViewer imageViewer, DefaultListModel model) {
        super(model);
        this.imageViewer = imageViewer;
    }

    public String getToolTipText(MouseEvent event) {
        Point point = event.getPoint();
        int index = this.locationToIndex(point);
        Point displayPoint = this.indexToLocation(index);
        String result = null;
        if (this.imageViewer.getImages().size() > 0) {
            PlateImageReference plateImageReference = this.imageViewer.getImages().get(index).getImageReference();
            if (point.getX() <= displayPoint.getX() + 50.0 && point.getY() <= displayPoint.getY() + 50.0) {
                if (plateImageReference != null) {
                    result = plateImageReference.toString();
                } else if (this.imageViewer.getImages().get(index).getPath() != null) {
                    result = this.imageViewer.getImages().get(index).getPath();
                }
            }
        }
        return result;
    }

    public Point getToolTipLocation(MouseEvent event) {
        Point point = event.getPoint();
        int index = this.locationToIndex(point);
        if (index != -1) {
            return this.indexToLocation(index);
        }
        return null;
    }
}

