/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import ch.systemsx.sybit.imageviewer.data.ImageViewerParameters;
import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import ch.systemsx.sybit.imageviewer.processors.ImageUtil;
import ch.systemsx.sybit.imageviewer.processors.LutProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class LutPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel buttonPanel;
    private JToggleButton fireButton;
    private JToggleButton graysButton;
    private JToggleButton iceButton;
    private JToggleButton spectrumButton;
    private JToggleButton rgb332Button;
    private JToggleButton redButton;
    private JToggleButton greenButton;
    private JToggleButton blueButton;
    private JToggleButton cyanButton;
    private JToggleButton magentaButton;
    private JToggleButton yellowButton;
    private JToggleButton redGreenButton;
    private JButton resetButton;
    private ImageViewer imageViewer;
    private ImageViewerParameters imageViewerParameters;
    private LutProcessor lutProcessor;
    private List<String> channelLabels;
    private JComboBox colorsCombobox;

    public LutPanel(ImageViewer imageViewer) {
        this.imageViewer = imageViewer;
        this.channelLabels = new ArrayList<String>();
        if (imageViewer.getImageHandler() != null && imageViewer.getImageHandler().getImage() != null && imageViewer.getImageHandler().getOriginalImage() != null && (imageViewer.getImageHandler().getOriginalImage().getType() == 4 || imageViewer.getImageHandler().getOriginalImage().getStackSize() > 1)) {
            this.channelLabels.add("Channel Red");
            this.channelLabels.add("Channel Green");
            this.channelLabels.add("Channel Blue");
            this.channelLabels.add("All channels");
        } else {
            this.channelLabels.add("Channel 1");
        }
        this.lutProcessor = new LutProcessor();
        this.imageViewerParameters = imageViewer.getImageViewerParameters();
        this.setPreferredSize(new Dimension(350, 100));
        this.setLayout(new BorderLayout());
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new BoxLayout(internalPanel, 1));
        this.colorsCombobox = new JComboBox<Object>(this.channelLabels.toArray());
        this.colorsCombobox.addActionListener(this);
        JPanel colorsPanel = new JPanel(new BorderLayout());
        colorsPanel.setBorder(BorderFactory.createEmptyBorder(10, 30, 20, 31));
        colorsPanel.add((Component)this.colorsCombobox, "North");
        internalPanel.add(colorsPanel);
        JPanel wrappingPanel = new JPanel(new FlowLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(4, 3));
        this.fireButton = new JToggleButton("Fire");
        this.fireButton.setActionCommand("fire");
        this.fireButton.addActionListener(this);
        this.buttonPanel.add(this.fireButton);
        this.graysButton = new JToggleButton("Grays");
        this.graysButton.setActionCommand("grays");
        this.graysButton.addActionListener(this);
        this.buttonPanel.add(this.graysButton);
        this.iceButton = new JToggleButton("Ice");
        this.iceButton.setActionCommand("ice");
        this.iceButton.addActionListener(this);
        this.buttonPanel.add(this.iceButton);
        this.spectrumButton = new JToggleButton("Spectrum");
        this.spectrumButton.setActionCommand("spectrum");
        this.spectrumButton.addActionListener(this);
        this.buttonPanel.add(this.spectrumButton);
        this.rgb332Button = new JToggleButton("3-3-2 RGB");
        this.rgb332Button.setActionCommand("3-3-2 RGB");
        this.rgb332Button.addActionListener(this);
        this.buttonPanel.add(this.rgb332Button);
        this.redButton = new JToggleButton("Red");
        this.redButton.setActionCommand("red");
        this.redButton.addActionListener(this);
        this.buttonPanel.add(this.redButton);
        this.greenButton = new JToggleButton("Green");
        this.greenButton.setActionCommand("green");
        this.greenButton.addActionListener(this);
        this.buttonPanel.add(this.greenButton);
        this.blueButton = new JToggleButton("Blue");
        this.blueButton.setActionCommand("blue");
        this.blueButton.addActionListener(this);
        this.buttonPanel.add(this.blueButton);
        this.cyanButton = new JToggleButton("Cyan");
        this.cyanButton.setActionCommand("cyan");
        this.cyanButton.addActionListener(this);
        this.buttonPanel.add(this.cyanButton);
        this.magentaButton = new JToggleButton("Magenta");
        this.magentaButton.setActionCommand("magenta");
        this.magentaButton.addActionListener(this);
        this.buttonPanel.add(this.magentaButton);
        this.yellowButton = new JToggleButton("Yellow");
        this.yellowButton.setActionCommand("yellow");
        this.yellowButton.addActionListener(this);
        this.buttonPanel.add(this.yellowButton);
        this.redGreenButton = new JToggleButton("Red/Green");
        this.redGreenButton.setActionCommand("redgreen");
        this.redGreenButton.addActionListener(this);
        this.buttonPanel.add(this.redGreenButton);
        wrappingPanel.add(this.buttonPanel);
        internalPanel.add(wrappingPanel);
        wrappingPanel = new JPanel(new FlowLayout());
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        this.resetButton.setPreferredSize(this.redGreenButton.getPreferredSize());
        this.resetButton.setSize(this.redGreenButton.getSize());
        wrappingPanel.add(this.resetButton);
        internalPanel.add(wrappingPanel);
        this.add((Component)internalPanel, "North");
        this.selectButtons(this.imageViewerParameters.getLutOperation());
        if (this.imageViewerParameters.getLutOperation().equals("") || this.imageViewerParameters.getLutOperation().equals("none")) {
            this.colorsCombobox.setSelectedItem("All channels");
            this.colorsCombobox.setEnabled(false);
        } else if (this.imageViewerParameters.getSlice() == -1) {
            this.colorsCombobox.setSelectedItem("All channels");
        } else if (this.colorsCombobox.getItemCount() >= this.imageViewerParameters.getSlice()) {
            this.colorsCombobox.setSelectedIndex(this.imageViewerParameters.getSlice() - 1);
        }
    }

    private void selectButtons(String command) {
        Component[] components;
        for (Component component : components = this.buttonPanel.getComponents()) {
            if (!(component instanceof JToggleButton)) continue;
            JToggleButton button = (JToggleButton)component;
            if (((JToggleButton)component).getActionCommand().equals(command)) {
                button.setSelected(true);
                continue;
            }
            if (!button.isSelected()) continue;
            button.setSelected(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == null) {
                return;
            }
            if (e.getSource() instanceof JToggleButton || e.getSource() == this.resetButton) {
                this.imageViewer.getImageHandler().getImage().getProcessor().reset();
                if (e.getSource() == this.resetButton || !((JToggleButton)e.getSource()).isSelected()) {
                    this.selectButtons("");
                    this.imageViewerParameters.setLutOperation("");
                    this.colorsCombobox.setSelectedItem("All channels");
                    this.colorsCombobox.setEnabled(false);
                    if (this.imageViewer.getImageHandler().getImage().getType() != 4 && this.imageViewer.getImageHandler().getOriginalImage() != null && this.imageViewer.getImageHandler().getOriginalImage().getType() == 4 && !this.imageViewer.getImageHandler().getImage().getStack().isRGB()) {
                        this.lutProcessor.restoreOriginalImage(this.imageViewer.getImageHandler());
                    } else {
                        this.lutProcessor.doOperation("", this.imageViewerParameters.getSlice(), this.imageViewer.getImageHandler().getImage(), this.imageViewer.getImageHandler().getOriginalColorModel());
                    }
                    if (this.imageViewer.getImageHandler().getImage().getType() == 4) {
                        this.imageViewer.getImageHandler().getImage().getProcessor().snapshot();
                        this.imageViewer.showColorPanel();
                    }
                } else {
                    this.selectButtons(e.getActionCommand());
                    if (this.colorsCombobox.getSelectedItem().equals("All channels") && this.imageViewer.getImageHandler().getOriginalImage() != null && this.imageViewer.getImageHandler().getOriginalImage().getType() == 4) {
                        this.imageViewerParameters.setSlice(-1);
                        this.imageViewer.getImageHandler().setOriginalColorModel(this.imageViewer.getImageHandler().getImage().getProcessor().getColorModel());
                        this.lutProcessor.restoreOriginalImage(this.imageViewer.getImageHandler());
                    }
                    this.lutProcessor.doOperation(e.getActionCommand(), this.imageViewerParameters.getSlice(), this.imageViewer.getImageHandler().getImage(), this.imageViewer.getImageHandler().getOriginalColorModel());
                    this.imageViewerParameters.setLutOperation(e.getActionCommand());
                    if (this.imageViewerParameters.getSlice() != -1) {
                        if (this.colorsCombobox.getItemCount() >= this.imageViewerParameters.getSlice()) {
                            this.colorsCombobox.setSelectedIndex(this.imageViewerParameters.getSlice() - 1);
                        } else {
                            this.colorsCombobox.setSelectedIndex(0);
                        }
                    } else {
                        this.colorsCombobox.setSelectedItem("All channels");
                    }
                    this.colorsCombobox.setEnabled(true);
                    this.imageViewer.hideColorPanel();
                }
                this.imageViewer.getImageHandler().getImage().getProcessor().snapshot();
                ImageUtil.modifyContrastBrightness(this.imageViewer.getImageHandler().getImage(), this.imageViewerParameters);
                this.imageViewer.updateImage();
            } else if (e.getSource() == this.colorsCombobox && !this.colorsCombobox.getSelectedItem().equals("All channels") && this.imageViewer.getImageHandler() != null && this.imageViewer.getImageHandler().getImage() != null) {
                if (this.imageViewer.getImageHandler().getImage().getType() != 4 && this.imageViewer.getImageHandler().getOriginalImage() != null && this.imageViewer.getImageHandler().getOriginalImage().getType() == 4 && !this.imageViewer.getImageHandler().getImage().getStack().isRGB()) {
                    this.lutProcessor.restoreOriginalImage(this.imageViewer.getImageHandler());
                } else {
                    this.imageViewer.getImageHandler().getImage().getProcessor().reset();
                }
                JComboBox cb = (JComboBox)e.getSource();
                this.imageViewerParameters.setSlice(this.channelLabels.indexOf((String)cb.getSelectedItem()) + 1);
                this.lutProcessor.doOperation(this.imageViewerParameters.getLutOperation(), this.imageViewerParameters.getSlice(), this.imageViewer.getImageHandler().getImage(), this.imageViewer.getImageHandler().getOriginalColorModel());
                if (this.imageViewerParameters.getSlice() != -1) {
                    this.imageViewer.getImageHandler().getImage().setSlice(this.imageViewerParameters.getSlice());
                }
                this.imageViewer.getImageHandler().getImage().getProcessor().snapshot();
                ImageUtil.modifyContrastBrightness(this.imageViewer.getImageHandler().getImage(), this.imageViewerParameters);
                this.imageViewer.updateImage();
            } else if (e.getSource() == this.colorsCombobox && this.colorsCombobox.getSelectedItem().equals("All channels") && this.imageViewer.getImageHandler() != null && !this.imageViewerParameters.getLutOperation().equals("") && this.imageViewer.getImageHandler().getImage() != null) {
                this.imageViewerParameters.setSlice(-1);
                this.lutProcessor.restoreOriginalImage(this.imageViewer.getImageHandler());
                this.imageViewer.getImageHandler().setOriginalColorModel(this.imageViewer.getImageHandler().getImage().getProcessor().getColorModel());
                this.lutProcessor.doOperation(this.imageViewerParameters.getLutOperation(), this.imageViewerParameters.getSlice(), this.imageViewer.getImageHandler().getImage(), this.imageViewer.getImageHandler().getOriginalColorModel());
                this.imageViewer.getImageHandler().getImage().getProcessor().snapshot();
                ImageUtil.modifyContrastBrightness(this.imageViewer.getImageHandler().getImage(), this.imageViewerParameters);
                this.imageViewer.updateImage();
            }
        }
        catch (Throwable t) {
            this.imageViewer.showErrorDialog("Error during processing image", t, true);
        }
    }

    public LutProcessor getLutProcessor() {
        return this.lutProcessor;
    }
}

