/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.processors;

import ch.systemsx.sybit.imageviewer.data.ImageViewerParameters;
import ch.systemsx.sybit.imageviewer.data.MinMaxInChannel;
import ch.systemsx.sybit.imageviewer.processors.ImageUtil;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContrastBrightnessProcessor {
    private ImageViewerParameters imageViewerParameters;
    private double defaultMin;
    private double defaultMax;
    private Map<Integer, MinMaxInChannel> minMaxInChannels;
    private int autoThreshold;
    private boolean RGBImage;
    private int ALL_CHANNELS = 3;
    private int AUTO_THRESHOLD = 5000;

    public ContrastBrightnessProcessor(int type, boolean balance, ImageViewerParameters imageViewerParameters) {
        this.imageViewerParameters = imageViewerParameters;
        this.RGBImage = type == 4;
        this.defaultMin = 0.0;
        this.defaultMax = 255.0;
    }

    public Map<Integer, MinMaxInChannel> getMinMaxInChannels() {
        return this.minMaxInChannels;
    }

    public void setMinMaxInChannels(Map<Integer, MinMaxInChannel> minMaxInChannels) {
        this.minMaxInChannels = minMaxInChannels;
    }

    public boolean isRGBImage() {
        return this.RGBImage;
    }

    public void setRGBImage(boolean rGBImage) {
        this.RGBImage = rGBImage;
    }

    public double getMin(int channels) {
        if (this.minMaxInChannels.containsKey(channels)) {
            return this.minMaxInChannels.get(channels).getMin();
        }
        return this.imageViewerParameters.getMin();
    }

    public void setMin(double min, int channels) {
        if (channels == this.ALL_CHANNELS) {
            this.imageViewerParameters.setMin(min);
        } else if (!this.minMaxInChannels.containsKey(channels)) {
            this.minMaxInChannels.put(channels, new MinMaxInChannel(min, this.imageViewerParameters.getMax()));
        } else {
            this.minMaxInChannels.get(channels).setMin(min);
        }
    }

    public double getMax(int channels) {
        if (this.minMaxInChannels.containsKey(channels)) {
            return this.minMaxInChannels.get(channels).getMax();
        }
        return this.imageViewerParameters.getMax();
    }

    public void setMax(double max, int channels) {
        if (channels == this.ALL_CHANNELS) {
            this.imageViewerParameters.setMax(max);
        } else if (!this.minMaxInChannels.containsKey(channels)) {
            this.minMaxInChannels.put(channels, new MinMaxInChannel(this.imageViewerParameters.getMin(), max));
        } else {
            this.minMaxInChannels.get(channels).setMax(max);
        }
    }

    public double getDefaultMin() {
        return this.defaultMin;
    }

    public void setDefaultMin(double defaultMin) {
        this.defaultMin = defaultMin;
    }

    public double getDefaultMax() {
        return this.defaultMax;
    }

    public void setDefaultMax(double defaultMax) {
        this.defaultMax = defaultMax;
    }

    public boolean autoAdjust(ImagePlus imagePlus, int channels) {
        double calculatedMin;
        double calculatedMax;
        int count;
        if (this.RGBImage) {
            imagePlus.getProcessor().reset();
        }
        Calibration cal = imagePlus.getCalibration();
        imagePlus.setCalibration(null);
        ImageStatistics stats = imagePlus.getStatistics();
        imagePlus.setCalibration(cal);
        int limit = stats.pixelCount / 10;
        int[] histogram = stats.histogram;
        this.autoThreshold = this.autoThreshold < 10 ? this.AUTO_THRESHOLD : (this.autoThreshold /= 2);
        int threshold = stats.pixelCount / this.autoThreshold;
        int i = -1;
        boolean found = false;
        do {
            if ((count = histogram[++i]) > limit) {
                count = 0;
            }
            boolean bl = found = count > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        do {
            if ((count = histogram[--i]) > limit) {
                count = 0;
            }
            boolean bl = found = count > threshold;
        } while (!found && i > 0);
        int hmax = i;
        if (hmax >= hmin) {
            Object[] calculatedMinAndMax;
            calculatedMax = stats.histMin + (double)hmax * stats.binSize;
            calculatedMin = stats.histMin + (double)hmin * stats.binSize;
            if (calculatedMax == calculatedMin) {
                calculatedMin = stats.min;
                calculatedMax = stats.max;
            }
            if (imagePlus.getType() == 2) {
                calculatedMinAndMax = ImageUtil.calculateImageMinAndMaxForFloatProcessor(imagePlus);
                float floatMin = calculatedMinAndMax[0];
                float floatMax = calculatedMinAndMax[1];
                calculatedMin = (calculatedMin - (double)floatMin) * 255.0 / (double)(floatMax - floatMin);
                calculatedMax = (calculatedMax - (double)floatMin) * 255.0 / (double)(floatMax - floatMin);
            }
            if (imagePlus.getType() == 1) {
                calculatedMinAndMax = ImageUtil.calculateImageMinAndMaxForShortProcessor(imagePlus);
                float shortMin = calculatedMinAndMax[0];
                float shortMax = calculatedMinAndMax[1];
                calculatedMin = (calculatedMin - (double)shortMin) * 255.0 / (double)(shortMax - shortMin);
                calculatedMax = (calculatedMax - (double)shortMin) * 255.0 / (double)(shortMax - shortMin);
            }
        } else {
            this.reset(imagePlus, channels);
            return false;
        }
        this.imageViewerParameters.setMin(calculatedMin);
        this.imageViewerParameters.setMax(calculatedMax);
        this.setMinAndMax(imagePlus, calculatedMin, calculatedMax, channels);
        return true;
    }

    public void setMinAndMax(ImagePlus imagePlus, double min, double max, int channels) {
        if (channels != this.ALL_CHANNELS && imagePlus.getType() == 4) {
            if (max < min) {
                return;
            }
            int min2 = (int)min;
            int[] lut = new int[256];
            for (int i = 0; i < 256; ++i) {
                int v = i - min2;
                if ((v = (int)(256.0 * (double)v / (max - min))) < 0) {
                    v = 0;
                }
                if (v > 255) {
                    v = 255;
                }
                lut[i] = v;
            }
            int[] pixels = (int[])imagePlus.getProcessor().getPixels();
            int[] originalPixels = (int[])imagePlus.getProcessor().getSnapshotPixels();
            int r = 0;
            int g = 0;
            int b = 0;
            for (int i = 0; i < pixels.length; ++i) {
                int c = pixels[i];
                if (channels == 0) {
                    r = lut[(originalPixels[i] & 0xFF0000) >> 16];
                    g = (c & 0xFF00) >> 8;
                    b = c & 0xFF;
                } else if (channels == 1) {
                    r = (c & 0xFF0000) >> 16;
                    g = lut[(originalPixels[i] & 0xFF00) >> 8];
                    b = c & 0xFF;
                } else if (channels == 2) {
                    r = (c & 0xFF0000) >> 16;
                    g = (c & 0xFF00) >> 8;
                    b = lut[originalPixels[i] & 0xFF];
                }
                pixels[i] = -16777216 + (r << 16) + (g << 8) + b;
            }
        } else if (imagePlus.getType() == 1) {
            int shortMin;
            int[] calculatedMinAndMax = ImageUtil.calculateImageMinAndMaxForShortProcessor(imagePlus);
            int shortMax = calculatedMinAndMax[1];
            double adjustedMin = min * (double)(shortMax - (shortMin = calculatedMinAndMax[0])) / 255.0 + (double)shortMin;
            if (adjustedMin < 0.0) {
                adjustedMin = 0.0;
            }
            double adjustedMax = max * (double)(shortMax - shortMin) / 255.0 + (double)shortMin;
            imagePlus.setDisplayRange(adjustedMin, adjustedMax);
        } else if (imagePlus.getType() == 2) {
            float[] calculatedMinAndMax = ImageUtil.calculateImageMinAndMaxForFloatProcessor(imagePlus);
            float floatMin = calculatedMinAndMax[0];
            float floatMax = calculatedMinAndMax[1];
            double adjustedMin = min * (double)(floatMax - floatMin) / 255.0 + (double)floatMin;
            double adjustedMax = max * (double)(floatMax - floatMin) / 255.0 + (double)floatMin;
            imagePlus.setDisplayRange(adjustedMin, adjustedMax);
        } else {
            imagePlus.setDisplayRange(min, max);
        }
    }

    public void reset(ImagePlus imagePlus, int channels) {
        if (this.RGBImage && channels == this.ALL_CHANNELS) {
            imagePlus.getProcessor().reset();
        }
        if (imagePlus.getProcessor() instanceof ShortProcessor || imagePlus.getProcessor() instanceof FloatProcessor) {
            imagePlus.resetDisplayRange();
        }
        if (channels == this.ALL_CHANNELS) {
            this.imageViewerParameters.setMin(this.defaultMin);
            this.imageViewerParameters.setMax(this.defaultMax);
            this.setMinAndMax(imagePlus, this.imageViewerParameters.getMin(), this.imageViewerParameters.getMax(), channels);
        } else {
            this.setMinAndMax(imagePlus, this.imageViewerParameters.getMin(), this.imageViewerParameters.getMax(), channels);
            this.minMaxInChannels.remove(channels);
        }
        this.autoThreshold = 0;
    }

    public void setThreshold(ImagePlus imagePlus) {
        if (!(imagePlus.getProcessor() instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)imagePlus.getProcessor()).isInvertedLut()) {
            imagePlus.getProcessor().setThreshold(this.imageViewerParameters.getMax(), 255.0, 2);
        } else {
            imagePlus.getProcessor().setThreshold(0.0, this.imageViewerParameters.getMax(), 2);
        }
    }

    public void doMasking(ImagePlus imagePlus) {
        ImageProcessor mask = imagePlus.getMask();
        if (mask != null) {
            imagePlus.getProcessor().reset(mask);
        }
    }
}

