/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql;

import java.sql.Connection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.DataSource;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.ServiceUtil;
import net.lemnik.eodsql.impl.DefaultQueryFactory;
import net.lemnik.eodsql.spi.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryFactoryChain {
    private final ThreadLocal<CreateContext> chain = new ThreadLocal<CreateContext>(){

        @Override
        protected CreateContext initialValue() {
            return new CreateContext(QueryFactoryChain.this.factories.iterator());
        }
    };
    private final List<QueryFactory> factories = new CopyOnWriteArrayList<QueryFactory>();

    QueryFactoryChain() {
        this.add(new DefaultQueryFactory());
        for (QueryFactory queryFactory : ServiceUtil.load(QueryFactory.class)) {
            this.add(queryFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends BaseQuery> T create(DataSource dataSource, Class<T> clazz, ClassLoader classLoader) throws InvalidQueryException {
        if (this.factories.size() == 1) {
            QueryFactory queryFactory = this.factories.get(0);
            if (queryFactory.canConstruct(clazz)) {
                return queryFactory.construct(dataSource, clazz, classLoader);
            }
            return null;
        }
        T t = null;
        CreateContext createContext = this.chain.get();
        createContext.incEntries();
        try {
            Iterator iterator = createContext.iterator;
            while (iterator.hasNext()) {
                QueryFactory queryFactory = (QueryFactory)iterator.next();
                if (!queryFactory.canConstruct(clazz)) continue;
                t = queryFactory.construct(dataSource, clazz, classLoader);
                break;
            }
        }
        finally {
            if (createContext.decEntries() == 0) {
                this.chain.remove();
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends BaseQuery> T create(Connection connection, Class<T> clazz, ClassLoader classLoader) throws InvalidQueryException {
        if (this.factories.size() == 1) {
            QueryFactory queryFactory = this.factories.get(0);
            if (queryFactory.canConstruct(clazz)) {
                return queryFactory.construct(connection, clazz, classLoader);
            }
            return null;
        }
        CreateContext createContext = this.chain.get();
        createContext.incEntries();
        T t = null;
        try {
            Iterator iterator = createContext.iterator;
            while (iterator.hasNext()) {
                QueryFactory queryFactory = (QueryFactory)iterator.next();
                if (!queryFactory.canConstruct(clazz)) continue;
                t = queryFactory.construct(connection, clazz, classLoader);
                break;
            }
        }
        finally {
            if (createContext.decEntries() == 0) {
                this.chain.remove();
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends BaseQuery> T create(String string, Class<T> clazz, ClassLoader classLoader) throws InvalidQueryException {
        if (this.factories.size() == 1) {
            QueryFactory queryFactory = this.factories.get(0);
            if (queryFactory.canConstruct(clazz)) {
                return queryFactory.construct(string, clazz, classLoader);
            }
            return null;
        }
        CreateContext createContext = this.chain.get();
        createContext.incEntries();
        T t = null;
        try {
            Iterator iterator = createContext.iterator;
            while (iterator.hasNext()) {
                QueryFactory queryFactory = (QueryFactory)iterator.next();
                if (!queryFactory.canConstruct(clazz)) continue;
                t = queryFactory.construct(string, clazz, classLoader);
                break;
            }
        }
        finally {
            if (createContext.decEntries() == 0) {
                this.chain.remove();
            }
        }
        return t;
    }

    void add(QueryFactory queryFactory) {
        this.factories.add(0, queryFactory);
    }

    void remove(QueryFactory queryFactory) {
        this.factories.removeAll(Collections.singleton(queryFactory));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CreateContext {
        private final Iterator<QueryFactory> iterator;
        private int entries = 0;

        public CreateContext(Iterator<QueryFactory> iterator) {
            assert (iterator != null);
            this.iterator = iterator;
        }

        public int incEntries() {
            return ++this.entries;
        }

        public int decEntries() {
            return --this.entries;
        }
    }
}

