/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.lemnik.eodsql.Call;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.DataSet;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.Select;
import net.lemnik.eodsql.TypeMapper;
import net.lemnik.eodsql.Update;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.MethodImplementation;
import net.lemnik.eodsql.spi.StatementResource;
import net.lemnik.eodsql.spi.util.Query;
import net.lemnik.eodsql.spi.util.ResultSetWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMethodImplementation<A extends Annotation>
implements MethodImplementation<A> {
    private static final List<Integer> ALL_RESULT_SET_TYPES = Arrays.asList(1005, 1004, 1003);
    protected ResultSetWrapper<?> wrapper = null;
    protected Query query = null;
    private TypeMapper<?>[] parameterMappers = null;

    AbstractMethodImplementation() {
    }

    protected PreparedStatement createPreparedStatement(Context<A> context) throws SQLException {
        Connection connection = context.getResource(Connection.class).get();
        int n = this.wrapper.getPreferredResultSetType();
        int n2 = this.getResultSetType(connection.getMetaData(), n);
        if (this.supportsScrolling(n) && !this.supportsScrolling(n2)) {
            if (this.isDisconnected(context)) {
                n2 = 1003;
            } else {
                String string = connection.getMetaData().getDatabaseProductName();
                throw new SQLException("This database (" + string + ") does not support scrollable cursors, thus connected DataSets are not available.");
            }
        }
        PreparedStatement preparedStatement = connection.prepareStatement(this.query.toString(), n2, this.wrapper.getPreferredResultSetConcurrency());
        int n3 = this.getQueryTimeout(context);
        if (n3 > 0) {
            try {
                preparedStatement.setQueryTimeout(n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        context.setResource(new StatementResource(preparedStatement));
        return preparedStatement;
    }

    private int getResultSetType(DatabaseMetaData databaseMetaData, int n) throws SQLException {
        if (databaseMetaData.supportsResultSetType(n)) {
            return n;
        }
        for (int n2 : ALL_RESULT_SET_TYPES) {
            if (!databaseMetaData.supportsResultSetType(n2)) continue;
            return n2;
        }
        return 1003;
    }

    private boolean supportsScrolling(int n) {
        return n == 1005 || n == 1004;
    }

    private boolean isDisconnected(Context<A> context) {
        if (context.getAnnotation() instanceof Select && ((Select)context.getAnnotation()).disconnected()) {
            return true;
        }
        return !DataSet.class.isAssignableFrom(context.getReturnType()) && !DataIterator.class.isAssignableFrom(context.getReturnType());
    }

    private int getQueryTimeout(Context<A> context) {
        if (context.getAnnotation() instanceof Select) {
            Select select = (Select)context.getAnnotation();
            if (select.timeoutParameterIndex() > 0 && context.getParameters()[select.timeoutParameterIndex() - 1] != null) {
                return (Integer)context.getParameters()[select.timeoutParameterIndex() - 1];
            }
            return select.timeout();
        }
        if (context.getAnnotation() instanceof Update) {
            Update update = (Update)context.getAnnotation();
            if (update.timeoutParameterIndex() > 0 && context.getParameters()[update.timeoutParameterIndex() - 1] != null) {
                return (Integer)context.getParameters()[update.timeoutParameterIndex() - 1];
            }
            return update.timeout();
        }
        if (context.getAnnotation() instanceof Call) {
            Call call = (Call)context.getAnnotation();
            if (call.timeoutParameterIndex() > 0 && context.getParameters()[call.timeoutParameterIndex() - 1] != null) {
                return (Integer)context.getParameters()[call.timeoutParameterIndex() - 1];
            }
            return call.timeout();
        }
        return 0;
    }

    protected void fillPreparedStatementParameters(Context<?> context, PreparedStatement preparedStatement) throws SQLException {
        TypeMapper<?>[] typeMapperArray = this.getParameterMappers();
        for (int i = 0; i < typeMapperArray.length; ++i) {
            Object object = this.query.getParameter(context, i);
            TypeMapper<?> typeMapper = typeMapperArray[i];
            typeMapper.set(preparedStatement, i + 1, object);
        }
    }

    protected TypeMapper<?>[] getParameterMappers() {
        TypeMapper<?>[] typeMapperArray = this.parameterMappers;
        if (typeMapperArray == null) {
            this.parameterMappers = typeMapperArray = AbstractMethodImplementation.getParameterTypeMappers(this.query, null);
        }
        return typeMapperArray;
    }

    protected void setParameterMappers(Class<? extends TypeMapper>[] classArray) {
        this.parameterMappers = AbstractMethodImplementation.getParameterTypeMappers(this.query, classArray);
    }

    protected static TypeMapper<?>[] getParameterTypeMappers(Query query, Class<? extends TypeMapper>[] classArray) {
        int n = query.getParameterCount();
        TypeMapper[] typeMapperArray = new TypeMapper[n];
        Map<Class, TypeMapper> map = QueryTool.getTypeMap();
        for (int i = 0; i < n; ++i) {
            Constructor<TypeMapper> constructor = AbstractMethodImplementation.getConstructor(classArray, i);
            if (constructor != null) {
                try {
                    typeMapperArray[i] = constructor.newInstance(new Object[0]);
                    continue;
                }
                catch (Exception exception) {
                    throw new InvalidQueryException("Cannot construct custom type mapper " + constructor.getName(), exception);
                }
            }
            TypeMapper typeMapper = map.get(query.getParameterType(i));
            if (typeMapper != null) {
                typeMapperArray[i] = typeMapper;
                continue;
            }
            throw new InvalidQueryException("Unknown primitive type: " + query.getParameterType(i).getName());
        }
        return typeMapperArray;
    }

    private static Constructor<? extends TypeMapper> getConstructor(Class<? extends TypeMapper>[] classArray, int n) {
        if (classArray == null || n >= classArray.length) {
            return null;
        }
        Class<? extends TypeMapper> clazz = classArray[n];
        if (clazz.isInterface()) {
            return null;
        }
        try {
            return clazz.getConstructor(new Class[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("TypeMapper classes must have a default (null) constructor", exception);
        }
    }
}

