/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.TypeMapper;

class DefaultTypeMappers {
    static void register() {
        Map<Class, TypeMapper> map = QueryTool.getTypeMap();
        map.put(Byte.class, new ByteMapper(true));
        map.put(Byte.TYPE, new ByteMapper(false));
        map.put(Short.class, new ShortMapper(true));
        map.put(Short.TYPE, new ShortMapper(false));
        map.put(Integer.class, new IntegerMapper(true));
        map.put(Integer.TYPE, new IntegerMapper(false));
        map.put(Long.class, new LongMapper(true));
        map.put(Long.TYPE, new LongMapper(false));
        map.put(Float.class, new FloatMapper(true));
        map.put(Float.TYPE, new FloatMapper(false));
        map.put(Double.class, new DoubleMapper(true));
        map.put(Double.TYPE, new DoubleMapper(false));
        map.put(Boolean.class, new BooleanMapper(true));
        map.put(Boolean.TYPE, new BooleanMapper(false));
        map.put(Character.class, new CharacterMapper());
        map.put(Character.TYPE, new CharacterMapper());
        map.put(String.class, new StringMapper());
        map.put(UUID.class, new UUIDMapper());
        map.put(java.util.Date.class, new DateMapper());
        map.put(BigDecimal.class, new BigDecimalMapper());
        map.put(BigInteger.class, new BigIntegerMapper());
        map.put(byte[].class, new ByteArrayMapper());
    }

    private DefaultTypeMappers() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteArrayMapper
    implements TypeMapper<byte[]> {
        ByteArrayMapper() {
        }

        @Override
        public byte[] get(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getBytes(n);
        }

        @Override
        public void set(ResultSet resultSet, int n, byte[] byArray) throws SQLException {
            resultSet.updateBytes(n, byArray);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
            if (byArray != null) {
                preparedStatement.setBytes(n, byArray);
            } else {
                preparedStatement.setNull(n, -3);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BigIntegerMapper
    implements TypeMapper<BigInteger> {
        BigIntegerMapper() {
        }

        @Override
        public BigInteger get(ResultSet resultSet, int n) throws SQLException {
            byte[] byArray = resultSet.getBytes(n);
            return byArray == null ? null : new BigInteger(byArray);
        }

        @Override
        public void set(ResultSet resultSet, int n, BigInteger bigInteger) throws SQLException {
            resultSet.updateBytes(n, bigInteger.toByteArray());
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, BigInteger bigInteger) throws SQLException {
            if (bigInteger != null) {
                preparedStatement.setBytes(n, bigInteger.toByteArray());
            } else {
                preparedStatement.setNull(n, -3);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BigDecimalMapper
    implements TypeMapper<BigDecimal> {
        BigDecimalMapper() {
        }

        @Override
        public BigDecimal get(ResultSet resultSet, int n) throws SQLException {
            try {
                return resultSet.getBigDecimal(n);
            }
            catch (SQLException sQLException) {
                Object object = resultSet.getObject(n);
                if (object instanceof Float || object instanceof Double) {
                    return new BigDecimal(((Number)object).doubleValue());
                }
                if (object instanceof Number) {
                    return new BigDecimal(((Number)object).longValue());
                }
                if (object instanceof String) {
                    return new BigDecimal((String)object);
                }
                throw sQLException;
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, BigDecimal bigDecimal) throws SQLException {
            resultSet.updateBigDecimal(n, bigDecimal);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, BigDecimal bigDecimal) throws SQLException {
            preparedStatement.setBigDecimal(n, bigDecimal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DateMapper
    implements TypeMapper<java.util.Date> {
        DateMapper() {
        }

        @Override
        public java.util.Date get(ResultSet resultSet, int n) throws SQLException {
            try {
                return resultSet.getTimestamp(n);
            }
            catch (SQLException sQLException) {
                try {
                    Object object = resultSet.getObject(n);
                    if (object instanceof Long) {
                        return new java.util.Date((Long)object);
                    }
                    return (java.util.Date)object;
                }
                catch (SQLException sQLException2) {
                    return resultSet.getDate(n);
                }
                catch (ClassCastException classCastException) {
                    return resultSet.getDate(n);
                }
            }
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, java.util.Date date) throws SQLException {
            if (date != null) {
                long l = date.getTime();
                try {
                    preparedStatement.setTimestamp(n, new Timestamp(l));
                }
                catch (SQLException sQLException) {
                    try {
                        preparedStatement.setDate(n, new Date(l));
                    }
                    catch (SQLException sQLException2) {
                        preparedStatement.setObject(n, date);
                    }
                }
            } else {
                preparedStatement.setNull(n, 93);
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, java.util.Date date) throws SQLException {
            resultSet.updateTimestamp(n, new Timestamp(date.getTime()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UUIDMapper
    implements TypeMapper<UUID> {
        UUIDMapper() {
        }

        @Override
        public UUID get(ResultSet resultSet, int n) throws SQLException {
            String string = resultSet.getString(n);
            if (string != null) {
                return UUID.fromString(string);
            }
            return null;
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, UUID uUID) throws SQLException {
            if (uUID != null) {
                preparedStatement.setString(n, uUID.toString());
            } else {
                preparedStatement.setNull(n, 12);
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, UUID uUID) throws SQLException {
            resultSet.updateString(n, uUID.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringMapper
    implements TypeMapper<String> {
        StringMapper() {
        }

        @Override
        public String get(ResultSet resultSet, int n) throws SQLException {
            return resultSet.getString(n);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, String string) throws SQLException {
            if (string != null) {
                preparedStatement.setString(n, string);
            } else {
                preparedStatement.setNull(n, 12);
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, String string) throws SQLException {
            resultSet.updateString(n, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CharacterMapper
    implements TypeMapper<Character> {
        CharacterMapper() {
        }

        @Override
        public Character get(ResultSet resultSet, int n) throws SQLException {
            String string = resultSet.getString(n);
            if (string != null) {
                return Character.valueOf(string.charAt(0));
            }
            return null;
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, Character c) throws SQLException {
            if (c != null) {
                preparedStatement.setString(n, c.toString());
            } else {
                preparedStatement.setNull(n, 1);
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, Character c) throws SQLException {
            resultSet.updateString(n, c.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BooleanMapper
    implements TypeMapper<Boolean> {
        private final boolean mayReturnNull;

        BooleanMapper(boolean bl) {
            this.mayReturnNull = bl;
        }

        @Override
        public Boolean get(ResultSet resultSet, int n) throws SQLException {
            boolean bl = resultSet.getBoolean(n);
            return this.mayReturnNull && resultSet.wasNull() ? null : Boolean.valueOf(bl);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, Boolean bl) throws SQLException {
            if (bl != null) {
                preparedStatement.setBoolean(n, bl);
            } else {
                preparedStatement.setNull(n, 16);
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, Boolean bl) throws SQLException {
            resultSet.updateBoolean(n, (boolean)bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DoubleMapper
    implements TypeMapper<Double> {
        private final boolean mayReturnNull;

        DoubleMapper(boolean bl) {
            this.mayReturnNull = bl;
        }

        @Override
        public Double get(ResultSet resultSet, int n) throws SQLException {
            double d = resultSet.getDouble(n);
            return this.mayReturnNull && resultSet.wasNull() ? null : Double.valueOf(d);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, Double d) throws SQLException {
            if (d != null) {
                preparedStatement.setDouble(n, d);
            } else {
                preparedStatement.setNull(n, 8);
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, Double d) throws SQLException {
            resultSet.updateDouble(n, (double)d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FloatMapper
    implements TypeMapper<Float> {
        private final boolean mayReturnNull;

        FloatMapper(boolean bl) {
            this.mayReturnNull = bl;
        }

        @Override
        public Float get(ResultSet resultSet, int n) throws SQLException {
            float f = resultSet.getFloat(n);
            return this.mayReturnNull && resultSet.wasNull() ? null : Float.valueOf(f);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, Float f) throws SQLException {
            if (f != null) {
                preparedStatement.setFloat(n, f.floatValue());
            } else {
                preparedStatement.setNull(n, 6);
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, Float f) throws SQLException {
            resultSet.updateFloat(n, f.floatValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LongMapper
    implements TypeMapper<Long> {
        private final boolean mayReturnNull;

        LongMapper(boolean bl) {
            this.mayReturnNull = bl;
        }

        @Override
        public Long get(ResultSet resultSet, int n) throws SQLException {
            long l = resultSet.getLong(n);
            return this.mayReturnNull && resultSet.wasNull() ? null : Long.valueOf(l);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, Long l) throws SQLException {
            if (l != null) {
                preparedStatement.setLong(n, l);
            } else {
                preparedStatement.setNull(n, -5);
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, Long l) throws SQLException {
            resultSet.updateLong(n, (long)l);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntegerMapper
    implements TypeMapper<Integer> {
        private final boolean mayReturnNull;

        IntegerMapper(boolean bl) {
            this.mayReturnNull = bl;
        }

        @Override
        public Integer get(ResultSet resultSet, int n) throws SQLException {
            int n2 = resultSet.getInt(n);
            return this.mayReturnNull && resultSet.wasNull() ? null : Integer.valueOf(n2);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, Integer n2) throws SQLException {
            if (n2 != null) {
                preparedStatement.setInt(n, n2);
            } else {
                preparedStatement.setNull(n, 4);
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, Integer n2) throws SQLException {
            resultSet.updateInt(n, (int)n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ShortMapper
    implements TypeMapper<Short> {
        private final boolean mayReturnNull;

        ShortMapper(boolean bl) {
            this.mayReturnNull = bl;
        }

        @Override
        public Short get(ResultSet resultSet, int n) throws SQLException {
            short s = resultSet.getShort(n);
            return this.mayReturnNull && resultSet.wasNull() ? null : Short.valueOf(s);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, Short s) throws SQLException {
            if (s != null) {
                preparedStatement.setShort(n, s);
            } else {
                preparedStatement.setNull(n, 5);
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, Short s) throws SQLException {
            resultSet.updateShort(n, (short)s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteMapper
    implements TypeMapper<Byte> {
        private final boolean mayReturnNull;

        ByteMapper(boolean bl) {
            this.mayReturnNull = bl;
        }

        @Override
        public Byte get(ResultSet resultSet, int n) throws SQLException {
            byte by = resultSet.getByte(n);
            return this.mayReturnNull && resultSet.wasNull() ? null : Byte.valueOf(by);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n, Byte by) throws SQLException {
            if (by != null) {
                preparedStatement.setByte(n, by);
            } else {
                preparedStatement.setNull(n, -6);
            }
        }

        @Override
        public void set(ResultSet resultSet, int n, Byte by) throws SQLException {
            resultSet.updateByte(n, (byte)by);
        }
    }
}

