/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.util.DataObjectBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDataIterator<T>
implements DataIterator<T> {
    private Context<?> context;
    protected ResultSet results;
    protected DataObjectBinding<T> binding;
    private T nextObject = null;
    private boolean closed = false;

    protected AbstractDataIterator(Context<?> context, DataObjectBinding<T> binding) {
        this.context = context;
        this.binding = binding;
        this.results = context.getResource(ResultSet.class).get();
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new EoDException("A DataIterator's methods may not be invoked if it is closed.");
        }
    }

    protected abstract T unmarshal() throws SQLException;

    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.context.close();
                this.closed = true;
            }
            catch (SQLException sqle) {
                throw new EoDException(sqle);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean hasNext() {
        this.ensureOpen();
        if (this.nextObject != null) {
            return true;
        }
        try {
            if (this.results.next()) {
                this.nextObject = this.unmarshal();
                return true;
            }
            this.close();
            return false;
        }
        catch (SQLException sqle) {
            throw new EoDException(sqle);
        }
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T returnObject = this.nextObject;
            this.nextObject = null;
            return returnObject;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported in a DataIterator.");
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

