/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.InvalidDataTypeException;
import net.lemnik.eodsql.spi.util.AbstractResultSetWrapper;
import net.lemnik.eodsql.spi.util.DataObjectBinding;
import net.lemnik.eodsql.spi.util.ResultSetWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayWrapper
extends AbstractResultSetWrapper<Object, Object> {
    private boolean useSlowWrap = false;

    ArrayWrapper(DataObjectBinding<Object> dataObjectBinding) {
        super(dataObjectBinding);
    }

    private Object slowWrap(ResultSet resultSet) throws SQLException {
        block8: {
            this.useSlowWrap = true;
            try {
                if (resultSet.isBeforeFirst() || resultSet.isFirst()) break block8;
                try {
                    resultSet.beforeFirst();
                }
                catch (SQLException sQLException) {
                    throw new EoDException("Something is very wrong with this ResultSet. There may be a bug in your JDBC Driver. The ResultSet does not support the beforeFirst() command, and is reporting a position that is not before or on the first row.", sQLException);
                }
            }
            catch (SQLException sQLException) {
                throw new EoDException("Something is very wrong with this ResultSet. There may be a bug in your JDBC Driver. The ResultSet cannot report whether it is before or on the first row.", sQLException);
            }
        }
        ExpandingArray expandingArray = new ExpandingArray();
        if (!resultSet.isBeforeFirst()) {
            if (resultSet.isFirst()) {
                expandingArray.add(this.binding.unmarshall(resultSet));
            } else {
                throw new EoDException("Something is very wrong with this ResultSet. There may be a bug in your JDBC Driver. The ResultSet should either be on or before the first row, but it is somewhere else.");
            }
        }
        while (resultSet.next()) {
            expandingArray.add(this.binding.unmarshall(resultSet));
        }
        return expandingArray.toArray();
    }

    @Override
    public Object wrap(ResultSet resultSet) throws SQLException {
        int n;
        block7: {
            if (this.useSlowWrap) {
                return this.slowWrap(resultSet);
            }
            n = -1;
            try {
                resultSet.setFetchDirection(1001);
                if (resultSet.last()) {
                    try {
                        n = resultSet.getRow();
                        break block7;
                    }
                    catch (SQLException sQLException) {
                        return this.slowWrap(resultSet);
                    }
                }
                return Array.newInstance(this.binding.getObjectType(), 0);
            }
            catch (SQLException sQLException) {
                return this.slowWrap(resultSet);
            }
        }
        Object object = Array.newInstance(this.binding.getObjectType(), n);
        int n2 = n;
        do {
            Array.set(object, --n2, this.binding.unmarshall(resultSet));
        } while (resultSet.previous());
        return object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Factory
    implements ResultSetWrapper.Factory {
        Factory() {
        }

        @Override
        public boolean isTypeConstructable(Type type, Map<String, Object> map) throws InvalidDataTypeException {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return clazz.isArray() && !clazz.getComponentType().isArray();
            }
            return ResultSetWrapper.isStringObjectMapArray(type);
        }

        @Override
        public ResultSetWrapper create(Type type, Map<String, Object> map) {
            DataObjectBinding.BindingType bindingType = map.containsKey("net.lemnik.eodsql.spi.util.ResultSetWrapper#bindingType") ? (DataObjectBinding.BindingType)((Object)map.get("net.lemnik.eodsql.spi.util.ResultSetWrapper#bindingType")) : DataObjectBinding.BindingType.NORMAL_BINDING;
            Class<?> clazz = ResultSetWrapper.toClass(type);
            if (map.containsKey("net.lemnik.eodsql.spi.util.ResultSetWrapper#binding")) {
                DataObjectBinding dataObjectBinding = (DataObjectBinding)map.get("net.lemnik.eodsql.spi.util.ResultSetWrapper#binding");
                dataObjectBinding.setObjectType(clazz.getComponentType());
                return new ArrayWrapper(dataObjectBinding);
            }
            return new ArrayWrapper(DataObjectBinding.getDataObjectBinding(clazz.getComponentType(), bindingType));
        }
    }

    private class ExpandingArray {
        private int index = 0;
        private int length = 10;
        private Object array = this.allocate(this.length);

        private ExpandingArray() {
        }

        private Object allocate(int n) {
            return Array.newInstance(ArrayWrapper.this.binding.getObjectType(), n);
        }

        public void add(Object object) {
            if (this.index == this.length) {
                int n = this.length * 3 / 2 + 1;
                if (n < this.length + 1) {
                    n = this.length + 1;
                }
                Object object2 = this.allocate(n);
                System.arraycopy(this.array, 0, object2, 0, this.length);
                this.length = n;
                this.array = object2;
            }
            Array.set(this.array, this.index++, object);
        }

        public Object toArray() {
            if (this.index < this.length) {
                Object object = this.allocate(this.index);
                System.arraycopy(this.array, 0, object, 0, this.index);
                return object;
            }
            return this.array;
        }
    }
}

