/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.lemnik.eodsql.AutoGeneratedKeys;
import net.lemnik.eodsql.ResultColumn;
import net.lemnik.eodsql.spi.util.MutableColumn;
import net.lemnik.eodsql.spi.util.MutableField;
import net.lemnik.eodsql.spi.util.MutableProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataObjectBindingCache {
    public static final boolean HAVE_ACCESSIBLE_PERMISSION = DataObjectBindingCache.checkAccessablePermission();
    private static final ConcurrentMap<Class<?>, CachedBinding> cache = new ConcurrentHashMap();
    private static final ReferenceQueue<DataObjectBindingCache> referenceQueue = new ReferenceQueue();
    private final Map<ColumnName, MutableColumn> normalColumns = new HashMap<ColumnName, MutableColumn>();
    private final Map<ColumnName, MutableColumn> keyColumns = new HashMap<ColumnName, MutableColumn>();

    private DataObjectBindingCache(Class<?> clazz) {
        for (Class<?> current = clazz; current != Object.class; current = current.getSuperclass()) {
            boolean keyType = current.isAnnotationPresent(AutoGeneratedKeys.class);
            this.scanFields(current, keyType);
            this.scanMethods(current, keyType);
        }
    }

    private void addColumnImpl(Map<ColumnName, MutableColumn> map, String name, MutableColumn column) {
        ColumnName columnName = new ColumnName(name);
        map.put(columnName, column);
    }

    private void addColumn(String name, MutableColumn column) {
        this.addColumnImpl(this.normalColumns, name, column);
    }

    private void addKeyColumn(String name, MutableColumn column) {
        this.addColumnImpl(this.keyColumns, name, column);
        this.addColumnImpl(this.normalColumns, name, column);
    }

    private void scanFields(Class<?> clazz, boolean keyType) throws SecurityException {
        Field[] fields;
        for (Field f : fields = clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) && !HAVE_ACCESSIBLE_PERMISSION) continue;
            String name = f.getName();
            if (f.isAnnotationPresent(ResultColumn.class)) {
                ResultColumn col = f.getAnnotation(ResultColumn.class);
                name = col.value();
            }
            if (keyType || f.isAnnotationPresent(AutoGeneratedKeys.class)) {
                this.addKeyColumn(name, new MutableField(name, f, HAVE_ACCESSIBLE_PERMISSION));
                continue;
            }
            this.addColumn(name, new MutableField(name, f, HAVE_ACCESSIBLE_PERMISSION));
        }
    }

    private void scanMethods(Class<?> clazz, boolean keyType) throws SecurityException {
        Method[] methods;
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers()) && !HAVE_ACCESSIBLE_PERMISSION || !m.isAnnotationPresent(ResultColumn.class) || m.getParameterTypes().length != 1) continue;
            ResultColumn col = m.getAnnotation(ResultColumn.class);
            if (keyType || m.isAnnotationPresent(AutoGeneratedKeys.class)) {
                this.addKeyColumn(col.value(), new MutableProperty(col.value(), m, null, m.getParameterTypes()[0], HAVE_ACCESSIBLE_PERMISSION));
                continue;
            }
            this.addColumn(col.value(), new MutableProperty(col.value(), m, null, m.getParameterTypes()[0], HAVE_ACCESSIBLE_PERMISSION));
        }
    }

    private static boolean checkAccessablePermission() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            try {
                manager.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
            catch (SecurityException exception) {
                return false;
            }
        }
        return true;
    }

    private static void purgeOldReferences() {
        CachedBinding binding;
        while ((binding = (CachedBinding)referenceQueue.poll()) != null) {
            cache.replace(binding.dataObjectClass, binding);
        }
    }

    private static DataObjectBindingCache putCachedBinding(CachedBinding bindingRef, DataObjectBindingCache binding) {
        DataObjectBindingCache existingBinding;
        CachedBinding existing = cache.putIfAbsent(bindingRef.dataObjectClass, bindingRef);
        if (existing != null && (existingBinding = existing.get()) == null) {
            return DataObjectBindingCache.putCachedBinding(bindingRef, binding);
        }
        return binding;
    }

    private static DataObjectBindingCache createDataObjectBinding(Class<?> clazz) {
        DataObjectBindingCache cachedBinding = new DataObjectBindingCache(clazz);
        CachedBinding binding = new CachedBinding(cachedBinding, referenceQueue, clazz);
        return DataObjectBindingCache.putCachedBinding(binding, cachedBinding);
    }

    Map<ColumnName, MutableColumn> getNormalColumns() {
        return this.normalColumns;
    }

    Map<ColumnName, MutableColumn> getKeyColumns() {
        return this.keyColumns;
    }

    static DataObjectBindingCache getDataObjectBindingCache(Class<?> clazz) {
        DataObjectBindingCache.purgeOldReferences();
        CachedBinding bindingReference = (CachedBinding)cache.get(clazz);
        if (bindingReference == null) {
            return DataObjectBindingCache.createDataObjectBinding(clazz);
        }
        DataObjectBindingCache bindingCache = bindingReference.get();
        if (bindingCache == null) {
            return DataObjectBindingCache.createDataObjectBinding(clazz);
        }
        return bindingCache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedBinding
    extends SoftReference<DataObjectBindingCache> {
        private final Class<?> dataObjectClass;

        public CachedBinding(DataObjectBindingCache referent, ReferenceQueue<? super DataObjectBindingCache> q, Class<?> dataObjectClass) {
            super(referent, q);
            this.dataObjectClass = dataObjectClass;
        }

        @Override
        public DataObjectBindingCache get() {
            DataObjectBindingCache object = (DataObjectBindingCache)super.get();
            if (object == null) {
                cache.remove(this.dataObjectClass);
            }
            return object;
        }
    }

    static class ColumnName {
        private final String column;
        private final String ucase;

        public ColumnName(String name) {
            this.column = name;
            this.ucase = this.column.toUpperCase();
        }

        public String getColumnName() {
            return this.column;
        }

        public int hashCode() {
            return this.ucase.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ColumnName) {
                return this.ucase.equals(((ColumnName)obj).ucase);
            }
            return false;
        }

        public String toString() {
            return this.getColumnName();
        }
    }
}

