/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.file;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import org.apache.commons.lang.StringUtils;

public class CachingAuthenticationConfiguration {
    private String passwordCacheFile;
    private IAuthenticationService delegate;
    private long cacheTime = 100800000L;
    private long cacheTimeNoRevalidation = 3600000L;

    public String getPasswordCacheFile() {
        return this.passwordCacheFile;
    }

    public void setPasswordCacheFile(String passwordCacheFile) {
        this.passwordCacheFile = passwordCacheFile;
    }

    public IAuthenticationService getDelegate() {
        return this.delegate;
    }

    public void setDelegate(IAuthenticationService delegate) {
        this.delegate = delegate;
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    public void setCacheTime(long cacheTime) {
        this.cacheTime = cacheTime;
    }

    public String getCacheTimeStr() {
        return Long.toString(this.getCacheTime() / 1000L);
    }

    public void setCacheTimeStr(String cacheTimeStr) {
        if (CachingAuthenticationConfiguration.isResolved(cacheTimeStr)) {
            this.setCacheTime(DateTimeUtils.parseDurationToMillis(cacheTimeStr));
        }
    }

    public long getCacheTimeNoRevalidation() {
        return this.cacheTimeNoRevalidation;
    }

    public void setCacheTimeNoRevalidation(long cacheTimeNoRevalidation) {
        this.cacheTimeNoRevalidation = cacheTimeNoRevalidation;
    }

    public String getCacheTimeNoRevalidationStr() {
        return Long.toString(this.getCacheTimeNoRevalidation() / 1000L);
    }

    public void setCacheTimeNoRevalidationStr(String cacheTimeNoRevalidationStr) {
        if (CachingAuthenticationConfiguration.isResolved(cacheTimeNoRevalidationStr)) {
            this.setCacheTimeNoRevalidation(DateTimeUtils.parseDurationToMillis(cacheTimeNoRevalidationStr));
        }
    }

    private static boolean isResolved(String name) {
        return StringUtils.isNotBlank((String)name) && !name.startsWith("${");
    }
}

