/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.db;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class StandardSequenceNameMapper
implements ISequenceNameMapper {
    private final Set<String> tablesWithoutSequencers;
    private final Map<String, String> nonstandardMapping;

    public StandardSequenceNameMapper() {
        this(Collections.emptyMap(), Collections.emptySet());
    }

    public StandardSequenceNameMapper(Map<String, String> nonstandardMapping, Set<String> tablesWithoutSequencers) {
        this.tablesWithoutSequencers = tablesWithoutSequencers;
        this.nonstandardMapping = nonstandardMapping;
    }

    @Override
    public final String getSequencerForTable(String tableName) {
        String tableNameInLowerCase = tableName.toLowerCase();
        if (this.tablesWithoutSequencers.contains(tableNameInLowerCase)) {
            return null;
        }
        String sequenceName = this.nonstandardMapping.get(tableNameInLowerCase);
        if (sequenceName == null) {
            sequenceName = String.valueOf(tableNameInLowerCase.substring(0, tableNameInLowerCase.length() - 1)) + "_id_seq";
        }
        return sequenceName;
    }
}

