/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.filesystem.ResultStatus;
import java.io.Serializable;

public class BooleanStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ResultStatus<Boolean> result;

    private BooleanStatus(Boolean result, boolean errorOccurred, String messageOrNull) {
        this.result = new ResultStatus<Boolean>(result, errorOccurred, messageOrNull);
    }

    public static final BooleanStatus createTrue() {
        return new BooleanStatus(true, false, null);
    }

    public static final BooleanStatus createFalse(String message) {
        assert (message != null);
        return new BooleanStatus(false, false, message);
    }

    public static final BooleanStatus createFalse() {
        return new BooleanStatus(false, false, null);
    }

    public static final BooleanStatus createError(String message) {
        assert (message != null);
        return new BooleanStatus(null, true, message);
    }

    public static BooleanStatus createFromBoolean(boolean result) {
        return new BooleanStatus(result, false, null);
    }

    public boolean isSuccess() {
        return !this.isError() && this.getResult();
    }

    public boolean isError() {
        return this.result.isError();
    }

    public boolean getResult() {
        return this.result.getResult();
    }

    public String tryGetMessage() {
        return this.result.tryGetMessage();
    }
}

