/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.control;

import ch.systemsx.cisd.common.filesystem.control.IEventFeed;
import ch.systemsx.cisd.common.filesystem.control.IEventFilter;
import ch.systemsx.cisd.common.filesystem.control.IValueFilter;
import ch.systemsx.cisd.common.filesystem.control.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParameterMap {
    private final Map<String, IValueFilter> parameterNameToValueFilterMap;
    private final Map<String, Parameter> parameterNameToParameterMap;
    private final IEventFeed eventFeed;

    public ParameterMap(IEventFeed eventFeed) {
        this.eventFeed = eventFeed;
        this.parameterNameToValueFilterMap = new HashMap<String, IValueFilter>();
        this.parameterNameToParameterMap = new HashMap<String, Parameter>();
    }

    public synchronized void addParameter(String parameterName, String defaultValue) {
        this.addParameter(parameterName, defaultValue, new AcceptAllValuesFilter());
    }

    public synchronized void addParameter(String parameterName, String defaultValue, IValueFilter valueFilter) {
        if (!valueFilter.isValid(defaultValue)) {
            throw new IllegalArgumentException("Default value " + defaultValue + " is not valid value for parameter " + parameterName);
        }
        this.parameterNameToValueFilterMap.put(parameterName, valueFilter);
        if (defaultValue != null) {
            this.parameterNameToParameterMap.put(parameterName, new Parameter(parameterName, defaultValue));
        }
    }

    public synchronized Parameter getParameterValue(String parameterName) {
        List<Parameter> parameters = this.loadParameters();
        for (Parameter parameter : parameters) {
            this.parameterNameToParameterMap.put(parameter.getName(), parameter);
        }
        return this.parameterNameToParameterMap.get(parameterName);
    }

    public synchronized void removeParameterValue(String parameterName) {
        this.parameterNameToParameterMap.remove(parameterName);
    }

    private List<Parameter> loadParameters() {
        List<String> events = this.eventFeed.getNewEvents(new AcceptEventsWithPrefixesFilter(this.getParameterNames()));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (String event : events) {
            IValueFilter valueFilter;
            String longestMatchingParameterName = null;
            for (String parameterName : this.getParameterNames()) {
                if (!event.startsWith(parameterName) || longestMatchingParameterName != null && longestMatchingParameterName.length() >= parameterName.length()) continue;
                longestMatchingParameterName = parameterName;
            }
            if (longestMatchingParameterName == null) continue;
            String parameterValue = null;
            if (event.length() > longestMatchingParameterName.length() && event.charAt(longestMatchingParameterName.length()) == '-') {
                parameterValue = event.substring(longestMatchingParameterName.length() + 1);
            }
            if ((valueFilter = this.parameterNameToValueFilterMap.get(longestMatchingParameterName)) == null || !valueFilter.isValid(parameterValue)) continue;
            Parameter parameter = new Parameter(longestMatchingParameterName, parameterValue);
            parameters.add(parameter);
        }
        return parameters;
    }

    private Collection<String> getParameterNames() {
        return this.parameterNameToValueFilterMap.keySet();
    }

    private static class AcceptAllValuesFilter
    implements IValueFilter {
        private AcceptAllValuesFilter() {
        }

        @Override
        public boolean isValid(String value) {
            return true;
        }
    }

    private static class AcceptEventsWithPrefixesFilter
    implements IEventFilter {
        private Collection<String> eventPrefixes;

        public AcceptEventsWithPrefixesFilter(Collection<String> eventPrefixes) {
            this.eventPrefixes = eventPrefixes;
        }

        @Override
        public boolean accepts(String event) {
            for (String eventPrefix : this.eventPrefixes) {
                if (!event.startsWith(eventPrefix)) continue;
                return true;
            }
            return false;
        }
    }
}

