/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.rsync;

import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.concurrent.InactivityMonitor;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.CopyModeExisting;
import ch.systemsx.cisd.common.filesystem.IDirectoryImmutableCopier;
import ch.systemsx.cisd.common.filesystem.RemoteDirectoryCopyActivitySensor;
import ch.systemsx.cisd.common.filesystem.rsync.RsyncCopier;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.time.TimingParameters;
import java.io.File;
import org.apache.log4j.Logger;

public class RsyncBasedRecursiveHardLinkMaker
implements IDirectoryImmutableCopier {
    private static final String RSYNC_EXEC = "rsync";
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, RsyncBasedRecursiveHardLinkMaker.class);
    private static final int DEFAULT_MAX_ERRORS_TO_IGNORE = 3;
    private final TimingParameters timingParameters;
    private final int maxErrorsToIgnore;
    private final RsyncCopier rsyncCopier;

    public RsyncBasedRecursiveHardLinkMaker() {
        this(null, TimingParameters.getDefaultParameters(), 3);
    }

    public RsyncBasedRecursiveHardLinkMaker(File rsyncExecutableOrNull) {
        this(rsyncExecutableOrNull, TimingParameters.getDefaultParameters(), 3);
    }

    public RsyncBasedRecursiveHardLinkMaker(File rsyncExecutableOrNull, TimingParameters timingParameters, int maxErrorsToIgnore) {
        File rsyncExecutable;
        File file = rsyncExecutable = rsyncExecutableOrNull == null ? OSUtilities.findExecutable((String)RSYNC_EXEC) : rsyncExecutableOrNull;
        if (rsyncExecutable == null) {
            throw new ConfigurationFailureException("No rsync executable available.");
        }
        if (!rsyncExecutable.exists()) {
            throw new ConfigurationFailureException("rsync executable '" + rsyncExecutable + "' does not exist.");
        }
        this.rsyncCopier = new RsyncCopier(rsyncExecutable);
        this.timingParameters = timingParameters;
        this.maxErrorsToIgnore = maxErrorsToIgnore;
    }

    @Override
    public Status copyDirectoryImmutably(File sourceDirectory, File destinationDirectory, String targetNameOrNull) {
        return this.copyDirectoryImmutably(sourceDirectory, destinationDirectory, targetNameOrNull, CopyModeExisting.ERROR);
    }

    @Override
    public Status copyDirectoryImmutably(File sourceDirectory, File destinationDirectory, String targetNameOrNull, CopyModeExisting mode) {
        Status status;
        File target = new File(destinationDirectory, targetNameOrNull == null ? sourceDirectory.getName() : targetNameOrNull);
        if (mode == CopyModeExisting.ERROR && target.exists()) {
            return Status.createError("Target directory '" + target + "' already exists.");
        }
        InactivityMonitor.IInactivityObserver observer = new InactivityMonitor.IInactivityObserver(){

            @Override
            public void update(long inactiveSinceMillis, String descriptionOfInactivity) {
                machineLog.error((Object)(String.valueOf(descriptionOfInactivity) + ", terminating rsync"));
                RsyncBasedRecursiveHardLinkMaker.this.rsyncCopier.terminate();
            }
        };
        int counter = 0;
        while ((status = this.createHardLinks(sourceDirectory, destinationDirectory, targetNameOrNull, target, mode, observer)).isRetriableError() && counter++ <= this.timingParameters.getMaxRetriesOnFailure()) {
            if (!status.isError()) continue;
            ConcurrencyUtilities.sleep(this.timingParameters.getIntervalToWaitAfterFailureMillis());
        }
        return status;
    }

    private Status createHardLinks(File sourceDirectory, File destinationDirectory, String targetNameOrNull, File target, CopyModeExisting mode, InactivityMonitor.IInactivityObserver observer) {
        InactivityMonitor monitor = new InactivityMonitor(new RemoteDirectoryCopyActivitySensor(target, this.maxErrorsToIgnore), observer, this.timingParameters.getTimeoutMillis(), true);
        Status result = this.rsyncCopier.copyDirectoryImmutably(sourceDirectory, destinationDirectory, targetNameOrNull, mode);
        monitor.stop();
        return result;
    }

    public static interface ILastChangedChecker {
        public long lastChangedRelative(File var1, long var2);
    }
}

