/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class ConditionalNotificationLogger
extends Log4jSimpleLogger {
    private final Logger notificationLog;
    private final int ignoredErrorCountBeforeNotification;
    private int errorCount;
    private boolean notified;

    public ConditionalNotificationLogger(Logger log4jLogger, Logger notificationLog, int ignoredErrorCountBeforeNotification) {
        this(log4jLogger, null, notificationLog, ignoredErrorCountBeforeNotification);
        assert (ignoredErrorCountBeforeNotification > -1) : "Negative ignored error count before notification";
    }

    public ConditionalNotificationLogger(Logger log4jLogger, Priority log4jOverridePriorityOrNull, Logger notificationLog, int ignoredErrorCountBeforeNotification) {
        super(log4jLogger, log4jOverridePriorityOrNull);
        assert (notificationLog != null) : "Notification log not specified";
        assert (ignoredErrorCountBeforeNotification > -1) : "Negative ignored error count before notification";
        this.ignoredErrorCountBeforeNotification = ignoredErrorCountBeforeNotification;
        this.notificationLog = notificationLog;
    }

    public final void reset(String messageOrNull) {
        if (this.notified && this.notificationLog.isInfoEnabled() && messageOrNull != null) {
            this.notificationLog.info((Object)messageOrNull);
        }
        this.errorCount = 0;
        this.notified = false;
    }

    @Override
    public final void log(LogLevel level, String message) {
        if (LogLevel.ERROR.equals((Object)level)) {
            if (this.errorCount < this.ignoredErrorCountBeforeNotification) {
                super.log(level, message);
            } else if (!this.notified) {
                this.notificationLog.error((Object)message);
                this.notified = true;
            }
            ++this.errorCount;
        } else if (level != null) {
            super.log(level, message);
        }
    }
}

