/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.reflection;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.reflection.ClassFilterUtils;
import ch.systemsx.cisd.common.reflection.IClassFilter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static final Collection<Class<?>> gatherAllCastableClassesAndInterfacesFor(Object object) {
        assert (object != null) : "Unspecified object";
        LinkedHashSet classes = new LinkedHashSet();
        classes.add(object.getClass());
        classes.addAll(ClassUtils.getAllSuperclasses(object));
        classes.addAll(ClassUtils.getAllInterfaces(object));
        return classes;
    }

    private static final List<Class<?>> getAllInterfaces(Object object) {
        assert (object != null) : "Unspecified object";
        return org.apache.commons.lang.ClassUtils.getAllInterfaces(object.getClass());
    }

    private static final List<Class<?>> getAllSuperclasses(Object object) {
        assert (object != null) : "Unspecified object";
        return org.apache.commons.lang.ClassUtils.getAllSuperclasses(object.getClass());
    }

    public static void assertInterfaceWithOnlyVoidMethods(Class<?> clazz) {
        Method[] methods;
        assert (clazz != null) : "Unspecified class.";
        assert (clazz.isInterface()) : "Is not an interface: " + clazz.getName();
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?> returnType = method.getReturnType();
            if (!Void.TYPE.equals(returnType)) {
                throw new AssertionError((Object)("Method " + clazz.getName() + "." + method.getName() + " has non-void return type: " + returnType.getName()));
            }
            ++n2;
        }
    }

    public static final <C> boolean hasConstructor(Class<C> clazz, Object ... arguments) {
        try {
            return ClassUtils.tryGetConstructor(clazz, ClassUtils.getClasses(arguments)) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static final <T, C> T create(Class<T> superClazz, Class<C> clazz, Object ... arguments) {
        assert (superClazz != null) : "Missing super class";
        assert (clazz != null) : "Missing class name";
        try {
            assert (!clazz.isInterface()) : "Interface '" + clazz.getName() + "' can not be instanciated as it is an interface.";
            assert (superClazz.isAssignableFrom(clazz)) : "Class '" + clazz.getName() + "' does not implements/extends '" + superClazz.getName() + "'.";
            if (arguments == null || arguments.length == 0) {
                return ClassUtils.cast(clazz.newInstance());
            }
            Class<?>[] classes = ClassUtils.getClasses(arguments);
            Constructor<T> constructor = ClassUtils.tryGetConstructor(clazz, classes);
            if (constructor == null) {
                if (classes.length == 0) {
                    throw new IllegalArgumentException("No default constructor found for " + clazz);
                }
                throw new IllegalArgumentException("No constructor found for " + clazz + " with arguments of the following types: " + Arrays.asList(classes));
            }
            return constructor.newInstance(arguments);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)ex.getCause());
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        throw new IllegalArgumentException(String.format("Cannot instantiate class '%s' with given arguments '%s'.", clazz.getName(), Arrays.asList(arguments)));
    }

    public static final <T> T create(Class<T> superClazz, String className, Object ... arguments) {
        assert (superClazz != null) : "Missing super class";
        assert (className != null) : "Missing class name";
        try {
            return ClassUtils.create(superClazz, Class.forName(className), arguments);
        }
        catch (ClassNotFoundException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private static <T> T cast(Object newInstance) {
        return (T)newInstance;
    }

    private static final Class<?>[] getClasses(Object ... initargs) {
        Class[] classes = new Class[initargs.length];
        int i = 0;
        Object[] objectArray = initargs;
        int n = initargs.length;
        int n2 = 0;
        while (n2 < n) {
            Object initarg = objectArray[n2];
            classes[i++] = initarg.getClass();
            ++n2;
        }
        return classes;
    }

    private static final <T> Constructor<T> tryGetConstructor(Class<?> clazz, Class<?>[] classes) throws NoSuchMethodException {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> returned = null;
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            int len = parameterTypes.length;
            if (len == classes.length) {
                boolean match = true;
                int i = 0;
                while (i < len) {
                    Class<?> parameterType = parameterTypes[i];
                    Class<?> c = classes[i];
                    match &= parameterType.equals(c) || parameterType.isAssignableFrom(c);
                    ++i;
                }
                if (match) {
                    returned = constructor;
                }
            }
            ++n2;
        }
        return ClassUtils.toGenericType(returned);
    }

    private static <T> Constructor<T> toGenericType(Constructor<?> returned) {
        return returned;
    }

    public static final <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public static final Object invokeMethod(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException ex) {
            throw new CheckedExceptionTunnel((Exception)ex);
        }
        catch (InvocationTargetException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)ex.getCause());
        }
    }

    public static final boolean setFieldValue(Object object, String fieldName, Object newValue) {
        assert (object != null) : "Unspecified object.";
        Class<?> clazz = object.getClass();
        try {
            Field field = ClassUtils.tryGetDeclaredField(clazz, fieldName);
            if (field != null) {
                field.set(object, newValue);
                return true;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return false;
    }

    public static final Field tryGetDeclaredField(Class<?> c, String fieldName) {
        assert (c != null) : "Unspecified class.";
        assert (StringUtils.isNotBlank((String)fieldName)) : "Blank field name.";
        Field field = null;
        Class<?> clazz = c;
        do {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            clazz = clazz.getSuperclass();
        } while (field == null && clazz != null);
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }

    public static final <T> T[] createArray(Class<T> clazz, int len) {
        assert (clazz != null) : "Unspecified class.";
        assert (len > -1) : "Negative array length.";
        return (Object[])Array.newInstance(clazz, len);
    }

    public static final List<Class<?>> listClasses(String packageName, IClassFilter classFilterOrNull) {
        assert (packageName != null) : "Unspecified package name.";
        assert (!packageName.endsWith(".")) : "Remove the last dot from package name.";
        IClassFilter classFilter = classFilterOrNull == null ? ClassFilterUtils.createTrueClassFilter() : classFilterOrNull;
        List<URL> urls = ClassUtils.getUrls(packageName);
        HashMap classNamesByUrl = new HashMap();
        for (URL url : urls) {
            ArrayList<String> classNames = new ArrayList<String>();
            classNamesByUrl.put(url, classNames);
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                List<File> classFiles = ClassUtils.listClasses(ClassUtils.toPackageFile(url));
                for (File classFile : classFiles) {
                    String className = String.valueOf(packageName) + "." + FilenameUtils.getBaseName((String)classFile.getName());
                    classNames.add(className);
                }
                continue;
            }
            if ("jar".equals(protocol)) {
                classNames.addAll(ClassUtils.listEntries(ClassUtils.toJarFile(url), packageName));
                continue;
            }
            throw new UnsupportedOperationException(String.format("Protocol '%s' unsupported.", protocol));
        }
        ArrayList classes = new ArrayList();
        for (Map.Entry entry : classNamesByUrl.entrySet()) {
            List classNames = (List)entry.getValue();
            for (String className : classNames) {
                try {
                    Class clazz;
                    if (!classFilter.accept(className) || !classFilter.accept(clazz = org.apache.commons.lang.ClassUtils.getClass((String)className, (boolean)false))) continue;
                    classes.add(clazz);
                }
                catch (ClassNotFoundException ex) {
                    throw new CheckedExceptionTunnel((Exception)ex);
                }
                catch (Throwable ex) {
                    throw new IllegalArgumentException("Couldn't load class " + className + " from resource " + entry.getKey() + ": " + ex, ex);
                }
            }
        }
        return classes;
    }

    private static final List<File> listClasses(File packageFile) {
        return (List)FileUtils.listFiles((File)packageFile, (String[])new String[]{"class"}, (boolean)false);
    }

    private static final List<String> listEntries(JarFile jarFile, String packageName) {
        ArrayList<String> classNames = new ArrayList<String>();
        String packageNamePath = String.valueOf(packageName.replace('.', '/')) + "/";
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(packageNamePath) || name.lastIndexOf(47) != packageNamePath.length() - 1 || !name.endsWith(".class")) continue;
            String className = name.substring(packageName.length() + 1, name.length() - ".class".length());
            classNames.add(String.valueOf(packageName) + "." + className);
        }
        return classNames;
    }

    private static final List<URL> getUrls(String packageName) {
        try {
            ArrayList<URL> urls = Collections.list(Thread.currentThread().getContextClassLoader().getResources(packageName.replace(".", "/")));
            int size = urls.size();
            if (size == 0) {
                throw new IllegalArgumentException(String.format("Given package '%s' does not exist.", packageName));
            }
            return urls;
        }
        catch (IOException ex) {
            throw new CheckedExceptionTunnel((Exception)ex);
        }
    }

    private static final JarFile toJarFile(URL url) {
        assert (url != null) : "Unspecified URL.";
        assert ("jar".equals(url.getProtocol())) : "Wrong protocol.";
        try {
            return ((JarURLConnection)url.openConnection()).getJarFile();
        }
        catch (IOException ex) {
            throw new CheckedExceptionTunnel((Exception)ex);
        }
    }

    private static final File toPackageFile(URL url) {
        assert (url != null) : "Unspecified URL.";
        assert ("file".equals(url.getProtocol())) : "Wrong protocol.";
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new CheckedExceptionTunnel((Exception)ex);
        }
    }
}

