/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.resource;

import ch.systemsx.cisd.common.collection.NullIterator;
import ch.systemsx.cisd.common.resource.IReleasable;
import ch.systemsx.cisd.common.resource.Resources;
import java.util.Iterator;

public class ReleasableIterator<T>
implements Iterator<T>,
IReleasable {
    private Iterator<T> originalIterator;
    private Resources resources;

    public ReleasableIterator(Iterator<T> originalIterator) {
        if (originalIterator == null) {
            this.originalIterator = new NullIterator();
        } else {
            if (originalIterator instanceof IReleasable) {
                this.getResources().add(originalIterator);
            }
            this.originalIterator = originalIterator;
        }
    }

    @Override
    public boolean hasNext() {
        return this.originalIterator.hasNext();
    }

    @Override
    public T next() {
        if (this.originalIterator instanceof IReleasable) {
            return this.originalIterator.next();
        }
        T item = this.originalIterator.next();
        if (item instanceof IReleasable) {
            this.getResources().add(item);
        }
        return item;
    }

    @Override
    public void remove() {
        this.originalIterator.remove();
    }

    @Override
    public void release() {
        if (this.resources != null) {
            this.resources.release();
        }
    }

    private Resources getResources() {
        if (this.resources == null) {
            this.resources = new Resources();
        }
        return this.resources;
    }
}

