/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.dbmigration.TableColumnDefinition;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class TableDefinition
implements Iterable<TableColumnDefinition>,
Comparable<TableDefinition> {
    private final String tableName;
    private final Map<String, TableColumnDefinition> columns = new TreeMap<String, TableColumnDefinition>();

    public TableDefinition(String tableName) {
        this.tableName = tableName;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public void add(TableColumnDefinition columnDefinition) {
        this.columns.put(columnDefinition.getColumnName(), columnDefinition);
    }

    public void defineColumnAsPrimaryKey(String columnName) {
        this.getColumnDefinition(columnName).setPrimaryKey(true);
    }

    public TableColumnDefinition getColumnDefinition(String columnName) {
        TableColumnDefinition columnDefinition = this.columns.get(columnName);
        if (columnDefinition == null) {
            throw new IllegalArgumentException("No column '" + columnName + "' defined in table '" + this.tableName + "'.");
        }
        return columnDefinition;
    }

    @Override
    public Iterator<TableColumnDefinition> iterator() {
        return this.columns.values().iterator();
    }

    @Override
    public int compareTo(TableDefinition tableDefinition) {
        return this.tableName.compareTo(tableDefinition.getTableName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.tableName).append(":");
        for (TableColumnDefinition columnDefinition : this.columns.values()) {
            builder.append("\n  ").append(columnDefinition);
        }
        return builder.toString();
    }
}

