/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration.logging;

import ch.systemsx.cisd.common.logging.ControlFileBasedLogConfiguration;
import ch.systemsx.cisd.common.logging.event.BooleanEvent;
import ch.systemsx.cisd.common.logging.event.LongEvent;

public class DbConnectionLogConfiguration {
    static final String DB_CONNECTIONS_SEPARATE_LOG_FILE = "db-connections-separate-log-file";
    static final String DB_CONNECTIONS_PRINT_ACTIVE = "db-connections-print-active";
    static final String DB_CONNECTIONS_STACKTRACE = "db-connections-stacktrace";
    static final String DB_CONNECTIONS_DEBUG = "db-connections-debug";
    private static final DbConnectionLogConfiguration instance = new DbConnectionLogConfiguration();
    private ControlFileBasedLogConfiguration config;

    DbConnectionLogConfiguration() {
        this(new ControlFileBasedLogConfiguration());
    }

    DbConnectionLogConfiguration(ControlFileBasedLogConfiguration config) {
        this.config = config;
        this.config.addBooleanParameter(DB_CONNECTIONS_SEPARATE_LOG_FILE, false);
        this.config.addLongEvent(DB_CONNECTIONS_PRINT_ACTIVE);
        this.config.addBooleanEvent(DB_CONNECTIONS_STACKTRACE);
        this.config.addBooleanEvent(DB_CONNECTIONS_DEBUG);
    }

    public boolean isDbConnectionsSeparateLogFileEnabled() {
        return this.config.getBooleanParameterValue(DB_CONNECTIONS_SEPARATE_LOG_FILE);
    }

    public LongEvent getDbConnectionsPrintActiveEvent() {
        return this.config.getLongEvent(DB_CONNECTIONS_PRINT_ACTIVE);
    }

    public BooleanEvent getDbConnectionsStacktraceEvent() {
        return this.config.getBooleanEvent(DB_CONNECTIONS_STACKTRACE);
    }

    public BooleanEvent getDbConnectionsDebugEvent() {
        return this.config.getBooleanEvent(DB_CONNECTIONS_DEBUG);
    }

    public static DbConnectionLogConfiguration getInstance() {
        return instance;
    }
}

