/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration.postgresql;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.IMassUploader;
import ch.systemsx.cisd.dbmigration.MassUploadFileType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

public class PostgreSQLMassUploader
extends SimpleJdbcDaoSupport
implements IMassUploader {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PostgreSQLMassUploader.class);
    private final DataSource dataSourceOrNull;
    private final Connection connectionOrNull;
    private CopyManager copyManager;
    private final ISequenceNameMapper sequenceNameMapper;
    private final boolean sequenceUpdateNeeded;

    public PostgreSQLMassUploader(DataSource dataSource, ISequenceNameMapper sequenceNameMapper, boolean sequenceUpdateNeeded) throws SQLException {
        this.dataSourceOrNull = dataSource;
        this.connectionOrNull = null;
        this.sequenceNameMapper = sequenceNameMapper;
        this.sequenceUpdateNeeded = sequenceUpdateNeeded;
        this.setDataSource(dataSource);
    }

    public PostgreSQLMassUploader(Connection conn, ISequenceNameMapper sequenceNameMapper, boolean sequenceUpdateNeeded) throws SQLException {
        this.dataSourceOrNull = null;
        this.connectionOrNull = conn;
        this.sequenceNameMapper = sequenceNameMapper;
        this.sequenceUpdateNeeded = sequenceUpdateNeeded;
        this.setDataSource(this.dataSourceOrNull);
    }

    private final CopyManager getCopyManager() throws SQLException, NoSuchFieldException, IllegalAccessException {
        if (this.copyManager == null) {
            this.copyManager = this.getPGConnection().getCopyAPI();
        }
        return this.copyManager;
    }

    @Override
    public void performMassUpload(String tableName, String data) {
        this.performMassUpload(tableName, null, data);
    }

    @Override
    public void performMassUpload(String tableName, String[] columnNamesOrNull, String data) {
        StringBuilder copySql = new StringBuilder();
        copySql.append("COPY ");
        copySql.append(tableName);
        if (columnNamesOrNull != null) {
            copySql.append(" (");
            int i = 0;
            while (i < columnNamesOrNull.length) {
                copySql.append(columnNamesOrNull[i]);
                if (i < columnNamesOrNull.length - 1) {
                    copySql.append(',');
                }
                ++i;
            }
            copySql.append(')');
        }
        copySql.append(" FROM STDIN");
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        try {
            this.getCopyManager().copyIn(copySql.toString(), (InputStream)is);
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    @Override
    public final void performMassUpload(File[] massUploadFiles) {
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        File[] fileArray = massUploadFiles;
        int n = massUploadFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.performMassUpload(file, tables);
            ++n2;
        }
        if (this.sequenceUpdateNeeded) {
            boolean successful = true;
            for (String name : tables) {
                successful &= this.fixSequence(name);
            }
            if (!successful) {
                throw new EnvironmentFailureException("At least one sequence couldn't be updated.");
            }
        }
    }

    private final void performMassUpload(File massUploadFile, Set<String> tables) {
        try {
            String[] splitName = StringUtils.split((String)massUploadFile.getName(), (String)"=");
            assert (splitName.length == 2) : "Missing '=' in name of file '" + massUploadFile.getName() + "'.";
            String tableNameWithExtension = splitName[1];
            boolean csvFileType = MassUploadFileType.CSV.isOfType(tableNameWithExtension);
            boolean tsvFileType = MassUploadFileType.TSV.isOfType(tableNameWithExtension);
            assert (tsvFileType || csvFileType) : "Non of expected file types [" + MassUploadFileType.TSV.getFileType() + ", " + MassUploadFileType.CSV.getFileType() + "]: " + massUploadFile.getName();
            String tableName = tableNameWithExtension.substring(0, tableNameWithExtension.lastIndexOf(46));
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Perform mass upload of file '" + massUploadFile + "' to table '" + tableName + "'."));
            }
            FileInputStream is = new FileInputStream(massUploadFile);
            try {
                if (tsvFileType) {
                    this.getCopyManager().copyIn("COPY " + tableName + " FROM STDIN", (InputStream)is);
                } else {
                    this.getCopyManager().copyIn("COPY " + tableName + " FROM STDIN WITH CSV HEADER", (InputStream)is);
                }
                tables.add(tableName);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private final boolean fixSequence(String tableName) {
        String sequenceName = this.sequenceNameMapper.getSequencerForTable(tableName);
        if (sequenceName == null) {
            return true;
        }
        try {
            long newSequenceValue = this.getSimpleJdbcTemplate().queryForLong(String.format("select setval('%s', max(id)) from %s", sequenceName, tableName), new Object[0]);
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Updating sequence " + sequenceName + " for table " + tableName + " to value " + newSequenceValue));
            }
            return true;
        }
        catch (DataAccessException ex) {
            operationLog.error((Object)("Failed to set new value for sequence '" + sequenceName + "' of table '" + tableName + "'."), (Throwable)ex);
            return false;
        }
    }

    private final PGConnection getPGConnection() throws SQLException, NoSuchFieldException, IllegalAccessException {
        if (this.dataSourceOrNull == null) {
            return this.getPGConnection(this.connectionOrNull);
        }
        return this.getPGConnection(this.dataSourceOrNull.getConnection());
    }

    private final PGConnection getPGConnection(Connection conn) throws SQLException, NoSuchFieldException, IllegalAccessException {
        Field delegateField;
        if (conn instanceof PGConnection) {
            return (PGConnection)conn;
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Found connection of type '" + conn.getClass().getCanonicalName() + "'."));
        }
        if ((delegateField = PostgreSQLMassUploader.getField(conn.getClass(), "_conn")) == null) {
            throw new RuntimeException("No PostgreSQL driver found - cannot perform mass upload.");
        }
        delegateField.setAccessible(true);
        return this.getPGConnection((Connection)delegateField.get(conn));
    }

    private static final Field getField(Class<?> clazz, String fieldName) {
        assert (fieldName != null);
        if (clazz == null) {
            return null;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (fieldName.equals(field.getName())) {
                return field;
            }
            ++n2;
        }
        return PostgreSQLMassUploader.getField(clazz.getSuperclass(), fieldName);
    }
}

