/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class AbstractDelegatingDataSetInfoExtractor
implements IDataSetInfoExtractor {
    protected static final String DELEGATE_EXTRACTOR_CLASS_PROPERTY = "extractor";
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AbstractDelegatingDataSetInfoExtractor.class);
    private final IDataSetInfoExtractor delegate;

    protected AbstractDelegatingDataSetInfoExtractor(Properties properties) {
        this(AbstractDelegatingDataSetInfoExtractor.createDelegate(properties));
    }

    protected AbstractDelegatingDataSetInfoExtractor(IDataSetInfoExtractor delegate) {
        this.delegate = delegate;
    }

    @Private
    static IDataSetInfoExtractor createDelegate(Properties properties) {
        String delegateClass = PropertyUtils.getMandatoryProperty(properties, DELEGATE_EXTRACTOR_CLASS_PROPERTY);
        ExtendedProperties p = ExtendedProperties.getSubset(properties, "extractor.", true);
        return AbstractDelegatingDataSetInfoExtractor.createClass(IDataSetInfoExtractor.class, delegateClass, p);
    }

    private static final <T> T createClass(Class<T> superClazz, String className, Object ... argumentsOrNull) {
        try {
            return ClassUtils.create(superClazz, className, argumentsOrNull);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationFailureException(ex.getMessage());
        }
    }

    @Override
    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws UserFailureException, EnvironmentFailureException {
        return this.delegate.getDataSetInformation(incomingDataSetPath, openbisService);
    }
}

