/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;

public abstract class AbstractStorageProcessorTransaction
implements IStorageProcessorTransactional.IStorageProcessorTransaction {
    private static final long serialVersionUID = 1L;
    protected File incomingDataSetDirectory;
    protected File rootDirectory;
    protected transient DataSetInformation dataSetInformation;
    protected File storedDataDirectory;
    private TransactionState state = TransactionState.INITIAL;

    protected abstract File executeStoreData(ITypeExtractor var1, IMailClient var2);

    protected abstract void executeCommit();

    protected abstract IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable var1);

    public AbstractStorageProcessorTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
        this.dataSetInformation = parameters.getDataSetInformation();
        this.incomingDataSetDirectory = parameters.getIncomingDataSetDirectory();
        this.rootDirectory = parameters.getRootDir();
    }

    @Override
    public final void storeData(ITypeExtractor typeExtractor, IMailClient mailClient, File incomingDataSetOverride) {
        this.ensureState("storeData", TransactionState.INITIAL);
        this.incomingDataSetDirectory = incomingDataSetOverride;
        this.storedDataDirectory = this.executeStoreData(typeExtractor, mailClient);
        this.state = TransactionState.STORED;
    }

    @Override
    public final void commit() {
        this.ensureState("commit", TransactionState.STORED);
        this.executeCommit();
        this.state = TransactionState.COMMITTED;
    }

    @Override
    public final IStorageProcessorTransactional.UnstoreDataAction rollback(Throwable ex) {
        this.ensureState("rollback", TransactionState.INITIAL, TransactionState.STORED);
        IStorageProcessorTransactional.UnstoreDataAction result = this.executeRollback(ex);
        this.state = TransactionState.ROLLED_BACK;
        return result;
    }

    @Override
    public final File getStoredDataDirectory() {
        return this.storedDataDirectory;
    }

    @Override
    public final void setStoredDataDirectory(File dir) {
        this.storedDataDirectory = dir;
    }

    private void ensureState(String operation, TransactionState ... allowedStates) {
        TransactionState[] transactionStateArray = allowedStates;
        int n = allowedStates.length;
        int n2 = 0;
        while (n2 < n) {
            TransactionState allowedState = transactionStateArray[n2];
            if (this.state == allowedState) {
                return;
            }
            ++n2;
        }
        String error = String.format("Illegal transaction state: '%s' is not allowed while in state '%s'", new Object[]{operation, this.state});
        throw new IllegalStateException(error);
    }

    private static enum TransactionState {
        INITIAL,
        STORED,
        COMMITTED,
        ROLLED_BACK;

    }
}

