/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public class DataSetInfoFileNameDecorator {
    public static final String FILE_NAME_PROPERTY_NAME = "file-name-property-code";
    public static final String FILE_NAME_PROPERTY_NAME_DEFAULT_VALUE = "FILE_NAME";
    public static final String STRIP_EXTENSION = "strip-extension";
    public static final boolean STRIP_EXTENSION_DEFAULT_VALUE = false;
    private final String fileNamePropertyCode;
    private final boolean stripExtension;

    public DataSetInfoFileNameDecorator(Properties localProperties) {
        this.fileNamePropertyCode = PropertyUtils.getProperty(localProperties, FILE_NAME_PROPERTY_NAME, FILE_NAME_PROPERTY_NAME_DEFAULT_VALUE);
        this.stripExtension = PropertyUtils.getBoolean(localProperties, STRIP_EXTENSION, false);
    }

    public DataSetInformation enrich(DataSetInformation info, File incomingDataSetPath) {
        List<NewProperty> properties = info.getDataSetProperties();
        properties.add(this.createFileNameProperty(incomingDataSetPath));
        info.setDataSetProperties(properties);
        return info;
    }

    private NewProperty createFileNameProperty(File incomingDataSetPath) {
        String fileName = incomingDataSetPath.getName();
        if (this.stripExtension) {
            fileName = FilenameUtils.removeExtension((String)fileName);
        }
        return new NewProperty(this.fileNamePropertyCode, fileName);
    }
}

