/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.etlserver.DataSetRegistrationAlgorithm;
import ch.systemsx.cisd.etlserver.DataSetRegistrationHelper;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.util.Collections;
import java.util.List;

public class DataSetRegistrationAlgorithmRunner {
    private final DataSetRegistrationAlgorithm registrationAlgorithm;
    private final IDataSetRegistrationAlgorithmRunnerDelegate delegate;

    public DataSetRegistrationAlgorithmRunner(DataSetRegistrationHelper registrationHelper) {
        this(registrationHelper, (IDataSetRegistrationAlgorithmRunnerDelegate)new NoOpDelegate());
    }

    public DataSetRegistrationAlgorithmRunner(DataSetRegistrationHelper registrationHelper, IDataSetRegistrationAlgorithmRunnerDelegate delegate) {
        this(registrationHelper.getRegistrationAlgorithm(), delegate);
    }

    public DataSetRegistrationAlgorithmRunner(DataSetRegistrationAlgorithm registrationAlgorithm) {
        this(registrationAlgorithm, (IDataSetRegistrationAlgorithmRunnerDelegate)new NoOpDelegate());
    }

    public DataSetRegistrationAlgorithmRunner(DataSetRegistrationAlgorithm registrationAlgorithm, IDataSetRegistrationAlgorithmRunnerDelegate delegate) {
        this.registrationAlgorithm = registrationAlgorithm;
        this.delegate = delegate;
    }

    public List<DataSetInformation> runAlgorithm() {
        this.registrationAlgorithm.prepare();
        if (this.registrationAlgorithm.hasDataSetBeenIdentified()) {
            return this.registrationAlgorithm.registerDataSet();
        }
        this.delegate.didNotIdentifyDataSet();
        this.registrationAlgorithm.dealWithUnidentifiedDataSet();
        return Collections.emptyList();
    }

    public static interface IDataSetRegistrationAlgorithmRunnerDelegate {
        public void didNotIdentifyDataSet();
    }

    public static final class NoOpDelegate
    implements IDataSetRegistrationAlgorithmRunnerDelegate {
        @Override
        public void didNotIdentifyDataSet() {
        }
    }
}

