/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DatasetLocationUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import java.io.File;

public final class IdentifiedDataStrategy
implements IDataStoreStrategy {
    static final String DATA_SET_TYPE_PREFIX = "DataSetType_";
    static final String UNEXPECTED_PATHS_MSG_FORMAT = "There are unexpected paths '%s' in data store '%s'. I'll proceed anyway.";
    static final String STORAGE_LAYOUT_ERROR_MSG_PREFIX = "Serious error in data store layout: ";

    static final String createDataSetTypeDirectory(DataSetType dataSetType) {
        String dataSetTypeCode = dataSetType.getCode();
        assert (dataSetTypeCode != null) : "Data set type code can not be null.";
        return DATA_SET_TYPE_PREFIX + dataSetTypeCode;
    }

    @Private
    static File createBaseDirectory(File baseDir, DataSetInformation dataSetInfo) {
        String dataSetCode = dataSetInfo.getDataSetCode();
        String shareId = dataSetInfo.getShareId();
        String instanceUUID = dataSetInfo.getInstanceUUID();
        return DatasetLocationUtil.getDatasetLocationPath(baseDir, dataSetCode, shareId, instanceUUID);
    }

    @Override
    public final DataStoreStrategyKey getKey() {
        return DataStoreStrategyKey.IDENTIFIED;
    }

    @Override
    public final File getBaseDirectory(File storeRoot, DataSetInformation dataSetInfo, DataSetType dataSetType) {
        assert (storeRoot != null) : "Store root can not be null";
        assert (dataSetInfo != null) : "Data set information can not be null";
        File baseDirectory = IdentifiedDataStrategy.createBaseDirectory(storeRoot, dataSetInfo);
        if (baseDirectory.exists()) {
            throw EnvironmentFailureException.fromTemplate("Serious error in data store layout: Data set directory '%s' exists but has been designed to be unique.", baseDirectory.getPath());
        }
        if (baseDirectory.isFile()) {
            throw EnvironmentFailureException.fromTemplate("Serious error in data store layout: Base directory '%s' is a file.", baseDirectory);
        }
        return baseDirectory;
    }

    @Override
    public final File getTargetPath(File baseDirectory, File incomingDataSetPath) throws IllegalStateException {
        assert (baseDirectory != null) : "Base directory can not be null";
        assert (incomingDataSetPath != null) : "Incoming data set can not be null";
        File targetPath = new File(baseDirectory, incomingDataSetPath.getName());
        if (targetPath.exists()) {
            throw new IllegalStateException(String.format("Target path '%s' of identified incoming data set already exists (which it shouldn't), bailing out.", targetPath.getAbsolutePath()));
        }
        return targetPath;
    }
}

