/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.entityregistration;

import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.IDataSetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

class SampleAndDataSetRegistrationGlobalState {
    private final IDataSetHandler delegator;
    private final IEncapsulatedOpenBISService openbisService;
    private final SpaceIdentifier spaceIdentifierOrNull;
    private final SampleType sampleTypeOrNull;
    private final DataSetType dataSetTypeOrNull;
    private final SampleRegistrationMode sampleRegistrationMode;
    private final List<String> errorEmailRecipientsOrNull;
    private final String controlFilePattern;
    private final boolean alwaysCleanupAfterProcessing;
    private final boolean unmentionedSubfolderIsFailure;
    private final boolean useIsFinishedMarkerFile;
    private final Logger operationLog;
    private IMailClient mailClient;

    SampleAndDataSetRegistrationGlobalState(IDataSetHandler delegator, IEncapsulatedOpenBISService openbisService, SpaceIdentifier spaceIdentifierOrNull, SampleType sampleTypeOrNull, DataSetType dataSetTypeOrNull, SampleRegistrationMode sampleRegistrationMode, List<String> errorEmailRecipientsOrNull, String controlFilePattern, boolean alwaysCleanupAfterProcessing, boolean unmentionedSubfolderIsFailure, boolean useIsFinishedMarkerFile, Logger operationLog) {
        this.delegator = delegator;
        this.openbisService = openbisService;
        this.spaceIdentifierOrNull = spaceIdentifierOrNull;
        this.sampleTypeOrNull = sampleTypeOrNull;
        this.dataSetTypeOrNull = dataSetTypeOrNull;
        this.sampleRegistrationMode = sampleRegistrationMode;
        this.errorEmailRecipientsOrNull = errorEmailRecipientsOrNull;
        this.controlFilePattern = controlFilePattern;
        this.alwaysCleanupAfterProcessing = alwaysCleanupAfterProcessing;
        this.unmentionedSubfolderIsFailure = unmentionedSubfolderIsFailure;
        this.useIsFinishedMarkerFile = useIsFinishedMarkerFile;
        this.operationLog = operationLog;
    }

    public IDataSetHandler getDelegator() {
        return this.delegator;
    }

    public IEncapsulatedOpenBISService getOpenbisService() {
        return this.openbisService;
    }

    public boolean hasGlobalSpaceIdentifier() {
        return this.spaceIdentifierOrNull != null;
    }

    public SpaceIdentifier trySpaceIdentifier() {
        return this.spaceIdentifierOrNull;
    }

    public SampleType trySampleType() {
        return this.sampleTypeOrNull;
    }

    public DataSetType tryDataSetType() {
        return this.dataSetTypeOrNull;
    }

    public SampleRegistrationMode getSampleRegistrationMode() {
        return this.sampleRegistrationMode;
    }

    public Logger getOperationLog() {
        return this.operationLog;
    }

    public IMailClient getMailClient() {
        return this.mailClient;
    }

    public void initializeMailClient(IMailClient aMailClient) {
        this.mailClient = aMailClient;
    }

    public EMailAddress[] getErrorEmailRecipients() {
        ArrayList<EMailAddress> emailAddresses = new ArrayList<EMailAddress>();
        if (this.errorEmailRecipientsOrNull == null) {
            List<Person> admins = this.openbisService.listAdministrators();
            for (Person admin : admins) {
                emailAddresses.add(new EMailAddress(admin.getEmail()));
            }
        } else {
            for (String useridOrEmail : this.errorEmailRecipientsOrNull) {
                Person personOrNull = this.openbisService.tryPersonWithUserIdOrEmail(useridOrEmail);
                if (personOrNull == null) {
                    emailAddresses.add(new EMailAddress(useridOrEmail));
                    continue;
                }
                emailAddresses.add(new EMailAddress(personOrNull.getEmail()));
            }
        }
        return emailAddresses.toArray(new EMailAddress[emailAddresses.size()]);
    }

    public String getControlFilePattern() {
        return this.controlFilePattern;
    }

    public boolean alwaysCleanUpAfterProcessing() {
        return this.alwaysCleanupAfterProcessing;
    }

    public boolean areUnmentionedFoldersAnError() {
        return this.unmentionedSubfolderIsFailure;
    }

    public boolean isUseIsFinishedMarkerFile() {
        return this.useIsFinishedMarkerFile;
    }

    static enum SampleRegistrationMode {
        ACCEPT_ALL,
        IGNORE_EXISTING,
        REJECT_NONEXISTING;

    }
}

