/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.etlserver.IStoreRootDirectoryHolder;
import java.io.File;
import org.apache.log4j.Logger;

public class MarkerFileUtility {
    private final Logger operationLog;
    private final Logger notificationLog;
    private final IFileOperations fileOperations;
    private final File storeRootDirectory;

    public MarkerFileUtility(Logger operationLog, Logger notificationLog, IFileOperations fileOperations, IStoreRootDirectoryHolder storeRootDirectoryHolder) {
        this(operationLog, notificationLog, fileOperations, storeRootDirectoryHolder.getStoreRootDirectory());
    }

    public MarkerFileUtility(Logger operationLog, Logger notificationLog, IFileOperations fileOperations, File storeRootDirectory) {
        this.operationLog = operationLog;
        this.notificationLog = notificationLog;
        this.fileOperations = fileOperations;
        this.storeRootDirectory = storeRootDirectory;
    }

    public static File getMarkerFileFromIncoming(File incoming) {
        return new File(incoming.getParentFile(), ".MARKER_is_finished_" + incoming.getName());
    }

    public final File getIncomingDataSetPathFromMarker(File isFinishedPath) {
        String errorMsg;
        File incomingDataSetPath = MarkerFileUtility.getIncomingFromMarkerFile(isFinishedPath);
        if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)String.format("Getting incoming data set path '%s' from is-finished path '%s'", incomingDataSetPath, isFinishedPath));
        }
        if ((errorMsg = this.fileOperations.checkPathFullyAccessible(incomingDataSetPath, "incoming data set")) != null) {
            this.fileOperations.delete(isFinishedPath);
            throw EnvironmentFailureException.fromTemplate(String.format("Error moving path '%s' from '%s' to '%s': %s", incomingDataSetPath.getName(), incomingDataSetPath.getParent(), this.storeRootDirectory, errorMsg), new Object[0]);
        }
        return incomingDataSetPath;
    }

    static File getIncomingFromMarkerFile(File isFinishedPath) {
        File incomingDataSetPath = FileUtilities.removePrefixFromFileName(isFinishedPath, ".MARKER_is_finished_");
        return incomingDataSetPath;
    }

    public boolean deleteAndLogIsFinishedMarkerFile(File isFinishedFile) {
        if (!this.fileOperations.exists(isFinishedFile)) {
            return false;
        }
        boolean ok = this.fileOperations.delete(isFinishedFile);
        String absolutePath = isFinishedFile.getAbsolutePath();
        if (!ok) {
            this.notificationLog.error((Object)String.format("Removing marker file '%s' failed.", absolutePath));
        } else if (this.operationLog.isDebugEnabled()) {
            this.operationLog.debug((Object)String.format("Marker file '%s' has been removed.", absolutePath));
        }
        return ok;
    }
}

