/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.common.jython.JythonUtils;
import ch.systemsx.cisd.common.jython.PythonInterpreter;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationContext;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetRegistrationTransactionV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IJavaDataSetRegistrationDropboxV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.JythonTopLevelDataSetHandlerV2;
import org.apache.log4j.Logger;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyObject;

public class JythonAsJavaDataSetRegistrationDropboxV2Wrapper
implements IJavaDataSetRegistrationDropboxV2 {
    protected static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, JythonAsJavaDataSetRegistrationDropboxV2Wrapper.class);
    private PythonInterpreter interpreter;
    private Boolean retryDefined;

    public JythonAsJavaDataSetRegistrationDropboxV2Wrapper(PythonInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    @Override
    public void process(IDataSetRegistrationTransactionV2 transaction) {
        try {
            PyFunction function = JythonUtils.tryJythonFunction(this.interpreter, JythonTopLevelDataSetHandlerV2.JythonHookFunction.PROCESS_FUNCTION.name);
            if (function == null) {
                throw new IllegalStateException("Undefined process() function");
            }
            JythonUtils.invokeFunction(function, transaction);
        }
        catch (Exception e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }

    @Override
    public void postStorage(DataSetRegistrationContext context) {
        PyFunction function = JythonUtils.tryJythonFunction(this.getInterpreter(), JythonTopLevelDataSetHandlerV2.JythonHookFunction.POST_STORAGE_FUNCTION_NAME.name);
        if (function == null) {
            throw new NotImplementedException("postStorage is not implemented.");
        }
        JythonUtils.invokeFunction(function, context);
    }

    @Override
    public void preMetadataRegistration(DataSetRegistrationContext context) {
        PyFunction function = JythonUtils.tryJythonFunction(this.getInterpreter(), JythonTopLevelDataSetHandlerV2.JythonHookFunction.PRE_REGISTRATION_FUNCTION_NAME.name);
        if (function == null) {
            throw new NotImplementedException("preMetadataRegistration is not implemented.");
        }
        JythonUtils.invokeFunction(function, context);
    }

    @Override
    public void postMetadataRegistration(DataSetRegistrationContext context) {
        PyFunction function = JythonUtils.tryJythonFunction(this.getInterpreter(), JythonTopLevelDataSetHandlerV2.JythonHookFunction.POST_REGISTRATION_FUNCTION_NAME.name);
        if (function == null) {
            throw new NotImplementedException("postMetadataRegistration is not implemented.");
        }
        JythonUtils.invokeFunction(function, context);
    }

    @Override
    public void rollbackPreRegistration(DataSetRegistrationContext context, Throwable throwable) {
        PyFunction function = JythonUtils.tryJythonFunction(this.getInterpreter(), JythonTopLevelDataSetHandlerV2.JythonHookFunction.ROLLBACK_PRE_REGISTRATION_FUNCTION_NAME.name);
        if (function == null) {
            throw new NotImplementedException("rollbackPreRegistration is not implemented.");
        }
        JythonUtils.invokeFunction(function, context, throwable);
    }

    @Override
    public boolean isRetryFunctionDefined() {
        if (this.retryDefined == null) {
            PyFunction function = JythonUtils.tryJythonFunction(this.getInterpreter(), JythonTopLevelDataSetHandlerV2.JythonHookFunction.SHOULD_RETRY_PROCESS_FUNCTION_NAME.name);
            this.retryDefined = function == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return this.retryDefined;
    }

    @Override
    public boolean shouldRetryProcessing(DataSetRegistrationContext context, Exception problem) {
        if (!this.isRetryFunctionDefined()) {
            throw new NotImplementedException("shouldRetryProcessing is not implemented.");
        }
        PyFunction retryFunction = JythonUtils.tryJythonFunction(this.getInterpreter(), JythonTopLevelDataSetHandlerV2.JythonHookFunction.SHOULD_RETRY_PROCESS_FUNCTION_NAME.name);
        PyObject retryFunctionResult = null;
        try {
            retryFunctionResult = JythonUtils.invokeFunction(retryFunction, context, problem);
        }
        catch (Exception ex) {
            operationLog.error((Object)"The retry function has failed. Rolling back.", (Throwable)ex);
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        if (retryFunctionResult == null) {
            operationLog.error((Object)"The should_retry_processing function did not return anything. Will not retry.");
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)problem);
        }
        if (!(retryFunctionResult instanceof PyInteger)) {
            operationLog.error((Object)("The should_retry_processing function returned object of non-boolean type " + retryFunctionResult.getClass() + ". Will not retry."));
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)problem);
        }
        return ((PyInteger)retryFunctionResult).asInt() != 0;
    }

    private PythonInterpreter getInterpreter() {
        return this.interpreter;
    }
}

