/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v1;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.DssRegistrationLogDirectoryHelper;
import ch.systemsx.cisd.etlserver.DssRegistrationLogger;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistratorDelegate;
import ch.systemsx.cisd.etlserver.IdentifiedDataStrategy;
import ch.systemsx.cisd.etlserver.ThreadParameters;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationContext;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationPreStagingBehavior;
import ch.systemsx.cisd.etlserver.registrator.IEntityOperationService;
import ch.systemsx.cisd.etlserver.registrator.api.impl.SecondaryTransactionFailure;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IDataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.DataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.v1.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v1.ContainerDataSetStorageAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetStorageAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetStorageAlgorithmRunner;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetStorageRollbacker;
import ch.systemsx.cisd.etlserver.registrator.v1.DefaultEntityOperationService;
import ch.systemsx.cisd.etlserver.registrator.v1.IDataSetOnErrorActionDecision;
import ch.systemsx.cisd.etlserver.registrator.v1.IDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.etlserver.registrator.v1.IDataSetRegistrationService;
import ch.systemsx.cisd.etlserver.registrator.v1.IOmniscientEntityRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v1.LinkDataSetStorageAlgorithm;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DataSetRegistrationService<T extends DataSetInformation>
implements IDataSetRegistrationService,
DataSetStorageAlgorithmRunner.IPrePostRegistrationHook<T> {
    private final IOmniscientEntityRegistrator<T> registrator;
    private final AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorContext;
    private final IDelegatedActionWithResult<Boolean> globalCleanAfterwardsAction;
    private boolean cleanActionExecuted = false;
    private final IDataSetRegistrationDetailsFactory<T> dataSetRegistrationDetailsFactory;
    private final File stagingDirectory;
    private final File precommitDirectory;
    private final DataSetFile incomingDataSetFile;
    public final DssRegistrationLogger dssRegistrationLog;
    private final DssRegistrationLogDirectoryHelper dssRegistrationLogHelper;
    private final ITopLevelDataSetRegistratorDelegate delegate;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetRegistrationService.class);
    public final ArrayList<Throwable> encounteredErrors = new ArrayList();
    protected final ArrayList<DataSetRegistrationTransaction<T>> transactions;

    public DataSetRegistrationService(IOmniscientEntityRegistrator<T> registrator, DataSetFile incomingDataSetFile, IDataSetRegistrationDetailsFactory<T> registrationDetailsFactory, IDelegatedActionWithResult<Boolean> globalCleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate) {
        this.registrator = registrator;
        this.registratorContext = registrator.getRegistratorState();
        this.incomingDataSetFile = incomingDataSetFile;
        this.globalCleanAfterwardsAction = globalCleanAfterwardsAction;
        this.dataSetRegistrationDetailsFactory = registrationDetailsFactory;
        this.delegate = delegate;
        ThreadParameters threadParameters = this.registratorContext.getGlobalState().getThreadParameters();
        this.dssRegistrationLogHelper = new DssRegistrationLogDirectoryHelper(this.registratorContext.getGlobalState().getDssRegistrationLogDir());
        this.dssRegistrationLog = this.dssRegistrationLogHelper.createNewLogFile(incomingDataSetFile.getLogicalIncomingFile().getName(), threadParameters.getThreadName(), this.registratorContext.getFileOperations());
        this.stagingDirectory = this.registratorContext.getGlobalState().getStagingDir();
        this.precommitDirectory = this.registratorContext.getGlobalState().getPreCommitDir();
        this.transactions = new ArrayList();
    }

    public AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState getRegistratorContext() {
        return this.registratorContext;
    }

    @Override
    public IDataSetRegistrationTransaction transaction() {
        return this.transaction(this.incomingDataSetFile.getLogicalIncomingFile(), this.getDataSetRegistrationDetailsFactory());
    }

    @Override
    public IDataSetRegistrationTransaction transaction(File dataSetFile) {
        return this.transaction(dataSetFile, this.getDataSetRegistrationDetailsFactory());
    }

    public DataSetRegistrationTransaction<T> transaction(File dataSetFile, IDataSetRegistrationDetailsFactory<T> detailsFactory) {
        File workingDirectory = dataSetFile.getParentFile();
        DataSetRegistrationTransaction<T> transaction = this.createTransaction(this.registrator.getRollBackStackParentFolder(), workingDirectory, this.stagingDirectory, detailsFactory);
        this.transactions.add(transaction);
        return transaction;
    }

    protected DataSetRegistrationTransaction<T> createTransaction(File rollBackStackParentFolder, File workingDir, File stagingDir, IDataSetRegistrationDetailsFactory<T> registrationDetailsFactory) {
        return new DataSetRegistrationTransaction<T>(rollBackStackParentFolder, workingDir, stagingDir, this, registrationDetailsFactory);
    }

    public void commit() {
        this.commitExtantTransactions();
        boolean someTransactionsWereRolledback = false;
        for (DataSetRegistrationTransaction<T> transaction : this.transactions) {
            if (!transaction.isRolledback()) continue;
            someTransactionsWereRolledback = true;
            break;
        }
        this.logDssRegistrationResult();
        this.executeGlobalCleanAfterwardsAction(!this.didErrorsArise() && !someTransactionsWereRolledback);
    }

    protected void logDssRegistrationResult() {
        boolean stillExists = this.incomingDataSetFile.getRealIncomingFile().exists();
        if (!stillExists) {
            this.dssRegistrationLog.info(operationLog, "Incoming file [" + this.incomingDataSetFile.getRealIncomingFile() + "] was deleted outside of openBIS after processing started. The data had already been registered in the database.");
        }
        this.dssRegistrationLog.logDssRegistrationResult(this.encounteredErrors);
    }

    public void abort(Throwable t) {
        this.encounteredErrors.add(t);
        this.rollbackExtantTransactions();
        this.executeGlobalCleanAfterwardsAction(false);
    }

    public void cleanAfterRegistrationIfNecessary() {
        this.executeGlobalCleanAfterwardsAction(false);
    }

    protected void executeGlobalCleanAfterwardsAction(boolean success) {
        if (!this.cleanActionExecuted) {
            this.globalCleanAfterwardsAction.execute(success);
            this.cleanActionExecuted = true;
        }
    }

    @Override
    public File moveIncomingToError(String dataSetTypeCodeOrNull) {
        DataSetStorageRollbacker rollbacker = new DataSetStorageRollbacker(this.registratorContext, operationLog, IStorageProcessorTransactional.UnstoreDataAction.MOVE_TO_ERROR, this.incomingDataSetFile, dataSetTypeCodeOrNull, null);
        return rollbacker.doRollback(this.dssRegistrationLog);
    }

    public void didRollbackTransaction(DataSetRegistrationTransaction<T> transaction, DataSetStorageAlgorithmRunner<T> algorithm, Throwable ex, IDataSetOnErrorActionDecision.ErrorType errorType) {
        this.encounteredErrors.add(ex);
        boolean stopped = ex instanceof InterruptedExceptionUnchecked;
        if (!stopped) {
            IStorageProcessorTransactional.UnstoreDataAction action = this.registratorContext.getOnErrorActionDecision().computeUndoAction(errorType, ex);
            DataSetStorageRollbacker rollbacker = new DataSetStorageRollbacker(this.registratorContext, operationLog, action, this.incomingDataSetFile, null, ex, errorType);
            operationLog.info((Object)rollbacker.getErrorMessageForLog());
            rollbacker.doRollback(this.dssRegistrationLog);
        }
        this.registrator.didRollbackTransaction(this, transaction, algorithm, ex);
    }

    public void executePostCommit(DataSetRegistrationTransaction<T> transaction) {
        this.registrator.didCommitTransaction(this, transaction);
    }

    @Override
    public void executePreRegistration(DataSetRegistrationContext.IHolder registrationContextHolder) {
        this.registrator.didPreRegistration(this, registrationContextHolder);
    }

    @Override
    public void executePostRegistration(DataSetRegistrationContext.IHolder registrationContextHolder) {
        this.registrator.didPostRegistration(this, registrationContextHolder);
    }

    public void didEncounterSecondaryTransactionErrors(DataSetRegistrationTransaction<T> transaction, List<SecondaryTransactionFailure> secondaryErrors) {
        this.registrator.didEncounterSecondaryTransactionErrors(this, transaction, secondaryErrors);
    }

    public DataSetStorageAlgorithm<T> createStorageAlgorithm(File dataSetFile, DataSetRegistrationDetails<? extends T> dataSetDetails) {
        IDataStoreStrategy strategy = this.registratorContext.getDataStrategyStore().getDataStoreStrategy((DataSetInformation)dataSetDetails.getDataSetInformation(), dataSetFile);
        return this.createStorageAlgorithmWithStrategy(dataSetFile, dataSetDetails, strategy);
    }

    public DataSetStorageAlgorithm<T> createStorageAlgorithmWithIdentifiedStrategy(File dataSetFile, DataSetRegistrationDetails<? extends T> dataSetDetails) {
        IdentifiedDataStrategy strategy = new IdentifiedDataStrategy();
        return this.createStorageAlgorithmWithStrategy(dataSetFile, dataSetDetails, strategy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DataSetStorageAlgorithm<T> createStorageAlgorithmWithStrategy(File dataSetFile, DataSetRegistrationDetails<? extends T> dataSetDetails, IDataStoreStrategy strategy) {
        TopLevelDataSetRegistratorGlobalState globalContext = this.registratorContext.getGlobalState();
        T dataSetInformation = dataSetDetails.getDataSetInformation();
        ((DataSetInformation)dataSetInformation).setShareId(globalContext.getShareId());
        if (!((DataSetInformation)dataSetInformation).isNoFileDataSet()) return new DataSetStorageAlgorithm<T>(dataSetFile, dataSetDetails, strategy, this.registratorContext.getStorageProcessor(), globalContext.getDataSetValidator(), globalContext.getDssCode(), this.registratorContext.getFileOperations(), globalContext.getMailClient(), this.stagingDirectory, this.precommitDirectory);
        if (dataSetFile != null) {
            throw new IllegalArgumentException("A data set can contain either files or other data sets or link to an external system dataset. The data set specification is invalid: " + dataSetInformation);
        }
        if (((DataSetInformation)dataSetInformation).isContainerDataSet()) {
            return new ContainerDataSetStorageAlgorithm<T>(dataSetFile, dataSetDetails, strategy, this.registratorContext.getStorageProcessor(), globalContext.getDataSetValidator(), globalContext.getDssCode(), this.registratorContext.getFileOperations(), globalContext.getMailClient(), this.stagingDirectory, this.precommitDirectory);
        }
        if (!((DataSetInformation)dataSetInformation).isLinkDataSet()) throw new IllegalStateException("No-file dataset has to be either a container dataset or a link dataset");
        return new LinkDataSetStorageAlgorithm<T>(dataSetFile, dataSetDetails, strategy, this.registratorContext.getStorageProcessor(), globalContext.getDataSetValidator(), globalContext.getDssCode(), this.registratorContext.getFileOperations(), globalContext.getMailClient(), this.stagingDirectory, this.precommitDirectory);
    }

    public IEntityOperationService<T> getEntityRegistrationService() {
        return new DefaultEntityOperationService<T>(this.registrator, this.delegate);
    }

    public boolean didErrorsArise() {
        return !this.encounteredErrors.isEmpty();
    }

    public List<Throwable> getEncounteredErrors() {
        return this.encounteredErrors;
    }

    public void registerNonFatalError(Throwable t) {
        this.encounteredErrors.add(t);
    }

    public IDataSetRegistrationDetailsFactory<T> getDataSetRegistrationDetailsFactory() {
        return this.dataSetRegistrationDetailsFactory;
    }

    private void commitExtantTransactions() {
        for (DataSetRegistrationTransaction<T> transaction : this.transactions) {
            if (transaction.isCommittedOrRolledback()) continue;
            transaction.commit();
        }
    }

    private void rollbackExtantTransactions() {
        for (DataSetRegistrationTransaction<T> transaction : this.transactions) {
            if (transaction.isCommittedOrRolledback()) continue;
            transaction.rollback();
        }
    }

    protected IOmniscientEntityRegistrator<T> getRegistrator() {
        return this.registrator;
    }

    public DssRegistrationLogger getDssRegistrationLog() {
        return this.dssRegistrationLog;
    }

    public DataSetFile getIncomingDataSetFile() {
        return this.incomingDataSetFile;
    }

    public boolean shouldUsePrestaging() {
        return this.delegate.getPrestagingBehavior() == DataSetRegistrationPreStagingBehavior.USE_PRESTAGING;
    }
}

