/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v1;

import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.DssRegistrationLogger;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationContext;
import ch.systemsx.cisd.etlserver.registrator.IRollbackStack;
import ch.systemsx.cisd.etlserver.registrator.ITransactionalCommand;
import ch.systemsx.cisd.etlserver.registrator.IncomingFileDeletedBeforeRegistrationException;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.DataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.monitor.DssRegistrationHealthMonitor;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetStorageAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.v1.IDataSetOnErrorActionDecision;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetRegistrationInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.EntityOperationsState;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class DataSetStorageAlgorithmRunner<T extends DataSetInformation> {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetStorageAlgorithmRunner.class);
    public static final String DATA_SET_REGISTRATION_FAILURE_TEMPLATE = "Registration of data set '%s' failed.";
    public static final String DATA_SET_STORAGE_FAILURE_TEMPLATE = "Storing data set '%s' failed.";
    public static final String SUCCESSFULLY_REGISTERED = "Successfully registered data set: [";
    private final ArrayList<DataSetStorageAlgorithm<T>> dataSetStorageAlgorithms;
    private final IDataSetInApplicationServerRegistrator<T> applicationServerRegistrator;
    private final IRollbackDelegate<T> rollbackDelegate;
    private final IRollbackStack rollbackStack;
    private final DataSetRegistrationContext.IHolder registrationContextHolder;
    private final IPrePostRegistrationHook<T> postPreRegistrationHooks;
    private final DssRegistrationLogger dssRegistrationLog;
    private final IEncapsulatedOpenBISService openBISService;
    private final DataSetFile incomingDataSetFile;

    public DataSetStorageAlgorithmRunner(List<DataSetStorageAlgorithm<T>> dataSetStorageAlgorithms, DataSetRegistrationTransaction<T> transaction, IRollbackStack rollbackStack, DssRegistrationLogger dssRegistrationLog, IEncapsulatedOpenBISService openBISService, IPrePostRegistrationHook<T> postPreRegistrationHooks, TopLevelDataSetRegistratorGlobalState globalState) {
        this.dataSetStorageAlgorithms = new ArrayList<DataSetStorageAlgorithm<T>>(dataSetStorageAlgorithms);
        this.rollbackDelegate = transaction;
        this.applicationServerRegistrator = transaction;
        this.registrationContextHolder = transaction;
        this.rollbackStack = rollbackStack;
        this.dssRegistrationLog = dssRegistrationLog;
        this.openBISService = openBISService;
        this.postPreRegistrationHooks = postPreRegistrationHooks;
        this.incomingDataSetFile = transaction.getIncomingDataSetFile();
    }

    public final void prepare() {
        StringBuilder registrationSummary = new StringBuilder();
        registrationSummary.append("Prepared registration of ");
        registrationSummary.append(this.dataSetStorageAlgorithms.size());
        if (1 == this.dataSetStorageAlgorithms.size()) {
            registrationSummary.append(" data set:");
        } else {
            registrationSummary.append(" data sets:");
        }
        registrationSummary.append("\n\t");
        for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
            IStorageProcessorTransactional.IStorageProcessorTransaction transaction1 = storageAlgorithm.prepare(this.rollbackStack);
            StorageProcessorTransactionCommand command = new StorageProcessorTransactionCommand(transaction1);
            this.rollbackStack.pushAndExecuteCommand(command);
            registrationSummary.append(((DataSetInformation)storageAlgorithm.getDataSetInformation()).getDataSetCode());
            registrationSummary.append(",");
        }
        registrationSummary.deleteCharAt(registrationSummary.length() - 1);
        this.dssRegistrationLog.logTruncatingIfNecessary(registrationSummary.toString());
    }

    private boolean confirmStorageInApplicationServer() {
        try {
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                String dataSetCode = ((DataSetInformation)storageAlgorithm.getDataSetInformation()).getDataSetCode();
                this.openBISService.setStorageConfirmed(dataSetCode);
            }
            this.dssRegistrationLog.info(operationLog, "Storage has been confirmed in openBIS Application Server.");
        }
        catch (Exception ex) {
            this.dssRegistrationLog.error(operationLog, "Error during storage confirmation", ex);
            return false;
        }
        return true;
    }

    private void logPreCommitMessage() {
        if (this.dataSetStorageAlgorithms.size() > 0) {
            DataSetStorageAlgorithm<T> anAlgorithm = this.dataSetStorageAlgorithms.get(0);
            File precommitDirectory = anAlgorithm.getPreCommitDirectory();
            this.dssRegistrationLog.info(operationLog, "Data has been moved to the pre-commit directory: " + precommitDirectory.getAbsolutePath());
        } else {
            this.dssRegistrationLog.info(operationLog, "In pre-commit state; no data needed to be moved.");
        }
    }

    private boolean executePreRegistrationHooks() {
        try {
            this.postPreRegistrationHooks.executePreRegistration(this.registrationContextHolder);
        }
        catch (Throwable throwable) {
            this.dssRegistrationLog.error(operationLog, "Error in execution of pre registration hooks", throwable);
            this.rollbackDuringPreRegistration(throwable);
            return false;
        }
        return true;
    }

    public boolean prepareAndRunStorageAlgorithms() {
        this.prepare();
        if (!this.preCommitStorageAlgorithms()) {
            return false;
        }
        if (!this.executePreRegistrationHooks()) {
            return false;
        }
        ArrayList<DataSetRegistrationInformation<T>> registrationData = this.tryPrepareRegistrationData();
        TechId registrationId = new TechId(this.openBISService.drawANewUniqueID());
        this.logMetadataRegistration(registrationId);
        if (registrationData == null) {
            return false;
        }
        this.waitUntilApplicationIsReady();
        if (!this.registerDataSetsInApplicationServer(registrationId, registrationData)) {
            return false;
        }
        this.postRegistration();
        if (!this.commitAndStore()) {
            return false;
        }
        return this.cleanPrecommitAndConfirmStorage();
    }

    public void postRegistration() {
        this.executeJythonScriptsForPostRegistration();
        this.waitUntilApplicationIsReady();
    }

    private void logMetadataRegistration(TechId registrationId) {
        this.dssRegistrationLog.info(operationLog, "About to register metadata with AS: registrationId(" + registrationId.toString() + ")");
    }

    public boolean commitAndStore() {
        if (!this.commitStorageProcessors()) {
            return false;
        }
        if (!this.storeCommitedDatasets()) {
            return false;
        }
        this.waitUntilApplicationIsReady();
        return true;
    }

    private void waitTheRetryPeriod() {
        ConcurrencyUtilities.sleep(60000L);
    }

    private void waitUntilApplicationIsReady() {
        while (DssRegistrationHealthMonitor.getInstance().checkHealthState(this.incomingDataSetFile.getRealIncomingFile().getParentFile()).isUnavailable()) {
            this.waitTheRetryPeriod();
        }
    }

    public boolean cleanPrecommitAndConfirmStorage() {
        this.cleanPrecommitDirectory();
        this.confirmStorageInApplicationServer();
        return true;
    }

    private ArrayList<DataSetRegistrationInformation<T>> tryPrepareRegistrationData() {
        try {
            ArrayList<DataSetRegistrationInformation<T>> registrationData = new ArrayList<DataSetRegistrationInformation<T>>();
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                registrationData.add(new DataSetRegistrationInformation<T>(storageAlgorithm.getDataSetInformation(), storageAlgorithm.createExternalData()));
            }
            return registrationData;
        }
        catch (Throwable t) {
            this.rollbackDuringMetadataRegistration(t);
            return null;
        }
    }

    private void rollbackDuringStorageProcessorRun(Throwable ex) {
        operationLog.error((Object)"Failed to run storage processor");
        this.rollbackStorageProcessors(ex);
        this.rollbackDelegate.didRollbackStorageAlgorithmRunner(this, ex, IDataSetOnErrorActionDecision.ErrorType.STORAGE_PROCESSOR_ERROR);
    }

    private void rollbackDuringPreRegistration(Throwable ex) {
        operationLog.error((Object)"Failed to pre-register", ex);
        this.rollbackStorageProcessors(ex);
        this.rollbackDelegate.didRollbackStorageAlgorithmRunner(this, ex, IDataSetOnErrorActionDecision.ErrorType.PRE_REGISTRATION_ERROR);
    }

    private void rollbackDuringMetadataRegistration(Throwable ex) {
        if (!(ex instanceof IncomingFileDeletedBeforeRegistrationException)) {
            operationLog.error((Object)"Failed to register metadata", ex);
        }
        this.rollbackStorageProcessors(ex);
        this.rollbackDelegate.didRollbackStorageAlgorithmRunner(this, ex, IDataSetOnErrorActionDecision.ErrorType.OPENBIS_REGISTRATION_FAILURE);
    }

    private void rollbackAfterStorageProcessorAndMetadataRegistration(Throwable ex) {
        operationLog.error((Object)"Failed to complete transaction", ex);
        this.rollbackStorageProcessors(ex);
        this.rollbackDelegate.didRollbackStorageAlgorithmRunner(this, ex, IDataSetOnErrorActionDecision.ErrorType.POST_REGISTRATION_ERROR);
    }

    private boolean storeCommitedDatasets() {
        try {
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                storageAlgorithm.moveToTheStore();
            }
            this.logSuccessfulRegistration();
            this.dssRegistrationLog.info(operationLog, "Data has been moved to the final store.");
        }
        catch (Throwable throwable) {
            this.dssRegistrationLog.error(operationLog, "Error while storing committed datasets", throwable);
            return false;
        }
        return true;
    }

    private void cleanPrecommitDirectory() {
        try {
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                storageAlgorithm.cleanPrecommitDirectory();
            }
        }
        catch (Throwable throwable) {
            operationLog.warn((Object)"Failed to delete precommit directory", throwable);
        }
    }

    private boolean commitStorageProcessors() {
        try {
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                storageAlgorithm.commitStorageProcessor();
            }
            this.dssRegistrationLog.info(operationLog, "Storage processors have committed.");
        }
        catch (Throwable throwable) {
            this.dssRegistrationLog.error(operationLog, "Error while committing storage processors", throwable);
            this.rollbackAfterStorageProcessorAndMetadataRegistration(throwable);
            return false;
        }
        return true;
    }

    private boolean registerDataSetsInApplicationServer(TechId registrationId, List<DataSetRegistrationInformation<T>> registrationData) {
        boolean result = this.registerData(registrationId, registrationData);
        if (result) {
            this.dssRegistrationLog.info(operationLog, "Data has been registered with the openBIS Application Server.");
        }
        return result;
    }

    private boolean registerData(TechId registrationId, List<DataSetRegistrationInformation<T>> registrationData) {
        try {
            this.applicationServerRegistrator.registerDataSetsInApplicationServer(registrationId, registrationData);
        }
        catch (Throwable throwable) {
            this.dssRegistrationLog.error(operationLog, "Error in registrating data in application server", throwable);
            this.rollbackDuringMetadataRegistration(throwable);
            return false;
        }
        return true;
    }

    private boolean preCommitStorageAlgorithms() {
        try {
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                storageAlgorithm.preCommit();
            }
        }
        catch (Throwable throwable) {
            this.rollbackDuringStorageProcessorRun(throwable);
            return false;
        }
        this.logPreCommitMessage();
        return true;
    }

    private void executeJythonScriptsForPostRegistration() {
        try {
            this.postPreRegistrationHooks.executePostRegistration(this.registrationContextHolder);
        }
        catch (Throwable throwable) {
            this.dssRegistrationLog.warn(operationLog, "Post-registration action failed", throwable);
        }
    }

    private void rollbackStorageProcessors(Throwable ex) {
        if (!(ex instanceof IncomingFileDeletedBeforeRegistrationException)) {
            operationLog.error((Object)("Error during dataset registration: " + ExceptionUtils.getRootCauseMessage((Throwable)ex)), ex);
        }
        if (ex instanceof Error && !(ex instanceof AssertionError)) {
            return;
        }
        int i = this.dataSetStorageAlgorithms.size() - 1;
        while (i >= 0) {
            DataSetStorageAlgorithm<T> storageAlgorithm = this.dataSetStorageAlgorithms.get(i);
            storageAlgorithm.transitionToRolledbackState(ex);
            storageAlgorithm.transitionToUndoneState();
            --i;
        }
    }

    private void logSuccessfulRegistration() {
        if (this.getOperationLog().isInfoEnabled()) {
            String msg = this.getSuccessRegistrationMessage();
            this.getOperationLog().info((Object)msg);
        }
    }

    private final String getSuccessRegistrationMessage() {
        StringBuilder buffer = new StringBuilder();
        for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
            buffer.append(SUCCESSFULLY_REGISTERED);
            buffer.append(storageAlgorithm.getSuccessRegistrationMessage());
            buffer.append(']');
        }
        return buffer.toString();
    }

    public List<DataSetStorageAlgorithm<T>> getDataSetStorageAlgorithms() {
        return this.dataSetStorageAlgorithms;
    }

    public IRollbackStack getRollbackStack() {
        return this.rollbackStack;
    }

    public DssRegistrationLogger getDssRegistrationLogger() {
        return this.dssRegistrationLog;
    }

    private Logger getOperationLog() {
        return operationLog;
    }

    public DataSetFile getIncomingDataSetFile() {
        return this.incomingDataSetFile;
    }

    public DataSetRegistrationContext getRegistrationContext() {
        return this.registrationContextHolder.getRegistrationContext();
    }

    public static interface IDataSetInApplicationServerRegistrator<T extends DataSetInformation> {
        public void registerDataSetsInApplicationServer(TechId var1, List<DataSetRegistrationInformation<T>> var2) throws Throwable;

        public EntityOperationsState didEntityOperationsSucceeded(TechId var1);
    }

    public static interface IPrePostRegistrationHook<T extends DataSetInformation> {
        public void executePreRegistration(DataSetRegistrationContext.IHolder var1);

        public void executePostRegistration(DataSetRegistrationContext.IHolder var1);
    }

    public static interface IRollbackDelegate<T extends DataSetInformation> {
        public void didRollbackStorageAlgorithmRunner(DataSetStorageAlgorithmRunner<T> var1, Throwable var2, IDataSetOnErrorActionDecision.ErrorType var3);
    }

    public static class StorageProcessorTransactionCommand
    implements ITransactionalCommand {
        private static final long serialVersionUID = 1L;
        final IStorageProcessorTransactional.IStorageProcessorTransaction transaction;

        StorageProcessorTransactionCommand(IStorageProcessorTransactional.IStorageProcessorTransaction transaction) {
            this.transaction = transaction;
        }

        @Override
        public void execute() {
        }

        @Override
        public void rollback() {
            this.transaction.rollback(null);
        }
    }
}

