/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v1;

import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.jython.PythonInterpreter;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistratorDelegate;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.api.impl.SecondaryTransactionFailure;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IJavaDataSetRegistrationDropboxV1;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.DataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IJavaDataSetRegistrationDropboxV2;
import ch.systemsx.cisd.etlserver.registrator.api.v2.JythonAsJavaDataSetRegistrationDropboxV2Wrapper;
import ch.systemsx.cisd.etlserver.registrator.monitor.DssRegistrationHealthMonitor;
import ch.systemsx.cisd.etlserver.registrator.v1.AbstractDataSetRegistrationDetailsFactory;
import ch.systemsx.cisd.etlserver.registrator.v1.AbstractOmniscientTopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.registrator.v1.AbstractProgrammableTopLevelDataSetHandler;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetRegistrationService;
import ch.systemsx.cisd.etlserver.registrator.v1.DataSetStorageAlgorithmRunner;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.util.List;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyFunction;
import org.python.core.PyObject;

public class JythonTopLevelDataSetHandler<T extends DataSetInformation>
extends AbstractProgrammableTopLevelDataSetHandler<T> {
    protected static final String FACTORY_VARIABLE_NAME = "factory";
    protected static final String SERVICE_VARIABLE_NAME = "service";
    protected static final String STATE_VARIABLE_NAME = "state";
    protected static final String INCOMING_DATA_SET_VARIABLE_NAME = "incoming";
    protected static final String TRANSACTION_VARIABLE_NAME = "transaction";
    public static final String SCRIPT_PATH_KEY = "script-path";
    private IJavaDataSetRegistrationDropboxV1<T> v1 = new IJavaDataSetRegistrationDropboxV1<T>(){

        @Override
        public void rollbackTransaction(DataSetRegistrationService<T> service, DataSetRegistrationTransaction<T> transaction, DataSetStorageAlgorithmRunner<T> algorithmRunner, Throwable ex) {
            PythonInterpreter interpreter = JythonTopLevelDataSetHandler.this.getInterpreterFromService(service);
            PyFunction function = JythonTopLevelDataSetHandler.this.tryJythonFunction(interpreter, JythonHookFunction.ROLLBACK_TRANSACTION_FUNCTION_NAME);
            if (function == null) {
                throw new NotImplementedException();
            }
            JythonTopLevelDataSetHandler.this.invokeRollbackTransactionFunction(function, service, transaction, algorithmRunner, ex);
        }

        @Override
        public void rollbackService(DataSetRegistrationService<T> service, Throwable ex) {
            PythonInterpreter interpreter = JythonTopLevelDataSetHandler.this.getInterpreterFromService(service);
            PyFunction function = JythonTopLevelDataSetHandler.this.tryJythonFunction(interpreter, JythonHookFunction.ROLLBACK_SERVICE_FUNCTION_NAME);
            if (function == null) {
                throw new NotImplementedException();
            }
            JythonTopLevelDataSetHandler.this.invokeRollbackServiceFunction(function, service, ex);
        }

        @Override
        public void commitTransaction(DataSetRegistrationService<T> service, DataSetRegistrationTransaction<T> transaction) {
            PythonInterpreter interpreter = JythonTopLevelDataSetHandler.this.getInterpreterFromService(service);
            PyFunction function = JythonTopLevelDataSetHandler.this.tryJythonFunction(interpreter, JythonHookFunction.COMMIT_TRANSACTION_FUNCTION_NAME);
            if (function == null) {
                throw new NotImplementedException();
            }
            JythonTopLevelDataSetHandler.this.invokeServiceTransactionFunction(function, service, transaction);
        }

        @Override
        public void didEncounterSecondaryTransactionErrors(DataSetRegistrationService<T> service, DataSetRegistrationTransaction<T> transaction, List<SecondaryTransactionFailure> secondaryErrors) {
            PythonInterpreter interpreter = JythonTopLevelDataSetHandler.this.getInterpreterFromService(service);
            PyFunction function = JythonTopLevelDataSetHandler.this.tryJythonFunction(interpreter, JythonHookFunction.DID_ENCOUNTER_SECONDARY_TRANSACTION_ERRORS_FUNCTION_NAME);
            if (function == null) {
                throw new NotImplementedException();
            }
            JythonTopLevelDataSetHandler.this.invokeDidEncounterSecondaryTransactionErrorsFunction(function, service, transaction, secondaryErrors);
        }
    };
    protected final File scriptFile;

    public JythonTopLevelDataSetHandler(TopLevelDataSetRegistratorGlobalState globalState) {
        super(globalState);
        String path = PropertyUtils.getMandatoryProperty(globalState.getThreadParameters().getThreadProperties(), SCRIPT_PATH_KEY);
        this.scriptFile = new File(path);
        if (!this.scriptFile.isFile()) {
            throw ConfigurationFailureException.fromTemplate("Script file '%s' does not exist!", path);
        }
        DssRegistrationHealthMonitor.getInstance(globalState.getOpenBisService(), globalState.getRecoveryStateDir());
    }

    @Override
    public void handleDataSet(DataSetFile dataSetFile, DataSetRegistrationService<T> genericService) throws Throwable {
        String scriptString = FileUtilities.loadToString(this.scriptFile);
        JythonDataSetRegistrationService service = (JythonDataSetRegistrationService)genericService;
        this.waitUntilApplicationIsReady(dataSetFile);
        this.executeJythonScript(dataSetFile, scriptString, service);
    }

    protected void executeJythonScript(DataSetFile dataSetFile, String scriptString, JythonDataSetRegistrationService<T> service) {
        PythonInterpreter interpreter = ((JythonDataSetRegistrationService)service).interpreter;
        this.configureEvaluator(dataSetFile.getLogicalIncomingFile(), service, interpreter);
        interpreter.exec(scriptString, this.scriptFile.getPath());
        this.verifyEvaluatorHookFunctions(interpreter);
    }

    protected void verifyEvaluatorHookFunctions(PythonInterpreter interpreter) {
        JythonHookFunction[] jythonHookFunctionArray = JythonHookFunction.values();
        int n = jythonHookFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            JythonHookFunction function = jythonHookFunctionArray[n2];
            PyFunction py = this.tryJythonFunction(interpreter, function);
            if (py != null) {
                if (py.func_code instanceof PyBaseCode) {
                    int co_argcount = ((PyBaseCode)py.func_code).co_argcount;
                    if (co_argcount != function.argCount) {
                        throw new IllegalArgumentException(String.format("The function %s in %s has wrong number of arguments(%s instead of %s).", function.name, this.scriptFile.getName(), co_argcount, function.argCount));
                    }
                } else {
                    System.err.println("Possibly incorrect python code. Can't verify script correctness.");
                }
            }
            ++n2;
        }
    }

    private void configureEvaluator(File dataSetFile, JythonDataSetRegistrationService<T> service, PythonInterpreter interpreter) {
        interpreter.set(SERVICE_VARIABLE_NAME, service);
        interpreter.set(INCOMING_DATA_SET_VARIABLE_NAME, dataSetFile);
        interpreter.set(STATE_VARIABLE_NAME, this.getGlobalState());
        interpreter.set(FACTORY_VARIABLE_NAME, service.getDataSetRegistrationDetailsFactory());
        interpreter.set(TRANSACTION_VARIABLE_NAME, Py.None);
    }

    @Override
    protected DataSetRegistrationService<T> createDataSetRegistrationService(DataSetFile incomingDataSetFile, DataSetInformation callerDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate) {
        return this.createJythonDataSetRegistrationService(incomingDataSetFile, callerDataSetInformationOrNull, cleanAfterwardsAction, delegate, PythonInterpreter.createIsolatedPythonInterpreter(), this.getGlobalState());
    }

    protected DataSetRegistrationService<T> createJythonDataSetRegistrationService(DataSetFile incomingDataSetFile, DataSetInformation userProvidedDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> cleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate, PythonInterpreter pythonInterpreter, TopLevelDataSetRegistratorGlobalState globalState) {
        return new JythonDataSetRegistrationService(this, incomingDataSetFile, userProvidedDataSetInformationOrNull, cleanAfterwardsAction, delegate, pythonInterpreter, globalState);
    }

    @Override
    protected void rollback(DataSetRegistrationService<T> service, Throwable throwable) {
        try {
            this.v1.rollbackService(service, throwable);
        }
        catch (NotImplementedException notImplementedException) {}
        super.rollback(service, throwable);
    }

    protected PyFunction tryJythonFunction(PythonInterpreter interpreter, JythonHookFunction functionDefinition) {
        try {
            PyFunction function = (PyFunction)interpreter.get(functionDefinition.name, PyFunction.class);
            return function;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void invokeRollbackServiceFunction(PyFunction function, DataSetRegistrationService<T> service, Throwable throwable) {
        this.invokeFunction(function, service, throwable);
    }

    private void invokeRollbackTransactionFunction(PyFunction function, DataSetRegistrationService<T> service, DataSetRegistrationTransaction<T> transaction, DataSetStorageAlgorithmRunner<T> algorithmRunner, Throwable throwable) {
        this.invokeFunction(function, service, transaction, algorithmRunner, throwable);
    }

    private void invokeServiceTransactionFunction(PyFunction function, DataSetRegistrationService<T> service, DataSetRegistrationTransaction<T> transaction) {
        this.invokeFunction(function, service, transaction);
    }

    private void invokeDidEncounterSecondaryTransactionErrorsFunction(PyFunction function, DataSetRegistrationService<T> service, DataSetRegistrationTransaction<T> transaction, List<SecondaryTransactionFailure> secondaryErrors) {
        this.invokeFunction(function, service, transaction, secondaryErrors);
    }

    protected PyObject invokeFunction(PyFunction function, Object ... args) {
        PyObject[] pyArgs = new PyObject[args.length];
        int i = 0;
        while (i < args.length) {
            pyArgs[i] = Py.java2py((Object)args[i]);
            ++i;
        }
        return function.__call__(pyArgs);
    }

    protected PythonInterpreter getInterpreterFromService(DataSetRegistrationService<T> service) {
        PythonInterpreter interpreter = ((JythonDataSetRegistrationService)service).interpreter;
        return interpreter;
    }

    @Override
    protected IJavaDataSetRegistrationDropboxV2 getV2DropboxProgram(DataSetRegistrationService<T> service) {
        return new JythonAsJavaDataSetRegistrationDropboxV2Wrapper(this.getInterpreterFromService(service));
    }

    @Override
    public boolean shouldNotAddToFaultyPathsOrNull(File storeItem) {
        return false;
    }

    @Override
    protected IJavaDataSetRegistrationDropboxV1<T> getV1DropboxProgram() {
        return this.v1;
    }

    public static class JythonDataSetRegistrationService<T extends DataSetInformation>
    extends DataSetRegistrationService<T> {
        private final PythonInterpreter interpreter;

        public JythonDataSetRegistrationService(AbstractProgrammableTopLevelDataSetHandler<T> registrator, DataSetFile incomingDataSetFile, DataSetInformation userProvidedDataSetInformationOrNull, IDelegatedActionWithResult<Boolean> globalCleanAfterwardsAction, ITopLevelDataSetRegistratorDelegate delegate, PythonInterpreter interpreter, TopLevelDataSetRegistratorGlobalState globalState) {
            super(registrator, incomingDataSetFile, registrator.createObjectFactory(userProvidedDataSetInformationOrNull), globalCleanAfterwardsAction, delegate);
            interpreter.set(JythonTopLevelDataSetHandler.STATE_VARIABLE_NAME, globalState);
            this.interpreter = interpreter;
        }

        public PythonInterpreter getInterpreter() {
            return this.interpreter;
        }

        @Override
        public void cleanAfterRegistrationIfNecessary() {
            super.cleanAfterRegistrationIfNecessary();
            if (this.interpreter != null) {
                this.interpreter.releaseResources();
            }
        }
    }

    public static enum JythonHookFunction {
        PROCESS_FUNCTION("process", 1),
        ROLLBACK_SERVICE_FUNCTION_NAME("rollback_service", 2),
        ROLLBACK_TRANSACTION_FUNCTION_NAME("rollback_transaction", 4),
        COMMIT_TRANSACTION_FUNCTION_NAME("commit_transaction", 2),
        POST_STORAGE_FUNCTION_NAME("post_storage", 1),
        PRE_REGISTRATION_FUNCTION_NAME("pre_metadata_registration", 1),
        POST_REGISTRATION_FUNCTION_NAME("post_metadata_registration", 1),
        ROLLBACK_PRE_REGISTRATION_FUNCTION_NAME("rollback_pre_registration", 2),
        SHOULD_RETRY_PROCESS_FUNCTION_NAME("should_retry_processing", 2),
        DID_ENCOUNTER_SECONDARY_TRANSACTION_ERRORS_FUNCTION_NAME("did_encounter_secondary_transaction_errors", 3);

        public final String name;
        int argCount;

        private JythonHookFunction(String name, int argCount) {
            this.name = name;
            this.argCount = argCount;
        }
    }

    public static abstract class ProgrammableDropboxObjectFactory<T extends DataSetInformation>
    extends AbstractDataSetRegistrationDetailsFactory<T> {
        public ProgrammableDropboxObjectFactory(AbstractOmniscientTopLevelDataSetRegistrator.OmniscientTopLevelDataSetRegistratorState registratorState, DataSetInformation userProvidedDataSetInformationOrNull) {
            super(registratorState, userProvidedDataSetInformationOrNull);
        }

        public DataSetRegistrationDetails<T> createRegistrationDetails() {
            return this.createDataSetRegistrationDetails();
        }

        public Class<?> getClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }
}

