/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.threev;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.AbstractDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.DataSetNameEntitiesProvider;
import ch.systemsx.cisd.etlserver.DefaultDataSetInfoExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

abstract class AbstractDataSetInfoExtractorFor3V
extends AbstractDataSetInfoExtractor {
    @Private
    static final String DATA_SET_CODE_ENTITIES_GLUE = "data-set-code-entities-glue";
    private static final String DEFAULT_DATA_SET_CODE_ENTITIES_GLUE = ".";
    private final DefaultDataSetInfoExtractor codeExtractor;
    private final int[] dataSetCodeIndices;
    private final String dataSetCodeEntitiesGlue;

    public AbstractDataSetInfoExtractorFor3V(Properties properties, String indicesPropertyName) {
        super(properties);
        this.codeExtractor = new DefaultDataSetInfoExtractor(properties);
        String indicesAsString = PropertyUtils.getMandatoryProperty(properties, indicesPropertyName);
        String[] indicesAsStringArray = StringUtils.split((String)indicesAsString, (String)", ");
        this.dataSetCodeIndices = new int[indicesAsStringArray.length];
        int i = 0;
        while (i < indicesAsStringArray.length) {
            String index = indicesAsStringArray[i];
            try {
                this.dataSetCodeIndices[i] = Integer.parseInt(index);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationFailureException(String.valueOf(i + 1) + ". index in property '" + indicesPropertyName + "' isn't a number: " + indicesAsString);
            }
            ++i;
        }
        this.dataSetCodeEntitiesGlue = properties.getProperty(DATA_SET_CODE_ENTITIES_GLUE, DEFAULT_DATA_SET_CODE_ENTITIES_GLUE);
    }

    @Override
    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws UserFailureException, EnvironmentFailureException {
        DataSetInformation dataSetInfo = this.codeExtractor.getDataSetInformation(incomingDataSetPath, openbisService);
        DataSetNameEntitiesProvider entitiesProvider = new DataSetNameEntitiesProvider(incomingDataSetPath, this.entitySeparator, this.stripExtension);
        StringBuilder builder = new StringBuilder();
        int[] nArray = this.dataSetCodeIndices;
        int n = this.dataSetCodeIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (builder.length() > 0) {
                builder.append(this.dataSetCodeEntitiesGlue);
            }
            builder.append(entitiesProvider.getEntity(index));
            ++n2;
        }
        String code = builder.toString();
        this.setCodeFor(dataSetInfo, code);
        return dataSetInfo;
    }

    protected abstract void setCodeFor(DataSetInformation var1, String var2);
}

