/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.utils;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.IPostRegistrationAction;
import ch.systemsx.cisd.etlserver.utils.AbstractPreOrPostRegistrationExecutor;
import org.apache.log4j.Logger;

public class PostRegistrationExecutor
extends AbstractPreOrPostRegistrationExecutor
implements IPostRegistrationAction {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PostRegistrationExecutor.class);
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, PostRegistrationExecutor.class);

    public static IPostRegistrationAction create(String scriptPath) {
        if (scriptPath != null) {
            return new PostRegistrationExecutor(scriptPath);
        }
        operationLog.debug((Object)"No post-registration script found, skipping execution.");
        return new PostRegistrationEmptyScriptExecutor();
    }

    private PostRegistrationExecutor(String script) {
        super(script);
        operationLog.info((Object)(String.valueOf(this.getExecutorAdjectivalDescription()) + " script: " + script));
    }

    @Override
    public boolean execute(String dataSetCode, String dataSetAbsolutePathInStore) {
        return PostRegistrationExecutor.callScript(operationLog, machineLog, this.scriptPath, dataSetCode, dataSetAbsolutePathInStore);
    }

    @Override
    protected String getExecutorAdjectivalDescription() {
        return "post-registration";
    }

    private static class PostRegistrationEmptyScriptExecutor
    extends AbstractPreOrPostRegistrationExecutor.EmptyScriptExecutor
    implements IPostRegistrationAction {
        private PostRegistrationEmptyScriptExecutor() {
        }
    }
}

