/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.validation.IValidatorFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

abstract class AbstractValidatorFactory
implements IValidatorFactory {
    static final String ALLOW_EMPTY_VALUES_KEY = "allow-empty-values";
    static final String EMPTY_VALUE_SYNONYMS_KEY = "empty-value-synonyms";
    protected final boolean allowEmptyValues;
    protected final Set<String> emptyValueSynonyms;

    AbstractValidatorFactory(Properties properties) {
        this.allowEmptyValues = PropertyUtils.getBoolean(properties, ALLOW_EMPTY_VALUES_KEY, false);
        String property = properties.getProperty(EMPTY_VALUE_SYNONYMS_KEY);
        if (property == null) {
            this.emptyValueSynonyms = Collections.emptySet();
        } else {
            String[] synonyms = PropertyParametersUtil.parseItemisedProperty(property, EMPTY_VALUE_SYNONYMS_KEY);
            this.emptyValueSynonyms = new LinkedHashSet<String>(Arrays.asList(synonyms));
        }
    }
}

