/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.validation;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.validation.AnyValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.IValidator;
import ch.systemsx.cisd.etlserver.validation.IValidatorFactory;
import ch.systemsx.cisd.etlserver.validation.RegExBasedValidator;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

class UniqueValidatorFactory
implements IValidatorFactory {
    private final IValidator validator;

    UniqueValidatorFactory(Properties properties) {
        String regex = properties.getProperty("value-pattern");
        this.validator = regex == null ? AnyValidatorFactory.INSTANCE.createValidator(null) : new RegExBasedValidator(regex);
    }

    @Override
    public IValidator createValidator(String header) {
        return new IValidator(){
            private final Set<String> values = new HashSet<String>();

            @Override
            public void assertValid(String value) {
                UniqueValidatorFactory.this.validator.assertValid(value);
                if (this.values.contains(value)) {
                    throw new UserFailureException("The following value is not unique: " + value);
                }
                this.values.add(value);
            }
        };
    }
}

