/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.conversation.manager;

import ch.systemsx.cisd.common.serviceconversation.IServiceMessenger;
import ch.systemsx.cisd.common.serviceconversation.server.IService;
import ch.systemsx.cisd.common.serviceconversation.server.IServiceFactory;
import ch.systemsx.cisd.common.serviceconversation.server.ServiceConversationServer;
import ch.systemsx.cisd.openbis.common.conversation.message.ServiceConversationMethodInvocation;
import java.io.Serializable;

abstract class ServiceConversationServiceFactory
implements IServiceFactory {
    private ServiceConversationServer server;
    private String serviceName;
    private Object service;

    public ServiceConversationServiceFactory(ServiceConversationServer server, String serviceName, Object service) {
        this.server = server;
        this.serviceName = serviceName;
        this.service = service;
    }

    @Override
    public final String getServiceTypeId() {
        return this.serviceName;
    }

    @Override
    public IService create() {
        return new IService(){

            @Override
            public void run(IServiceMessenger messenger) {
                try {
                    ServiceConversationMethodInvocation call = (ServiceConversationMethodInvocation)messenger.receive(Serializable.class);
                    Serializable result = call.executeOn(ServiceConversationServiceFactory.this.service, ServiceConversationServiceFactory.this.server, messenger.getId(), ServiceConversationServiceFactory.this.getProgressInterval(messenger.getId()));
                    messenger.send(result);
                }
                finally {
                    ServiceConversationServiceFactory.this.onConversationFinish(messenger.getId());
                }
            }
        };
    }

    @Override
    public int getClientTimeoutMillis() {
        return -1;
    }

    protected abstract int getProgressInterval(String var1);

    protected abstract void onConversationFinish(String var1);

    @Override
    public boolean interruptServiceOnClientException() {
        return false;
    }
}

